/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.controller.admin;

import java.lang.invoke.MethodHandles;
import nl.b3p.tailormap.api.security.InvalidPasswordException;
import nl.b3p.tailormap.api.viewer.model.ErrorResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.http.converter.HttpMessageNotReadableException;
import org.springframework.lang.Nullable;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.context.request.WebRequest;

@RestControllerAdvice
public class RestExceptionHandler {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @ExceptionHandler(value={HttpMessageNotReadableException.class})
    @Nullable
    public ResponseEntity<Object> handleException(HttpMessageNotReadableException ex, WebRequest request) {
        logger.debug("Invalid message exception", (Throwable)ex);
        if (ex.getCause() != null && ex.getMostSpecificCause() instanceof InvalidPasswordException) {
            return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).contentType(MediaType.APPLICATION_JSON).body((Object)new ErrorResponse().code(HttpStatus.BAD_REQUEST.value()).message(((InvalidPasswordException)((Object)ex.getMostSpecificCause())).getOriginalMessage()));
        }
        return ResponseEntity.status((HttpStatusCode)HttpStatus.BAD_REQUEST).contentType(MediaType.APPLICATION_JSON).body((Object)new ErrorResponse().code(HttpStatus.BAD_REQUEST.value()).message(ex.getMostSpecificCause().getLocalizedMessage()));
    }
}

