/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.controller.admin;

import com.fasterxml.jackson.databind.ObjectMapper;
import io.micrometer.core.annotation.Timed;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import io.swagger.v3.oas.annotations.responses.ApiResponses;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.util.NoSuchElementException;
import java.util.concurrent.TimeUnit;
import nl.b3p.tailormap.api.geotools.featuresources.FeatureSourceFactoryHelper;
import nl.b3p.tailormap.api.persistence.SearchIndex;
import nl.b3p.tailormap.api.persistence.TMFeatureType;
import nl.b3p.tailormap.api.repository.FeatureSourceRepository;
import nl.b3p.tailormap.api.repository.FeatureTypeRepository;
import nl.b3p.tailormap.api.repository.GeoServiceRepository;
import nl.b3p.tailormap.api.repository.SearchIndexRepository;
import nl.b3p.tailormap.api.solr.SolrHelper;
import nl.b3p.tailormap.api.viewer.model.ErrorResponse;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.ConcurrentUpdateHttp2SolrClient;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.apache.solr.common.SolrException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
public class SolrAdminController {
    @Value(value="${tailormap-api.solr-url}")
    private String solrUrl;
    @Value(value="${tailormap-api.solr-core-name:tailormap}")
    private String solrCoreName;
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final FeatureSourceFactoryHelper featureSourceFactoryHelper;
    private final FeatureSourceRepository featureSourceRepository;
    private final FeatureTypeRepository featureTypeRepository;
    private final GeoServiceRepository geoServiceRepository;
    private final SearchIndexRepository searchIndexRepository;

    public SolrAdminController(FeatureSourceFactoryHelper featureSourceFactoryHelper, FeatureSourceRepository featureSourceRepository, FeatureTypeRepository featureTypeRepository, GeoServiceRepository geoServiceRepository, SearchIndexRepository searchIndexRepository) {
        this.featureSourceFactoryHelper = featureSourceFactoryHelper;
        this.featureSourceRepository = featureSourceRepository;
        this.featureTypeRepository = featureTypeRepository;
        this.geoServiceRepository = geoServiceRepository;
        this.searchIndexRepository = searchIndexRepository;
    }

    @Operation(summary="Ping Solr", description="Ping Solr to check if it is available")
    @ApiResponses(value={@ApiResponse(responseCode="200", description="Solr is available", content={@Content(mediaType="application/json", schema=@Schema(example="{\"status\":\"OK\",\"timeElapsed\":1}"))}), @ApiResponse(responseCode="500", description="Solr is not available", content={@Content(mediaType="application/json", schema=@Schema(example="{\"message\":\"Some error message..\",\"code\":500}"))})})
    @GetMapping(path={"${tailormap-api.admin.base-path}/index/ping"}, produces={"application/json"})
    public ResponseEntity<?> pingSolr() {
        ResponseEntity responseEntity;
        block8: {
            SolrClient solrClient = this.getSolrClient();
            try {
                SolrPingResponse ping = solrClient.ping();
                logger.info("Solr ping status {}", ping.getResponse().get("status"));
                responseEntity = ResponseEntity.ok((Object)new ObjectMapper().createObjectNode().put("status", ping.getResponse().get("status").toString()).put("timeElapsed", ping.getElapsedTime()));
                if (solrClient == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (solrClient != null) {
                        try {
                            solrClient.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException | SolrServerException e) {
                    logger.error("Error pinging solr", e);
                    return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).contentType(MediaType.APPLICATION_JSON).body((Object)new ErrorResponse().message(e.getLocalizedMessage()).code(HttpStatus.INTERNAL_SERVER_ERROR.value()));
                }
            }
            solrClient.close();
        }
        return responseEntity;
    }

    private SolrClient getSolrClient() {
        return new ConcurrentUpdateHttp2SolrClient.Builder(this.solrUrl + this.solrCoreName, ((Http2SolrClient.Builder)((Http2SolrClient.Builder)((Http2SolrClient.Builder)new Http2SolrClient.Builder().withFollowRedirects(true)).withConnectionTimeout(10000L, TimeUnit.MILLISECONDS)).withRequestTimeout(60000L, TimeUnit.MILLISECONDS)).build()).withQueueSize(2000).withThreadCount(10).build();
    }

    @Operation(summary="Create or update a feature type index", description="Create or update a feature type index for a layer, will erase existing index if present")
    @ApiResponses(value={@ApiResponse(responseCode="202", description="Index create or update request accepted"), @ApiResponse(responseCode="404", description="Layer does not have feature type", content={@Content(mediaType="application/json", schema=@Schema(example="{\"message\":\"Layer does not have feature type\",\"code\":404}"))}), @ApiResponse(responseCode="500", description="Error while indexing", content={@Content(mediaType="application/json", schema=@Schema(example="{\"message\":\"Some error message..\",\"code\":500}"))})})
    @Transactional
    @Timed(value="index_feature_type", description="time spent to index feature type")
    @PutMapping(path={"${tailormap-api.admin.base-path}/index/{searchIndexId}"}, produces={"application/json"})
    public ResponseEntity<?> index(@PathVariable Long searchIndexId) {
        SearchIndex searchIndex = (SearchIndex)this.searchIndexRepository.findById(searchIndexId).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Search index not found"));
        TMFeatureType indexingFT = (TMFeatureType)this.featureTypeRepository.findById(searchIndex.getFeatureTypeId()).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Feature type not found"));
        boolean createNewIndex = null == searchIndex.getLastIndexed() || searchIndex.getStatus() == SearchIndex.Status.INITIAL;
        try (SolrClient solrClient = this.getSolrClient();
             SolrHelper solrHelper = new SolrHelper(solrClient);){
            solrHelper.addFeatureTypeIndex(searchIndex, indexingFT, this.featureSourceFactoryHelper);
            this.searchIndexRepository.save(searchIndex);
        }
        catch (IOException | UnsupportedOperationException | SolrServerException | SolrException e) {
            logger.error("Error indexing", e);
            searchIndex.setStatus(SearchIndex.Status.ERROR);
            this.searchIndexRepository.save(searchIndex);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).contentType(MediaType.APPLICATION_JSON).body((Object)new ErrorResponse().message(e.getLocalizedMessage()).code(HttpStatus.INTERNAL_SERVER_ERROR.value()));
        }
        if (createNewIndex) {
            logger.info("Created new index for search index {}", (Object)searchIndexId);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.CREATED).build();
        }
        logger.info("Updated index for search index {}", (Object)searchIndexId);
        return ResponseEntity.accepted().build();
    }

    @Operation(summary="Clear index for a feature type", description="Clear index for the feature type")
    @ApiResponses(value={@ApiResponse(responseCode="204", description="Index cleared"), @ApiResponse(responseCode="404", description="Index not configured for feature type"), @ApiResponse(responseCode="500", description="Error while clearing index", content={@Content(mediaType="application/json", schema=@Schema(example="{\"message\":\"Some error message..\",\"code\":500}"))})})
    @Timed(value="index_delete", description="time spent to delete an index of a feature type")
    @DeleteMapping(path={"${tailormap-api.admin.base-path}/index/{searchIndexId}"}, produces={"application/json"})
    @Transactional
    public ResponseEntity<?> clearIndex(@PathVariable Long searchIndexId) {
        try (SolrClient solrClient = this.getSolrClient();
             SolrHelper solrHelper = new SolrHelper(solrClient);){
            solrHelper.clearIndexForLayer(searchIndexId);
            SearchIndex searchIndex = (SearchIndex)this.searchIndexRepository.findById(searchIndexId).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Search index not found"));
            searchIndex.setLastIndexed(null).setStatus(SearchIndex.Status.INITIAL).setComment("Index cleared");
            this.searchIndexRepository.save(searchIndex);
        }
        catch (IOException | NoSuchElementException | SolrServerException e) {
            logger.warn("Error clearing index", e);
            return ResponseEntity.status((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR).contentType(MediaType.APPLICATION_JSON).body((Object)new ErrorResponse().message(e.getLocalizedMessage()).code(HttpStatus.INTERNAL_SERVER_ERROR.value()));
        }
        logger.info("Index cleared for index {}", (Object)searchIndexId);
        return ResponseEntity.noContent().build();
    }
}

