/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.geotools.wfs;

import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.namespace.NamespaceContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import nl.b3p.tailormap.api.geotools.wfs.SimpleWFSLayerDescription;
import nl.b3p.tailormap.api.util.HttpProxyUtil;
import org.geotools.http.HTTPClient;
import org.geotools.http.SimpleHttpClient;
import org.geotools.ows.ServiceException;
import org.geotools.ows.wms.LayerDescription;
import org.geotools.ows.wms.WMS1_1_1;
import org.geotools.ows.wms.WebMapServer;
import org.geotools.ows.wms.request.DescribeLayerRequest;
import org.geotools.ows.wms.response.DescribeLayerResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.util.xml.DomUtils;
import org.springframework.util.xml.SimpleNamespaceContext;
import org.springframework.web.util.UriComponentsBuilder;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SimpleWFSHelper {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final int TIMEOUT = 5000;

    private static HttpClient getDefaultHttpClient() {
        return HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build();
    }

    public static URI getWFSRequestURL(String wfsUrl, String request) {
        return SimpleWFSHelper.getWFSRequestURL(wfsUrl, request, null);
    }

    public static URI getWFSRequestURL(String wfsUrl, String request, MultiValueMap<String, String> parameters) {
        return SimpleWFSHelper.getWFSRequestURL(wfsUrl, request, "1.1.0", parameters);
    }

    public static URI getWFSRequestURL(String wfsUrl, String request, String version, MultiValueMap<String, String> parameters) {
        return SimpleWFSHelper.getOGCRequestURL(wfsUrl, "WFS", version, request, parameters);
    }

    public static URI getOGCRequestURL(String url, String service, String version, String request, MultiValueMap<String, String> parameters) {
        LinkedMultiValueMap params = new LinkedMultiValueMap();
        params.add((Object)"SERVICE", (Object)service);
        params.add((Object)"VERSION", (Object)version);
        params.add((Object)"REQUEST", (Object)request);
        if (parameters != null) {
            parameters.replaceAll((key, values) -> values.stream().map(s -> URLEncoder.encode(s, StandardCharsets.UTF_8)).collect(Collectors.toList()));
            params.addAll(parameters);
        }
        return UriComponentsBuilder.fromHttpUrl((String)url).replaceQueryParams((MultiValueMap)params).build(true).toUri();
    }

    public static List<String> getOutputFormats(String wfsUrl, String typeName, String username, String password) throws Exception {
        return SimpleWFSHelper.getOutputFormats(wfsUrl, typeName, username, password, SimpleWFSHelper.getDefaultHttpClient());
    }

    public static List<String> getOutputFormats(String wfsUrl, String typeName, String username, String password, HttpClient httpClient) throws Exception {
        URI wfsGetCapabilities = SimpleWFSHelper.getWFSRequestURL(wfsUrl, "GetCapabilities");
        HttpRequest.Builder requestBuilder = HttpRequest.newBuilder().uri(wfsGetCapabilities);
        HttpProxyUtil.setHttpBasicAuthenticationHeader(requestBuilder, username, password);
        HttpResponse<InputStream> response = httpClient.send(requestBuilder.build(), HttpResponse.BodyHandlers.ofInputStream());
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setNamespaceAware(true);
        documentBuilderFactory.setExpandEntityReferences(false);
        documentBuilderFactory.setValidating(false);
        documentBuilderFactory.setXIncludeAware(false);
        documentBuilderFactory.setCoalescing(true);
        documentBuilderFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document doc = documentBuilder.parse(response.body());
        boolean wfs2 = "2.0.0".equals(doc.getDocumentElement().getAttribute("version"));
        XPath xPath = XPathFactory.newInstance().newXPath();
        SimpleNamespaceContext namespaceContext = new SimpleNamespaceContext();
        namespaceContext.bindNamespaceUri("ows", "http://www.opengis.net/ows" + (wfs2 ? "/1.1" : ""));
        namespaceContext.bindNamespaceUri("wfs", "http://www.opengis.net/wfs" + (wfs2 ? "/2.0" : ""));
        xPath.setNamespaceContext((NamespaceContext)namespaceContext);
        List<String> outputFormats = null;
        NodeList featureTypes = (NodeList)xPath.compile("/wfs:WFS_Capabilities/wfs:FeatureTypeList/wfs:FeatureType").evaluate(doc, XPathConstants.NODESET);
        for (int i = 0; i < featureTypes.getLength(); ++i) {
            Element n = (Element)featureTypes.item(i);
            Element name = DomUtils.getChildElementByTagName((Element)n, (String)"Name");
            if (name == null || !typeName.equals(DomUtils.getTextValue((Element)name))) continue;
            Element formatsNode = DomUtils.getChildElementByTagName((Element)n, (String)"OutputFormats");
            if (formatsNode == null) break;
            outputFormats = DomUtils.getChildElementsByTagName((Element)formatsNode, (String)"Format").stream().map(DomUtils::getTextValue).collect(Collectors.toList());
            break;
        }
        if (outputFormats == null) {
            String xpathExpr = "/wfs:WFS_Capabilities/ows:OperationsMetadata/ows:Operation[@name='GetFeature']/ows:Parameter[@name='outputFormat']//ows:Value";
            NodeList nodes = (NodeList)xPath.compile(xpathExpr).evaluate(doc, XPathConstants.NODESET);
            outputFormats = new ArrayList<String>();
            for (int i = 0; i < nodes.getLength(); ++i) {
                outputFormats.add(DomUtils.getTextValue((Element)((Element)nodes.item(i))));
            }
        }
        return outputFormats;
    }

    public static WebMapServer getWebMapServer(String url, String username, String password) throws IOException, ServiceException {
        SimpleHttpClient client = new SimpleHttpClient();
        client.setUser(username);
        client.setPassword(password);
        client.setConnectTimeout(5000);
        client.setReadTimeout(5000);
        return new WebMapServer(new URL(url), (HTTPClient)client);
    }

    public static SimpleWFSLayerDescription describeWMSLayer(String url, String username, String password, String layerName) {
        return SimpleWFSHelper.describeWMSLayers(url, username, password, List.of(layerName)).get(layerName);
    }

    public static Map<String, SimpleWFSLayerDescription> describeWMSLayers(String url, String username, String password, List<String> layers) {
        try {
            WebMapServer wms = SimpleWFSHelper.getWebMapServer(url, username, password);
            DescribeLayerRequest describeLayerRequest = new WMS1_1_1().createDescribeLayerRequest(new URL(url));
            describeLayerRequest.setProperty("VERSION", "1.1.1");
            describeLayerRequest.setLayers(String.join((CharSequence)",", layers));
            DescribeLayerResponse describeLayerResponse = wms.issueRequest(describeLayerRequest);
            HashMap<String, SimpleWFSLayerDescription> descriptions = new HashMap<String, SimpleWFSLayerDescription>();
            for (LayerDescription ld : describeLayerResponse.getLayerDescs()) {
                String wfsUrl = SimpleWFSHelper.getWfsUrl(ld, wms);
                if (wfsUrl == null || ld.getQueries() == null || ld.getQueries().length == 0) continue;
                descriptions.put(ld.getName(), new SimpleWFSLayerDescription(wfsUrl, ld.getQueries()));
            }
            return Collections.unmodifiableMap(descriptions);
        }
        catch (Exception e) {
            String msg = String.format("Error in DescribeLayer request to WMS \"%s\": %s: %s", url, e.getClass(), e.getMessage());
            if (logger.isTraceEnabled()) {
                logger.trace(msg, (Throwable)e);
            } else {
                logger.debug(msg + ". Set log level to TRACE for stacktrace.");
            }
            return Collections.emptyMap();
        }
    }

    private static String getWfsUrl(LayerDescription ld, WebMapServer wms) {
        String wfsUrl;
        String string = wfsUrl = ld.getWfs() != null ? ld.getWfs().toString() : null;
        if (wfsUrl == null && "WFS".equalsIgnoreCase(ld.getOwsType())) {
            wfsUrl = ld.getOwsURL().toString();
        }
        if (wfsUrl == null) {
            wfsUrl = wms.getInfo().getSource().toString();
        }
        return wfsUrl;
    }
}

