/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nl.b3p.tailormap.api.persistence.json.TailormapObjectRef;

@Schema(name="CatalogNode", description="Categorization for items in the catalog.")
public class CatalogNode
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String id;
    private String title;
    private Boolean root;
    @Valid
    private List<String> children = new ArrayList<String>();
    @Valid
    private @Valid List<@Valid TailormapObjectRef> items = new ArrayList<TailormapObjectRef>();

    public CatalogNode id(String id) {
        this.id = id;
        return this;
    }

    @Schema(name="id", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="id")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public CatalogNode title(String title) {
        this.title = title;
        return this;
    }

    @Schema(name="title", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public CatalogNode root(Boolean root) {
        this.root = root;
        return this;
    }

    @Schema(name="root", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="root")
    public Boolean getRoot() {
        return this.root;
    }

    public void setRoot(Boolean root) {
        this.root = root;
    }

    public CatalogNode children(List<String> children) {
        this.children = children;
        return this;
    }

    public CatalogNode addChildrenItem(String childrenItem) {
        if (this.children == null) {
            this.children = new ArrayList<String>();
        }
        this.children.add(childrenItem);
        return this;
    }

    @Schema(name="children", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="children")
    public List<String> getChildren() {
        return this.children;
    }

    public void setChildren(List<String> children) {
        this.children = children;
    }

    public CatalogNode items(List<@Valid TailormapObjectRef> items) {
        this.items = items;
        return this;
    }

    public CatalogNode addItemsItem(TailormapObjectRef itemsItem) {
        if (this.items == null) {
            this.items = new ArrayList<TailormapObjectRef>();
        }
        this.items.add(itemsItem);
        return this;
    }

    @Valid
    @Schema(name="items", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="items")
    public @Valid List<@Valid TailormapObjectRef> getItems() {
        return this.items;
    }

    public void setItems(List<@Valid TailormapObjectRef> items) {
        this.items = items;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CatalogNode catalogNode = (CatalogNode)o;
        return Objects.equals(this.id, catalogNode.id) && Objects.equals(this.title, catalogNode.title) && Objects.equals(this.root, catalogNode.root) && Objects.equals(this.children, catalogNode.children) && Objects.equals(this.items, catalogNode.items);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.title, this.root, this.children, this.items);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CatalogNode {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    root: ").append(this.toIndentedString(this.root)).append("\n");
        sb.append("    children: ").append(this.toIndentedString(this.children)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

