/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nl.b3p.tailormap.api.persistence.json.AuthorizationRule;
import nl.b3p.tailormap.api.persistence.json.FeatureTypeRef;
import nl.b3p.tailormap.api.persistence.json.SearchIndexRef;
import nl.b3p.tailormap.api.persistence.json.TileLayerHiDpiMode;

@Schema(name="GeoServiceDefaultLayerSettings", description="Default settings for all layers of this service which can be overridden on a per-layer basis.")
public class GeoServiceDefaultLayerSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String title = null;
    private Boolean hiDpiDisabled = null;
    private FeatureTypeRef featureType;
    private SearchIndexRef searchIndex;
    private String attribution = null;
    private String description = null;
    private String legendImageId = null;
    @Valid
    private @Valid List<@Valid AuthorizationRule> authorizationRules = new ArrayList<AuthorizationRule>();
    private Boolean tilingDisabled = null;
    private Integer tilingGutter = null;
    private TileLayerHiDpiMode hiDpiMode;
    private String hiDpiSubstituteLayer = null;

    public GeoServiceDefaultLayerSettings title(String title) {
        this.title = title;
        return this;
    }

    @Schema(name="title", description="Override default title, null if not overridden.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public GeoServiceDefaultLayerSettings hiDpiDisabled(Boolean hiDpiDisabled) {
        this.hiDpiDisabled = hiDpiDisabled;
        return this;
    }

    @Schema(name="hiDpiDisabled", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="hiDpiDisabled")
    public Boolean getHiDpiDisabled() {
        return this.hiDpiDisabled;
    }

    public void setHiDpiDisabled(Boolean hiDpiDisabled) {
        this.hiDpiDisabled = hiDpiDisabled;
    }

    public GeoServiceDefaultLayerSettings featureType(FeatureTypeRef featureType) {
        this.featureType = featureType;
        return this;
    }

    @Valid
    @Schema(name="featureType", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="featureType")
    public FeatureTypeRef getFeatureType() {
        return this.featureType;
    }

    public void setFeatureType(FeatureTypeRef featureType) {
        this.featureType = featureType;
    }

    public GeoServiceDefaultLayerSettings searchIndex(SearchIndexRef searchIndex) {
        this.searchIndex = searchIndex;
        return this;
    }

    @Valid
    @Schema(name="searchIndex", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="searchIndex")
    public SearchIndexRef getSearchIndex() {
        return this.searchIndex;
    }

    public void setSearchIndex(SearchIndexRef searchIndex) {
        this.searchIndex = searchIndex;
    }

    public GeoServiceDefaultLayerSettings attribution(String attribution) {
        this.attribution = attribution;
        return this;
    }

    @Schema(name="attribution", description="Attribution to show for this layer.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="attribution")
    public String getAttribution() {
        return this.attribution;
    }

    public void setAttribution(String attribution) {
        this.attribution = attribution;
    }

    public GeoServiceDefaultLayerSettings description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", description="Description to show for this layer.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public GeoServiceDefaultLayerSettings legendImageId(String legendImageId) {
        this.legendImageId = legendImageId;
        return this;
    }

    @Schema(name="legendImageId", description="ID of uploaded legend image", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="legendImageId")
    public String getLegendImageId() {
        return this.legendImageId;
    }

    public void setLegendImageId(String legendImageId) {
        this.legendImageId = legendImageId;
    }

    public GeoServiceDefaultLayerSettings authorizationRules(List<@Valid AuthorizationRule> authorizationRules) {
        this.authorizationRules = authorizationRules;
        return this;
    }

    public GeoServiceDefaultLayerSettings addAuthorizationRulesItem(AuthorizationRule authorizationRulesItem) {
        if (this.authorizationRules == null) {
            this.authorizationRules = new ArrayList<AuthorizationRule>();
        }
        this.authorizationRules.add(authorizationRulesItem);
        return this;
    }

    @Valid
    @Schema(name="authorizationRules", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="authorizationRules")
    public @Valid List<@Valid AuthorizationRule> getAuthorizationRules() {
        return this.authorizationRules;
    }

    public void setAuthorizationRules(List<@Valid AuthorizationRule> authorizationRules) {
        this.authorizationRules = authorizationRules;
    }

    public GeoServiceDefaultLayerSettings tilingDisabled(Boolean tilingDisabled) {
        this.tilingDisabled = tilingDisabled;
        return this;
    }

    @NotNull
    @Schema(name="tilingDisabled", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="tilingDisabled")
    public Boolean getTilingDisabled() {
        return this.tilingDisabled;
    }

    public void setTilingDisabled(Boolean tilingDisabled) {
        this.tilingDisabled = tilingDisabled;
    }

    public GeoServiceDefaultLayerSettings tilingGutter(Integer tilingGutter) {
        this.tilingGutter = tilingGutter;
        return this;
    }

    @NotNull
    @Schema(name="tilingGutter", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="tilingGutter")
    public Integer getTilingGutter() {
        return this.tilingGutter;
    }

    public void setTilingGutter(Integer tilingGutter) {
        this.tilingGutter = tilingGutter;
    }

    public GeoServiceDefaultLayerSettings hiDpiMode(TileLayerHiDpiMode hiDpiMode) {
        this.hiDpiMode = hiDpiMode;
        return this;
    }

    @Valid
    @Schema(name="hiDpiMode", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="hiDpiMode")
    public TileLayerHiDpiMode getHiDpiMode() {
        return this.hiDpiMode;
    }

    public void setHiDpiMode(TileLayerHiDpiMode hiDpiMode) {
        this.hiDpiMode = hiDpiMode;
    }

    public GeoServiceDefaultLayerSettings hiDpiSubstituteLayer(String hiDpiSubstituteLayer) {
        this.hiDpiSubstituteLayer = hiDpiSubstituteLayer;
        return this;
    }

    @Schema(name="hiDpiSubstituteLayer", description="Layer name of this service to substitute when rendering at high dpi.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="hiDpiSubstituteLayer")
    public String getHiDpiSubstituteLayer() {
        return this.hiDpiSubstituteLayer;
    }

    public void setHiDpiSubstituteLayer(String hiDpiSubstituteLayer) {
        this.hiDpiSubstituteLayer = hiDpiSubstituteLayer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoServiceDefaultLayerSettings geoServiceDefaultLayerSettings = (GeoServiceDefaultLayerSettings)o;
        return Objects.equals(this.title, geoServiceDefaultLayerSettings.title) && Objects.equals(this.hiDpiDisabled, geoServiceDefaultLayerSettings.hiDpiDisabled) && Objects.equals(this.featureType, geoServiceDefaultLayerSettings.featureType) && Objects.equals(this.searchIndex, geoServiceDefaultLayerSettings.searchIndex) && Objects.equals(this.attribution, geoServiceDefaultLayerSettings.attribution) && Objects.equals(this.description, geoServiceDefaultLayerSettings.description) && Objects.equals(this.legendImageId, geoServiceDefaultLayerSettings.legendImageId) && Objects.equals(this.authorizationRules, geoServiceDefaultLayerSettings.authorizationRules) && Objects.equals(this.tilingDisabled, geoServiceDefaultLayerSettings.tilingDisabled) && Objects.equals(this.tilingGutter, geoServiceDefaultLayerSettings.tilingGutter) && Objects.equals((Object)this.hiDpiMode, (Object)geoServiceDefaultLayerSettings.hiDpiMode) && Objects.equals(this.hiDpiSubstituteLayer, geoServiceDefaultLayerSettings.hiDpiSubstituteLayer);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.title, this.hiDpiDisabled, this.featureType, this.searchIndex, this.attribution, this.description, this.legendImageId, this.authorizationRules, this.tilingDisabled, this.tilingGutter, this.hiDpiMode, this.hiDpiSubstituteLayer});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GeoServiceDefaultLayerSettings {\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    hiDpiDisabled: ").append(this.toIndentedString(this.hiDpiDisabled)).append("\n");
        sb.append("    featureType: ").append(this.toIndentedString(this.featureType)).append("\n");
        sb.append("    searchIndex: ").append(this.toIndentedString(this.searchIndex)).append("\n");
        sb.append("    attribution: ").append(this.toIndentedString(this.attribution)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    legendImageId: ").append(this.toIndentedString(this.legendImageId)).append("\n");
        sb.append("    authorizationRules: ").append(this.toIndentedString(this.authorizationRules)).append("\n");
        sb.append("    tilingDisabled: ").append(this.toIndentedString(this.tilingDisabled)).append("\n");
        sb.append("    tilingGutter: ").append(this.toIndentedString(this.tilingGutter)).append("\n");
        sb.append("    hiDpiMode: ").append(this.toIndentedString((Object)this.hiDpiMode)).append("\n");
        sb.append("    hiDpiSubstituteLayer: ").append(this.toIndentedString(this.hiDpiSubstituteLayer)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

