/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nl.b3p.tailormap.api.persistence.json.AuthorizationRule;
import nl.b3p.tailormap.api.persistence.json.FeatureTypeRef;
import nl.b3p.tailormap.api.persistence.json.SearchIndexRef;

@Schema(name="Tileset3DLayerSettings", description="Settings applying to a 3D Tileset layer.")
public class Tileset3DLayerSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String title = null;
    private Boolean hiDpiDisabled = null;
    private FeatureTypeRef featureType;
    private SearchIndexRef searchIndex;
    private String attribution = null;
    private String description = null;
    private String legendImageId = null;
    @Valid
    private @Valid List<@Valid AuthorizationRule> authorizationRules = new ArrayList<AuthorizationRule>();

    public Tileset3DLayerSettings title(String title) {
        this.title = title;
        return this;
    }

    @Schema(name="title", description="Override default title, null if not overridden.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Tileset3DLayerSettings hiDpiDisabled(Boolean hiDpiDisabled) {
        this.hiDpiDisabled = hiDpiDisabled;
        return this;
    }

    @Schema(name="hiDpiDisabled", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="hiDpiDisabled")
    public Boolean getHiDpiDisabled() {
        return this.hiDpiDisabled;
    }

    public void setHiDpiDisabled(Boolean hiDpiDisabled) {
        this.hiDpiDisabled = hiDpiDisabled;
    }

    public Tileset3DLayerSettings featureType(FeatureTypeRef featureType) {
        this.featureType = featureType;
        return this;
    }

    @Valid
    @Schema(name="featureType", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="featureType")
    public FeatureTypeRef getFeatureType() {
        return this.featureType;
    }

    public void setFeatureType(FeatureTypeRef featureType) {
        this.featureType = featureType;
    }

    public Tileset3DLayerSettings searchIndex(SearchIndexRef searchIndex) {
        this.searchIndex = searchIndex;
        return this;
    }

    @Valid
    @Schema(name="searchIndex", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="searchIndex")
    public SearchIndexRef getSearchIndex() {
        return this.searchIndex;
    }

    public void setSearchIndex(SearchIndexRef searchIndex) {
        this.searchIndex = searchIndex;
    }

    public Tileset3DLayerSettings attribution(String attribution) {
        this.attribution = attribution;
        return this;
    }

    @Schema(name="attribution", description="Attribution to show for this layer.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="attribution")
    public String getAttribution() {
        return this.attribution;
    }

    public void setAttribution(String attribution) {
        this.attribution = attribution;
    }

    public Tileset3DLayerSettings description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", description="Description to show for this layer.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Tileset3DLayerSettings legendImageId(String legendImageId) {
        this.legendImageId = legendImageId;
        return this;
    }

    @Schema(name="legendImageId", description="ID of uploaded legend image", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="legendImageId")
    public String getLegendImageId() {
        return this.legendImageId;
    }

    public void setLegendImageId(String legendImageId) {
        this.legendImageId = legendImageId;
    }

    public Tileset3DLayerSettings authorizationRules(List<@Valid AuthorizationRule> authorizationRules) {
        this.authorizationRules = authorizationRules;
        return this;
    }

    public Tileset3DLayerSettings addAuthorizationRulesItem(AuthorizationRule authorizationRulesItem) {
        if (this.authorizationRules == null) {
            this.authorizationRules = new ArrayList<AuthorizationRule>();
        }
        this.authorizationRules.add(authorizationRulesItem);
        return this;
    }

    @Valid
    @Schema(name="authorizationRules", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="authorizationRules")
    public @Valid List<@Valid AuthorizationRule> getAuthorizationRules() {
        return this.authorizationRules;
    }

    public void setAuthorizationRules(List<@Valid AuthorizationRule> authorizationRules) {
        this.authorizationRules = authorizationRules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Tileset3DLayerSettings tileset3DLayerSettings = (Tileset3DLayerSettings)o;
        return Objects.equals(this.title, tileset3DLayerSettings.title) && Objects.equals(this.hiDpiDisabled, tileset3DLayerSettings.hiDpiDisabled) && Objects.equals(this.featureType, tileset3DLayerSettings.featureType) && Objects.equals(this.searchIndex, tileset3DLayerSettings.searchIndex) && Objects.equals(this.attribution, tileset3DLayerSettings.attribution) && Objects.equals(this.description, tileset3DLayerSettings.description) && Objects.equals(this.legendImageId, tileset3DLayerSettings.legendImageId) && Objects.equals(this.authorizationRules, tileset3DLayerSettings.authorizationRules);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.hiDpiDisabled, this.featureType, this.searchIndex, this.attribution, this.description, this.legendImageId, this.authorizationRules);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Tileset3DLayerSettings {\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    hiDpiDisabled: ").append(this.toIndentedString(this.hiDpiDisabled)).append("\n");
        sb.append("    featureType: ").append(this.toIndentedString(this.featureType)).append("\n");
        sb.append("    searchIndex: ").append(this.toIndentedString(this.searchIndex)).append("\n");
        sb.append("    attribution: ").append(this.toIndentedString(this.attribution)).append("\n");
        sb.append("    description: ").append(this.toIndentedString(this.description)).append("\n");
        sb.append("    legendImageId: ").append(this.toIndentedString(this.legendImageId)).append("\n");
        sb.append("    authorizationRules: ").append(this.toIndentedString(this.authorizationRules)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

