/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.viewer.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import jakarta.validation.constraints.NotNull;
import java.io.Serializable;
import java.util.Objects;
import nl.b3p.tailormap.api.persistence.json.Bounds;

@Schema(name="TMCoordinateReferenceSystem", description="CRS information")
public class TMCoordinateReferenceSystem
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String code;
    private String definition;
    private Bounds bounds;
    private String unit = null;

    public TMCoordinateReferenceSystem code(String code) {
        this.code = code;
        return this;
    }

    @NotNull
    @Schema(name="code", example="EPSG:28992", description="The CRS identifier", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="code")
    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public TMCoordinateReferenceSystem definition(String definition) {
        this.definition = definition;
        return this;
    }

    @NotNull
    @Schema(name="definition", example="PROJCS[\"Amersfoort / RD New\", GEOGCS[\"Amersfoort\", DATUM[\"Amersfoort\", SPHEROID[\"Bessel 1841\", 6377397.155, 299.1528128, AUTHORITY[\"EPSG\",\"7004\"]], TOWGS84[565.2369, 50.0087, 465.658, -0.40685733032239757, -0.3507326765425626, 1.8703473836067956, 4.0812], AUTHORITY[\"EPSG\",\"6289\"]], PRIMEM[\"Greenwich\", 0.0, AUTHORITY[\"EPSG\",\"8901\"]], UNIT[\"degree\", 0.017453292519943295], AXIS[\"Geodetic latitude\", NORTH], AXIS[\"Geodetic longitude\", EAST], AUTHORITY[\"EPSG\",\"4289\"]], PROJECTION[\"Oblique_Stereographic\", AUTHORITY[\"EPSG\",\"9809\"]], PARAMETER[\"central_meridian\", 5.387638888888891], PARAMETER[\"latitude_of_origin\", 52.15616055555556], PARAMETER[\"scale_factor\", 0.9999079], PARAMETER[\"false_easting\", 155000.0], PARAMETER[\"false_northing\", 463000.0], UNIT[\"m\", 1.0], AXIS[\"Easting\", EAST], AXIS[\"Northing\", NORTH], AUTHORITY[\"EPSG\",\"28992\"]]", description="CRS definition in WKT format", requiredMode=Schema.RequiredMode.REQUIRED)
    @JsonProperty(value="definition")
    public String getDefinition() {
        return this.definition;
    }

    public void setDefinition(String definition) {
        this.definition = definition;
    }

    public TMCoordinateReferenceSystem bounds(Bounds bounds) {
        this.bounds = bounds;
        return this;
    }

    @Valid
    @Schema(name="bounds", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="bounds")
    public Bounds getBounds() {
        return this.bounds;
    }

    public void setBounds(Bounds bounds) {
        this.bounds = bounds;
    }

    public TMCoordinateReferenceSystem unit(String unit) {
        this.unit = unit;
        return this;
    }

    @Schema(name="unit", example="m", description="The unit if all axis use the same unit, null otherwise", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="unit")
    public String getUnit() {
        return this.unit;
    }

    public void setUnit(String unit) {
        this.unit = unit;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TMCoordinateReferenceSystem tmCoordinateReferenceSystem = (TMCoordinateReferenceSystem)o;
        return Objects.equals(this.code, tmCoordinateReferenceSystem.code) && Objects.equals(this.definition, tmCoordinateReferenceSystem.definition) && Objects.equals(this.bounds, tmCoordinateReferenceSystem.bounds) && Objects.equals(this.unit, tmCoordinateReferenceSystem.unit);
    }

    public int hashCode() {
        return Objects.hash(this.code, this.definition, this.bounds, this.unit);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TMCoordinateReferenceSystem {\n");
        sb.append("    code: ").append(this.toIndentedString(this.code)).append("\n");
        sb.append("    definition: ").append(this.toIndentedString(this.definition)).append("\n");
        sb.append("    bounds: ").append(this.toIndentedString(this.bounds)).append("\n");
        sb.append("    unit: ").append(this.toIndentedString(this.unit)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

