/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.viewer.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import nl.b3p.tailormap.api.viewer.model.AdditionalProperty;

@Schema(name="UserResponse", description="Information about authentication status and user information")
public class UserResponse
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Boolean isAuthenticated;
    private String username;
    @Valid
    private Set<String> roles = new LinkedHashSet<String>();
    @Valid
    private @Valid List<@Valid AdditionalProperty> properties = new ArrayList<AdditionalProperty>();
    @Valid
    private @Valid List<@Valid AdditionalProperty> groupProperties = new ArrayList<AdditionalProperty>();

    public UserResponse isAuthenticated(Boolean isAuthenticated) {
        this.isAuthenticated = isAuthenticated;
        return this;
    }

    @Schema(name="isAuthenticated", description="true if the user is authenticated", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="isAuthenticated")
    public Boolean getIsAuthenticated() {
        return this.isAuthenticated;
    }

    public void setIsAuthenticated(Boolean isAuthenticated) {
        this.isAuthenticated = isAuthenticated;
    }

    public UserResponse username(String username) {
        this.username = username;
        return this;
    }

    @Schema(name="username", description="username of the authenticated user", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="username")
    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public UserResponse roles(Set<String> roles) {
        this.roles = roles;
        return this;
    }

    public UserResponse addRolesItem(String rolesItem) {
        if (this.roles == null) {
            this.roles = new LinkedHashSet<String>();
        }
        this.roles.add(rolesItem);
        return this;
    }

    @Schema(name="roles", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="roles")
    public Set<String> getRoles() {
        return this.roles;
    }

    @JsonDeserialize(as=LinkedHashSet.class)
    public void setRoles(Set<String> roles) {
        this.roles = roles;
    }

    public UserResponse properties(List<@Valid AdditionalProperty> properties) {
        this.properties = properties;
        return this;
    }

    public UserResponse addPropertiesItem(AdditionalProperty propertiesItem) {
        if (this.properties == null) {
            this.properties = new ArrayList<AdditionalProperty>();
        }
        this.properties.add(propertiesItem);
        return this;
    }

    @Valid
    @Schema(name="properties", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="properties")
    public @Valid List<@Valid AdditionalProperty> getProperties() {
        return this.properties;
    }

    public void setProperties(List<@Valid AdditionalProperty> properties) {
        this.properties = properties;
    }

    public UserResponse groupProperties(List<@Valid AdditionalProperty> groupProperties) {
        this.groupProperties = groupProperties;
        return this;
    }

    public UserResponse addGroupPropertiesItem(AdditionalProperty groupPropertiesItem) {
        if (this.groupProperties == null) {
            this.groupProperties = new ArrayList<AdditionalProperty>();
        }
        this.groupProperties.add(groupPropertiesItem);
        return this;
    }

    @Valid
    @Schema(name="groupProperties", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="groupProperties")
    public @Valid List<@Valid AdditionalProperty> getGroupProperties() {
        return this.groupProperties;
    }

    public void setGroupProperties(List<@Valid AdditionalProperty> groupProperties) {
        this.groupProperties = groupProperties;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserResponse userResponse = (UserResponse)o;
        return Objects.equals(this.isAuthenticated, userResponse.isAuthenticated) && Objects.equals(this.username, userResponse.username) && Objects.equals(this.roles, userResponse.roles) && Objects.equals(this.properties, userResponse.properties) && Objects.equals(this.groupProperties, userResponse.groupProperties);
    }

    public int hashCode() {
        return Objects.hash(this.isAuthenticated, this.username, this.roles, this.properties, this.groupProperties);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserResponse {\n");
        sb.append("    isAuthenticated: ").append(this.toIndentedString(this.isAuthenticated)).append("\n");
        sb.append("    username: ").append(this.toIndentedString(this.username)).append("\n");
        sb.append("    roles: ").append(this.toIndentedString(this.roles)).append("\n");
        sb.append("    properties: ").append(this.toIndentedString(this.properties)).append("\n");
        sb.append("    groupProperties: ").append(this.toIndentedString(this.groupProperties)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

