/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.configuration.base;

import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.EnvironmentAware;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.resource.ResourceTransformer;
import org.springframework.web.servlet.resource.ResourceTransformerChain;
import org.springframework.web.servlet.resource.TransformedResource;

@Component
public class IndexHtmlTransformer
implements ResourceTransformer,
EnvironmentAware {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Environment environment;

    public void setEnvironment(@NonNull Environment environment) {
        this.environment = environment;
    }

    @NonNull
    public Resource transform(@NonNull HttpServletRequest request, @NonNull Resource resource, @NonNull ResourceTransformerChain transformerChain) throws IOException {
        resource = transformerChain.transform(request, resource);
        String html = IOUtils.toString((InputStream)resource.getInputStream(), (Charset)StandardCharsets.UTF_8);
        String sentryDsn = this.environment.getProperty("VIEWER_SENTRY_DSN");
        if (StringUtils.isNotBlank((CharSequence)sentryDsn)) {
            logger.info("Sending Sentry DSN {} for URI {}", (Object)sentryDsn, (Object)request.getRequestURI());
            html = html.replace("@SENTRY_DSN@", sentryDsn);
        }
        return new TransformedResource(resource, html.getBytes(StandardCharsets.UTF_8));
    }
}

