/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.controller;

import jakarta.servlet.http.HttpServletRequest;
import nl.b3p.tailormap.api.annotation.AppRestController;
import nl.b3p.tailormap.api.persistence.Application;
import nl.b3p.tailormap.api.persistence.GeoService;
import nl.b3p.tailormap.api.persistence.helper.ApplicationHelper;
import nl.b3p.tailormap.api.persistence.json.AppTreeLayerNode;
import nl.b3p.tailormap.api.persistence.json.GeoServiceLayer;
import nl.b3p.tailormap.api.repository.ApplicationRepository;
import nl.b3p.tailormap.api.repository.GeoServiceRepository;
import nl.b3p.tailormap.api.security.AuthorizationService;
import nl.b3p.tailormap.api.viewer.model.ErrorResponse;
import nl.b3p.tailormap.api.viewer.model.RedirectResponse;
import nl.b3p.tailormap.api.viewer.model.ViewerResponse;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.WebDataBinder;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.InitBinder;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.server.ResponseStatusException;

@RestControllerAdvice(annotations={AppRestController.class})
public class AppRestControllerAdvice {
    private final ApplicationRepository applicationRepository;
    private final GeoServiceRepository geoServiceRepository;
    private final ApplicationHelper applicationHelper;
    private final AuthorizationService authorizationService;
    @Value(value="${tailormap-api.base-path}")
    private String basePath;

    public AppRestControllerAdvice(ApplicationRepository applicationRepository, GeoServiceRepository geoServiceRepository, ApplicationHelper applicationHelper, AuthorizationService authorizationService) {
        this.applicationRepository = applicationRepository;
        this.geoServiceRepository = geoServiceRepository;
        this.applicationHelper = applicationHelper;
        this.authorizationService = authorizationService;
    }

    @InitBinder
    protected void initBinder(WebDataBinder binder) {
        binder.setAllowedFields(new String[]{"viewerName", "appLayerId", "base", "projection"});
    }

    @ExceptionHandler(value={ResponseStatusException.class})
    protected ResponseEntity<?> handleResponseStatusException(ResponseStatusException ex) {
        if (HttpStatus.UNAUTHORIZED.equals((Object)ex.getStatusCode())) {
            return ResponseEntity.status((HttpStatusCode)ex.getStatusCode()).contentType(MediaType.APPLICATION_JSON).body((Object)new RedirectResponse());
        }
        return ResponseEntity.status((HttpStatusCode)ex.getStatusCode()).contentType(MediaType.APPLICATION_JSON).body((Object)new ErrorResponse().message(ex.getReason() != null ? ex.getReason() : ex.getBody().getTitle()).code(Integer.valueOf(ex.getStatusCode().value())));
    }

    @ModelAttribute
    public ViewerResponse.KindEnum populateViewerKind(HttpServletRequest request) {
        if (request.getServletPath().startsWith(this.basePath + "/app/")) {
            return ViewerResponse.KindEnum.APP;
        }
        if (request.getServletPath().startsWith(this.basePath + "/service/")) {
            return ViewerResponse.KindEnum.SERVICE;
        }
        return null;
    }

    @ModelAttribute
    public Application populateApplication(@ModelAttribute ViewerResponse.KindEnum viewerKind, @PathVariable(required=false) String viewerName, @RequestParam(required=false) String base, @RequestParam(required=false) String projection) {
        Application app;
        if (viewerKind == null || viewerName == null) {
            return null;
        }
        if (viewerKind == ViewerResponse.KindEnum.APP) {
            app = this.applicationRepository.findByName(viewerName);
            if (app == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
            }
        } else if (viewerKind == ViewerResponse.KindEnum.SERVICE) {
            GeoService service = this.geoServiceRepository.findById(viewerName).orElse(null);
            if (service == null) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            if (!this.authorizationService.mayUserRead(service)) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED);
            }
            if (!service.isPublished()) {
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
            }
            app = this.applicationHelper.getServiceApplication(base, projection, service);
        } else {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        if (!this.authorizationService.mayUserRead(app)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        return app;
    }

    @ModelAttribute
    public AppTreeLayerNode populateAppTreeLayerNode(@ModelAttribute Application app, @PathVariable(required=false) String appLayerId) {
        if (app == null || appLayerId == null) {
            return null;
        }
        AppTreeLayerNode layerNode = app.getAllAppTreeLayerNode().filter(r -> r.getId().equals(appLayerId)).findFirst().orElse(null);
        if (layerNode == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Application layer with id " + appLayerId + " not found");
        }
        return layerNode;
    }

    @ModelAttribute
    public GeoService populateGeoService(@ModelAttribute AppTreeLayerNode appTreeLayerNode) {
        if (appTreeLayerNode == null) {
            return null;
        }
        if (appTreeLayerNode.getServiceId() == null) {
            return null;
        }
        GeoService service = this.geoServiceRepository.findById(appTreeLayerNode.getServiceId()).orElse(null);
        if (service != null && !this.authorizationService.mayUserRead(service)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        return service;
    }

    @ModelAttribute
    public GeoServiceLayer populateGeoServiceLayer(@ModelAttribute AppTreeLayerNode appTreeLayerNode, @ModelAttribute GeoService service) {
        if (service == null) {
            return null;
        }
        GeoServiceLayer layer = service.getLayers().stream().filter(l -> appTreeLayerNode.getLayerName().equals(l.getName())).findFirst().orElse(null);
        if (layer != null && !this.authorizationService.mayUserRead(service, layer)) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.UNAUTHORIZED);
        }
        return layer;
    }
}

