/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.controller;

import io.micrometer.core.annotation.Counted;
import io.micrometer.core.annotation.Timed;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.MethodHandles;
import java.util.concurrent.TimeUnit;
import nl.b3p.tailormap.api.annotation.AppRestController;
import nl.b3p.tailormap.api.persistence.Application;
import nl.b3p.tailormap.api.persistence.GeoService;
import nl.b3p.tailormap.api.persistence.SearchIndex;
import nl.b3p.tailormap.api.persistence.json.AppLayerSettings;
import nl.b3p.tailormap.api.persistence.json.AppTreeLayerNode;
import nl.b3p.tailormap.api.repository.SearchIndexRepository;
import nl.b3p.tailormap.api.solr.SolrHelper;
import nl.b3p.tailormap.api.viewer.model.SearchResponse;
import org.apache.solr.client.solrj.SolrClient;
import org.apache.solr.client.solrj.SolrServerException;
import org.apache.solr.client.solrj.impl.Http2SolrClient;
import org.apache.solr.common.SolrException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.server.ResponseStatusException;

@AppRestController
@Validated
@RequestMapping(path={"${tailormap-api.base-path}/{viewerKind}/{viewerName}/layer/{appLayerId}/search"}, produces={"application/json"})
public class SearchController {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final SearchIndexRepository searchIndexRepository;
    @Value(value="${tailormap-api.solr-url}")
    private String solrUrl;
    @Value(value="${tailormap-api.solr-core-name:tailormap}")
    private String solrCoreName;
    @Value(value="${tailormap-api.pageSize:100}")
    private int numResultsToReturn;

    public SearchController(SearchIndexRepository searchIndexRepository) {
        this.searchIndexRepository = searchIndexRepository;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Transactional(readOnly=true)
    @RequestMapping(method={RequestMethod.GET})
    @Timed(value="search", description="time spent to process search a request")
    @Counted(value="search", description="number of search calls")
    public ResponseEntity<Serializable> search(@ModelAttribute AppTreeLayerNode appTreeLayerNode, @ModelAttribute GeoService service, @ModelAttribute Application application, @RequestParam(required=false, name="q") String solrQuery, @RequestParam(required=false, defaultValue="0") Integer start) {
        AppLayerSettings appLayerSettings = application.getAppLayerSettings(appTreeLayerNode);
        if (appLayerSettings.getSearchIndexId() == null) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Layer '%s' does not have a search index".formatted(appTreeLayerNode.getLayerName()));
        }
        SearchIndex searchIndex = (SearchIndex)this.searchIndexRepository.findById((Object)appLayerSettings.getSearchIndexId()).orElseThrow(() -> new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Layer '%s' does not have a search index".formatted(appTreeLayerNode.getLayerName())));
        try (SolrClient solrClient = this.getSolrClient();){
            ResponseEntity responseEntity;
            try (SolrHelper solrHelper = new SolrHelper(solrClient);){
                SearchResponse searchResponse = solrHelper.findInIndex(searchIndex, solrQuery, start.intValue(), this.numResultsToReturn);
                responseEntity = null == searchResponse.getDocuments() || searchResponse.getDocuments().isEmpty() ? ResponseEntity.noContent().build() : ResponseEntity.ok().body((Object)searchResponse);
            }
            return responseEntity;
        }
        catch (IOException | SolrServerException e) {
            logger.error("Error while contacting Solr", e);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Error while searching", e);
        }
        catch (SolrException e) {
            logger.error("Error while searching", (Throwable)e);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Error while searching with given query", (Throwable)e);
        }
    }

    private SolrClient getSolrClient() {
        return ((Http2SolrClient.Builder)((Http2SolrClient.Builder)new Http2SolrClient.Builder(this.solrUrl + this.solrCoreName).withConnectionTimeout(10L, TimeUnit.SECONDS)).withFollowRedirects(true)).build();
    }
}

