/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nl.b3p.tailormap.api.persistence.json.FormField;
import nl.b3p.tailormap.api.persistence.json.FormFieldValue;

@JsonIgnoreProperties(ignoreUnknown=true)
@Schema(name="FormField", description="model for a single form field")
public class FormField
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private String label;
    private TypeEnum type;
    private String tab = null;
    private BigDecimal column = null;
    private Boolean uniqueValuesAsOptions = null;
    @Valid
    private @Valid List<@Valid FormFieldValue> valueList;
    private Boolean allowValueListOnly = null;
    private Boolean disabled = null;
    private Boolean required = null;
    private String placeholder = null;
    private String hint = null;

    public FormField name(String name) {
        this.name = name;
        return this;
    }

    @Schema(name="name", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public FormField label(String label) {
        this.label = label;
        return this;
    }

    @Schema(name="label", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="label")
    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public FormField type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Schema(name="type", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="type")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public FormField tab(String tab) {
        this.tab = tab;
        return this;
    }

    @Schema(name="tab", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="tab")
    public String getTab() {
        return this.tab;
    }

    public void setTab(String tab) {
        this.tab = tab;
    }

    public FormField column(BigDecimal column) {
        this.column = column;
        return this;
    }

    @Valid
    @Schema(name="column", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="column")
    public BigDecimal getColumn() {
        return this.column;
    }

    public void setColumn(BigDecimal column) {
        this.column = column;
    }

    public FormField uniqueValuesAsOptions(Boolean uniqueValuesAsOptions) {
        this.uniqueValuesAsOptions = uniqueValuesAsOptions;
        return this;
    }

    @Schema(name="uniqueValuesAsOptions", description="when true the unique values for the column are used when editing this field", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="uniqueValuesAsOptions")
    public Boolean getUniqueValuesAsOptions() {
        return this.uniqueValuesAsOptions;
    }

    public void setUniqueValuesAsOptions(Boolean uniqueValuesAsOptions) {
        this.uniqueValuesAsOptions = uniqueValuesAsOptions;
    }

    public FormField valueList(List<@Valid FormFieldValue> valueList) {
        this.valueList = valueList;
        return this;
    }

    public FormField addValueListItem(FormFieldValue valueListItem) {
        if (this.valueList == null) {
            this.valueList = new ArrayList();
        }
        this.valueList.add(valueListItem);
        return this;
    }

    @Valid
    @Schema(name="valueList", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="valueList")
    public @Valid List<@Valid FormFieldValue> getValueList() {
        return this.valueList;
    }

    public void setValueList(List<@Valid FormFieldValue> valueList) {
        this.valueList = valueList;
    }

    public FormField allowValueListOnly(Boolean allowValueListOnly) {
        this.allowValueListOnly = allowValueListOnly;
        return this;
    }

    @Schema(name="allowValueListOnly", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="allowValueListOnly")
    public Boolean getAllowValueListOnly() {
        return this.allowValueListOnly;
    }

    public void setAllowValueListOnly(Boolean allowValueListOnly) {
        this.allowValueListOnly = allowValueListOnly;
    }

    public FormField disabled(Boolean disabled) {
        this.disabled = disabled;
        return this;
    }

    @Schema(name="disabled", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="disabled")
    public Boolean getDisabled() {
        return this.disabled;
    }

    public void setDisabled(Boolean disabled) {
        this.disabled = disabled;
    }

    public FormField required(Boolean required) {
        this.required = required;
        return this;
    }

    @Schema(name="required", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="required")
    public Boolean getRequired() {
        return this.required;
    }

    public void setRequired(Boolean required) {
        this.required = required;
    }

    public FormField placeholder(String placeholder) {
        this.placeholder = placeholder;
        return this;
    }

    @Schema(name="placeholder", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="placeholder")
    public String getPlaceholder() {
        return this.placeholder;
    }

    public void setPlaceholder(String placeholder) {
        this.placeholder = placeholder;
    }

    public FormField hint(String hint) {
        this.hint = hint;
        return this;
    }

    @Schema(name="hint", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="hint")
    public String getHint() {
        return this.hint;
    }

    public void setHint(String hint) {
        this.hint = hint;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormField formField = (FormField)o;
        return Objects.equals(this.name, formField.name) && Objects.equals(this.label, formField.label) && Objects.equals(this.type, formField.type) && Objects.equals(this.tab, formField.tab) && Objects.equals(this.column, formField.column) && Objects.equals(this.uniqueValuesAsOptions, formField.uniqueValuesAsOptions) && Objects.equals(this.valueList, formField.valueList) && Objects.equals(this.allowValueListOnly, formField.allowValueListOnly) && Objects.equals(this.disabled, formField.disabled) && Objects.equals(this.required, formField.required) && Objects.equals(this.placeholder, formField.placeholder) && Objects.equals(this.hint, formField.hint);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.label, this.type, this.tab, this.column, this.uniqueValuesAsOptions, this.valueList, this.allowValueListOnly, this.disabled, this.required, this.placeholder, this.hint);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FormField {\n");
        sb.append("    name: ").append(this.toIndentedString((Object)this.name)).append("\n");
        sb.append("    label: ").append(this.toIndentedString((Object)this.label)).append("\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    tab: ").append(this.toIndentedString((Object)this.tab)).append("\n");
        sb.append("    column: ").append(this.toIndentedString((Object)this.column)).append("\n");
        sb.append("    uniqueValuesAsOptions: ").append(this.toIndentedString((Object)this.uniqueValuesAsOptions)).append("\n");
        sb.append("    valueList: ").append(this.toIndentedString((Object)this.valueList)).append("\n");
        sb.append("    allowValueListOnly: ").append(this.toIndentedString((Object)this.allowValueListOnly)).append("\n");
        sb.append("    disabled: ").append(this.toIndentedString((Object)this.disabled)).append("\n");
        sb.append("    required: ").append(this.toIndentedString((Object)this.required)).append("\n");
        sb.append("    placeholder: ").append(this.toIndentedString((Object)this.placeholder)).append("\n");
        sb.append("    hint: ").append(this.toIndentedString((Object)this.hint)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

