/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nl.b3p.tailormap.api.persistence.json.FormTab;

@JsonIgnoreProperties(ignoreUnknown=true)
@Schema(name="FormOptions", description="model with options for an form")
public class FormOptions
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String description = null;
    private Integer columns;
    @Valid
    private @Valid List<@Valid FormTab> tabs = new ArrayList();

    public FormOptions description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", description="description text for the form", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public FormOptions columns(Integer columns) {
        this.columns = columns;
        return this;
    }

    @Schema(name="columns", description="the number of columns (adjusts the width of the form)", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="columns")
    public Integer getColumns() {
        return this.columns;
    }

    public void setColumns(Integer columns) {
        this.columns = columns;
    }

    public FormOptions tabs(List<@Valid FormTab> tabs) {
        this.tabs = tabs;
        return this;
    }

    public FormOptions addTabsItem(FormTab tabsItem) {
        if (this.tabs == null) {
            this.tabs = new ArrayList();
        }
        this.tabs.add(tabsItem);
        return this;
    }

    @Valid
    @Schema(name="tabs", description="list of tabs for a form", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="tabs")
    public @Valid List<@Valid FormTab> getTabs() {
        return this.tabs;
    }

    public void setTabs(List<@Valid FormTab> tabs) {
        this.tabs = tabs;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FormOptions formOptions = (FormOptions)o;
        return Objects.equals(this.description, formOptions.description) && Objects.equals(this.columns, formOptions.columns) && Objects.equals(this.tabs, formOptions.tabs);
    }

    public int hashCode() {
        return Objects.hash(this.description, this.columns, this.tabs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FormOptions {\n");
        sb.append("    description: ").append(this.toIndentedString((Object)this.description)).append("\n");
        sb.append("    columns: ").append(this.toIndentedString((Object)this.columns)).append("\n");
        sb.append("    tabs: ").append(this.toIndentedString((Object)this.tabs)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

