/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.persistence.json;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.Valid;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import nl.b3p.tailormap.api.persistence.json.AuthorizationRule;
import nl.b3p.tailormap.api.persistence.json.FeatureTypeRef;

@JsonIgnoreProperties(ignoreUnknown=true)
@Schema(name="LayerSettings", description="Settings applying to any kind of layer of a GeoService.")
public class LayerSettings
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String title = null;
    private Boolean hiDpiDisabled = null;
    private FeatureTypeRef featureType;
    private String attribution = null;
    private String description = null;
    private String legendImageId = null;
    @Valid
    private @Valid List<@Valid AuthorizationRule> authorizationRules = new ArrayList();

    public LayerSettings title(String title) {
        this.title = title;
        return this;
    }

    @Schema(name="title", description="Override default title, null if not overridden.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public LayerSettings hiDpiDisabled(Boolean hiDpiDisabled) {
        this.hiDpiDisabled = hiDpiDisabled;
        return this;
    }

    @Schema(name="hiDpiDisabled", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="hiDpiDisabled")
    public Boolean getHiDpiDisabled() {
        return this.hiDpiDisabled;
    }

    public void setHiDpiDisabled(Boolean hiDpiDisabled) {
        this.hiDpiDisabled = hiDpiDisabled;
    }

    public LayerSettings featureType(FeatureTypeRef featureType) {
        this.featureType = featureType;
        return this;
    }

    @Valid
    @Schema(name="featureType", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="featureType")
    public FeatureTypeRef getFeatureType() {
        return this.featureType;
    }

    public void setFeatureType(FeatureTypeRef featureType) {
        this.featureType = featureType;
    }

    public LayerSettings attribution(String attribution) {
        this.attribution = attribution;
        return this;
    }

    @Schema(name="attribution", description="Attribution to show for this layer.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="attribution")
    public String getAttribution() {
        return this.attribution;
    }

    public void setAttribution(String attribution) {
        this.attribution = attribution;
    }

    public LayerSettings description(String description) {
        this.description = description;
        return this;
    }

    @Schema(name="description", description="Description to show for this layer.", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public LayerSettings legendImageId(String legendImageId) {
        this.legendImageId = legendImageId;
        return this;
    }

    @Schema(name="legendImageId", description="ID of uploaded legend image", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="legendImageId")
    public String getLegendImageId() {
        return this.legendImageId;
    }

    public void setLegendImageId(String legendImageId) {
        this.legendImageId = legendImageId;
    }

    public LayerSettings authorizationRules(List<@Valid AuthorizationRule> authorizationRules) {
        this.authorizationRules = authorizationRules;
        return this;
    }

    public LayerSettings addAuthorizationRulesItem(AuthorizationRule authorizationRulesItem) {
        if (this.authorizationRules == null) {
            this.authorizationRules = new ArrayList();
        }
        this.authorizationRules.add(authorizationRulesItem);
        return this;
    }

    @Valid
    @Schema(name="authorizationRules", requiredMode=Schema.RequiredMode.NOT_REQUIRED)
    @JsonProperty(value="authorizationRules")
    public @Valid List<@Valid AuthorizationRule> getAuthorizationRules() {
        return this.authorizationRules;
    }

    public void setAuthorizationRules(List<@Valid AuthorizationRule> authorizationRules) {
        this.authorizationRules = authorizationRules;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LayerSettings layerSettings = (LayerSettings)o;
        return Objects.equals(this.title, layerSettings.title) && Objects.equals(this.hiDpiDisabled, layerSettings.hiDpiDisabled) && Objects.equals(this.featureType, layerSettings.featureType) && Objects.equals(this.attribution, layerSettings.attribution) && Objects.equals(this.description, layerSettings.description) && Objects.equals(this.legendImageId, layerSettings.legendImageId) && Objects.equals(this.authorizationRules, layerSettings.authorizationRules);
    }

    public int hashCode() {
        return Objects.hash(this.title, this.hiDpiDisabled, this.featureType, this.attribution, this.description, this.legendImageId, this.authorizationRules);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LayerSettings {\n");
        sb.append("    title: ").append(this.toIndentedString((Object)this.title)).append("\n");
        sb.append("    hiDpiDisabled: ").append(this.toIndentedString((Object)this.hiDpiDisabled)).append("\n");
        sb.append("    featureType: ").append(this.toIndentedString((Object)this.featureType)).append("\n");
        sb.append("    attribution: ").append(this.toIndentedString((Object)this.attribution)).append("\n");
        sb.append("    description: ").append(this.toIndentedString((Object)this.description)).append("\n");
        sb.append("    legendImageId: ").append(this.toIndentedString((Object)this.legendImageId)).append("\n");
        sb.append("    authorizationRules: ").append(this.toIndentedString((Object)this.authorizationRules)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

