/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.tailormap.api.security;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.stream.Collectors;
import nl.b3p.tailormap.api.persistence.Group;
import nl.b3p.tailormap.api.persistence.User;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.UserDetails;

public class TailormapUserDetails
implements UserDetails {
    private final User user;

    public TailormapUserDetails(User user) {
        this.user = user;
    }

    public Collection<? extends GrantedAuthority> getAuthorities() {
        return this.user.getGroups().stream().map(Group::getName).map(SimpleGrantedAuthority::new).collect(Collectors.toSet());
    }

    public String getPassword() {
        return this.user.getPassword();
    }

    public String getUsername() {
        return this.user.getUsername();
    }

    public boolean isAccountNonExpired() {
        return this.user.getValidUntil() == null || this.user.getValidUntil().isAfter(ZonedDateTime.now(ZoneId.systemDefault()));
    }

    public boolean isAccountNonLocked() {
        return true;
    }

    public boolean isCredentialsNonExpired() {
        return true;
    }

    public boolean isEnabled() {
        return this.user.isEnabled();
    }
}

