/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.config.app;

import nl.tailormap.viewer.config.app.Application;
import nl.tailormap.viewer.config.app.ApplicationLayer;
import nl.tailormap.viewer.config.app.StartLayer;
import nl.tailormap.viewer.util.TestUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class StartLayerTest
extends TestUtil {
    private static final Log log = LogFactory.getLog(StartLayerTest.class);

    StartLayerTest() {
    }

    @Test
    void persistLayer() {
        StartLayer sl = new StartLayer();
        sl.setChecked(true);
        sl.setSelectedIndex(Integer.valueOf(16));
        this.persistEntityTest(sl, StartLayer.class);
        this.entityManager.refresh((Object)sl);
        StartLayer test = (StartLayer)this.entityManager.find(StartLayer.class, (Object)sl.getId());
        Assertions.assertNotNull((Object)test, (String)"StartLayer not found");
        Assertions.assertEquals((Integer)16, (Integer)test.getSelectedIndex(), (String)"Selected index not found");
        Assertions.assertEquals((int)6, (int)this.entityManager.createQuery("FROM Level").getResultList().size(), (String)"Levels not found");
    }

    @Test
    void deleteLayer() {
        Application app = (Application)this.entityManager.find(Application.class, (Object)1L);
        ApplicationLayer appLayer = (ApplicationLayer)this.entityManager.find(ApplicationLayer.class, (Object)2L);
        StartLayer sl = new StartLayer();
        sl.setChecked(true);
        sl.setApplicationLayer(appLayer);
        sl.setApplication(app);
        sl.setSelectedIndex(Integer.valueOf(16));
        this.persistEntityTest(sl, StartLayer.class);
        this.entityManager.flush();
        ApplicationLayer appLayerExists = (ApplicationLayer)this.entityManager.find(ApplicationLayer.class, (Object)2L);
        Application appExists = (Application)this.entityManager.find(Application.class, (Object)this.applicationId);
        Assertions.assertNotNull((Object)appLayerExists, (String)"ApplicationLayer not found");
        Assertions.assertNotNull((Object)appExists, (String)"Application not found");
        Assertions.assertEquals((int)6, (int)this.entityManager.createQuery("FROM Level").getResultList().size(), (String)"Levels not found");
    }

    @Test
    void deleteApplayer() {
        long lid;
        block2: {
            this.initData(true);
            Assertions.assertNotNull((Object)this.testAppLayer, (String)"ApplicationLayer not found");
            Assertions.assertNotNull((Object)this.testStartLayer, (String)"StartLayer not found");
            lid = this.testAppLayer.getId();
            ApplicationLayer appLayer = (ApplicationLayer)this.entityManager.find(ApplicationLayer.class, (Object)lid);
            StartLayer startLayer = (StartLayer)this.entityManager.find(StartLayer.class, (Object)this.testStartLayer.getId());
            Assertions.assertNotNull((Object)startLayer, (String)"StartLayer not found");
            this.testLevel.getLayers().remove(appLayer);
            this.app.getStartLayers().removeAll(appLayer.getStartLayers().values());
            this.entityManager.remove((Object)appLayer);
            try {
                this.entityManager.getTransaction().commit();
            }
            catch (Exception e) {
                log.error((Object)"Fout bij verwijderen", (Throwable)e);
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        this.entityManager.getTransaction().begin();
        ApplicationLayer appLayerNull = (ApplicationLayer)this.entityManager.find(ApplicationLayer.class, (Object)lid);
        StartLayer startLayerNull = (StartLayer)this.entityManager.find(StartLayer.class, (Object)this.testStartLayer.getId());
        Assertions.assertNull((Object)appLayerNull, (String)"AppLayer not deleted");
        Assertions.assertNull((Object)startLayerNull, (String)"Startlayer not deleted");
    }

    @Test
    void deleteApplication() {
        this.initData(true);
        Assertions.assertNotNull((Object)this.testAppLayer, (String)"AppLayer not found");
        Assertions.assertNotNull((Object)this.app, (String)"App not found");
        Assertions.assertNotNull((Object)this.testStartLayer, (String)"StartLayer not found");
        long lid = this.testAppLayer.getId();
        this.entityManager.remove((Object)this.app);
        this.entityManager.getTransaction().commit();
        this.entityManager.getTransaction().begin();
        ApplicationLayer shouldBeNull = (ApplicationLayer)this.entityManager.find(ApplicationLayer.class, (Object)lid);
        StartLayer shouldBeNullAsWell = (StartLayer)this.entityManager.find(StartLayer.class, (Object)this.testStartLayer.getId());
        Application appShouldBeNull = (Application)this.entityManager.find(Application.class, (Object)this.app.getId());
        Assertions.assertNull((Object)shouldBeNull, (String)"AppLayer should be null");
        Assertions.assertNull((Object)shouldBeNullAsWell, (String)"StartLayer should be null");
        Assertions.assertNull((Object)appShouldBeNull, (String)"Application should be null");
    }
}

