/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.config.app;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.persistence.AttributeOverride;
import javax.persistence.AttributeOverrides;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Embedded;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.PostPersist;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import nl.tailormap.viewer.config.ClobElement;
import nl.tailormap.viewer.config.app.ApplicationLayer;
import nl.tailormap.viewer.config.app.Bookmark;
import nl.tailormap.viewer.config.app.ConfiguredComponent;
import nl.tailormap.viewer.config.app.Level;
import nl.tailormap.viewer.config.app.StartLayer;
import nl.tailormap.viewer.config.app.StartLevel;
import nl.tailormap.viewer.config.security.User;
import nl.tailormap.viewer.config.services.BoundingBox;
import nl.tailormap.viewer.util.ApplicationDetailsValueTransformer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.Session;
import org.hibernate.annotations.Type;
import org.hibernate.transform.ResultTransformer;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"name", "version"})})
public class Application
implements Comparable<Application> {
    private static final Log log = LogFactory.getLog(Application.class);
    public static final String DETAIL_IS_MASHUP = "isMashup";
    public static final String DETAIL_GLOBAL_LAYOUT = "globalLayout";
    public static final String DETAIL_LAST_SPINUP_TIME = "lastSpinupTime";
    public static Set<String> adminOnlyDetails = new HashSet<String>(List.of("opmerking"));
    public static final Set<String> preventClearDetails = new HashSet<String>(Arrays.asList("isMashup", "globalLayout"));
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Basic(optional=false)
    private String name;
    @Column(length=30)
    private String version;
    @Column
    private String title;
    @Column
    private String lang;
    @Lob
    @Type(type="org.hibernate.type.TextType")
    private String layout;
    @ElementCollection
    @JoinTable(joinColumns={@JoinColumn(name="application")})
    private Map<String, ClobElement> details = new HashMap<String, ClobElement>();
    @ManyToOne
    @JoinColumn(name="owner")
    private User owner;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="crs.name", column=@Column(name="start_crs")), @AttributeOverride(name="minx", column=@Column(name="start_minx")), @AttributeOverride(name="maxx", column=@Column(name="start_maxx")), @AttributeOverride(name="miny", column=@Column(name="start_miny")), @AttributeOverride(name="maxy", column=@Column(name="start_maxy"))})
    private BoundingBox startExtent;
    @Embedded
    @AttributeOverrides(value={@AttributeOverride(name="crs.name", column=@Column(name="max_crs")), @AttributeOverride(name="minx", column=@Column(name="max_minx")), @AttributeOverride(name="maxx", column=@Column(name="max_maxx")), @AttributeOverride(name="miny", column=@Column(name="max_miny")), @AttributeOverride(name="maxy", column=@Column(name="max_maxy"))})
    private BoundingBox maxExtent;
    private boolean authenticatedRequired;
    @ManyToOne(cascade={CascadeType.ALL}, fetch=FetchType.LAZY)
    @JoinColumn(name="root")
    private Level root;
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL}, mappedBy="application")
    private Set<ConfiguredComponent> components = new HashSet<ConfiguredComponent>();
    @Basic(optional=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date authorizationsModified = new Date();
    @Transient
    public Map originalToCopy;
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL}, mappedBy="application")
    private List<Bookmark> bookmarks = new ArrayList<Bookmark>();
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL}, mappedBy="application")
    private List<StartLayer> startLayers = new ArrayList<StartLayer>();
    @OneToMany(orphanRemoval=true, cascade={CascadeType.ALL}, mappedBy="application")
    private List<StartLevel> startLevels = new ArrayList<StartLevel>();
    @ElementCollection
    @CollectionTable(joinColumns={@JoinColumn(name="application")})
    @Column(name="role_name")
    private Set<String> readers = new HashSet<String>();
    private String projectionCode;
    @Transient
    private TreeCache treeCache;
    @Transient
    public Boolean isMashup_cached;
    @Transient
    public Map<String, Long> idMap;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getTitle() {
        return this.title;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }

    public String getLang() {
        return this.lang;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getLayout() {
        return this.layout;
    }

    public void setLayout(String layout) {
        this.layout = layout;
    }

    public Map<String, ClobElement> getDetails() {
        return this.details;
    }

    public void setDetails(Map<String, ClobElement> details) {
        this.details = details;
    }

    public boolean isAuthenticatedRequired() {
        return this.authenticatedRequired;
    }

    public void setAuthenticatedRequired(boolean authenticatedRequired) {
        this.authenticatedRequired = authenticatedRequired;
    }

    public Set<ConfiguredComponent> getComponents() {
        return this.components;
    }

    public void setComponents(Set<ConfiguredComponent> components) {
        this.components = components;
    }

    public BoundingBox getMaxExtent() {
        return this.maxExtent;
    }

    public void setMaxExtent(BoundingBox maxExtent) {
        this.maxExtent = maxExtent;
    }

    public User getOwner() {
        return this.owner;
    }

    public void setOwner(User owner) {
        this.owner = owner;
    }

    public Level getRoot() {
        return this.root;
    }

    public void setRoot(Level root) {
        this.root = root;
    }

    public BoundingBox getStartExtent() {
        return this.startExtent;
    }

    public void setStartExtent(BoundingBox startExtent) {
        this.startExtent = startExtent;
    }

    public Date getAuthorizationsModified() {
        return this.authorizationsModified;
    }

    public void setAuthorizationsModified(Date authorizationsModified) {
        this.authorizationsModified = authorizationsModified;
    }

    public List<Bookmark> getBookmarks() {
        return this.bookmarks;
    }

    public void setBookmarks(List<Bookmark> bookmarks) {
        this.bookmarks = bookmarks;
    }

    public List<StartLayer> getStartLayers() {
        return this.startLayers;
    }

    public void setStartLayers(List<StartLayer> startLayers) {
        this.startLayers = startLayers;
    }

    public List<StartLevel> getStartLevels() {
        return this.startLevels;
    }

    public void setStartLevels(List<StartLevel> startLevels) {
        this.startLevels = startLevels;
    }

    public Set<String> getReaders() {
        return this.readers;
    }

    public void setReaders(Set<String> readers) {
        this.readers = readers;
    }

    public String getProjectionCode() {
        return this.projectionCode;
    }

    public void setProjectionCode(String projectionCode) {
        this.projectionCode = projectionCode;
    }

    public String getNameWithVersion() {
        Object n = this.getName();
        if (this.getVersion() != null) {
            n = (String)n + " v" + this.getVersion();
        }
        return n;
    }

    public TreeCache getTreeCache() {
        return this.treeCache;
    }

    @Override
    public int compareTo(Application o) {
        if (o != null) {
            return o.getId().compareTo(this.getId());
        }
        return -1;
    }

    public void setTreeCache(TreeCache treeCache) {
        this.treeCache = treeCache;
    }

    public TreeCache loadTreeCache(EntityManager em) {
        if (this.treeCache == null) {
            this.treeCache = new TreeCache();
            this.treeCache.levels = em.createNamedQuery("getLevelTree", Level.class).setParameter("rootId", (Object)this.root.getId()).getResultList();
            this.treeCache.childrenByParent = new HashMap<Level, List<Level>>();
            this.treeCache.applicationLayers = new ArrayList<ApplicationLayer>();
            for (Level l : this.treeCache.levels) {
                this.treeCache.applicationLayers.addAll(l.getLayers());
                if (l.getParent() == null) continue;
                List parentChildren = this.treeCache.childrenByParent.computeIfAbsent(l.getParent(), k -> new ArrayList());
                parentChildren.add(l);
            }
        }
        return this.treeCache;
    }

    public void authorizationsModified() {
        this.authorizationsModified = new Date();
    }

    public Boolean isMashup() {
        if (this.getDetails().containsKey(DETAIL_IS_MASHUP)) {
            String mashupValue = this.getDetails().get(DETAIL_IS_MASHUP).getValue();
            this.isMashup_cached = Boolean.valueOf(mashupValue);
        } else {
            this.isMashup_cached = Boolean.FALSE;
        }
        return this.isMashup_cached;
    }

    public Boolean isMashup(Session sess) {
        if (this.isMashup_cached == null) {
            this.isMashup_cached = Boolean.FALSE;
            List items = sess.createSQLQuery("select d.value from application_details d where d.details_key = 'isMashup' and d.application =  :appId").setParameter("appId", (Object)this.getId()).setResultTransformer((ResultTransformer)ApplicationDetailsValueTransformer.INSTANCE).list();
            if (!items.isEmpty()) {
                String mashupValue = ((Map)items.get(0)).get("value").toString();
                this.isMashup_cached = Boolean.valueOf(mashupValue);
            }
        }
        return this.isMashup_cached;
    }

    public ApplicationLayer findLayer(ApplicationLayer oldLayer) {
        List<ApplicationLayer> appLayers = this.treeCache.applicationLayers;
        for (ApplicationLayer appLayer : appLayers) {
            if (!appLayer.getService().equals(oldLayer.getService()) || !appLayer.getLayerName().equals(oldLayer.getLayerName())) continue;
            return appLayer;
        }
        return null;
    }

    public Level findLevel(Level oldLevel) {
        List<Level> levels = this.treeCache.levels;
        for (Level level : levels) {
            if (!level.getName().equals(oldLevel.getName())) continue;
            return level;
        }
        return null;
    }

    @PostPersist
    public void postPersist() {
        if (this.isMashup().booleanValue()) {
            log.debug((Object)"postPersist(): mashup");
            return;
        }
        this.processCopyMap();
    }

    public void processCopyMap() {
        if (this.originalToCopy == null) {
            log.debug((Object)"postPersist(): not a copy");
            return;
        }
        this.idMap = this.getIdMap();
        this.originalToCopy = null;
        log.debug((Object)"Updating component configs");
        for (ConfiguredComponent comp : this.components) {
            if (comp.getConfig() == null) continue;
            log.debug((Object)String.format("Checking component class %s, name %s", comp.getClassName(), comp.getName()));
            boolean changed = false;
            try {
                Long newId;
                int i;
                JSONObject cfg = new JSONObject(comp.getConfig());
                if (cfg.has("layers")) {
                    JSONArray layers = cfg.getJSONArray("layers");
                    for (i = 0; i < layers.length(); ++i) {
                        newId = this.idMap.get(ApplicationLayer.class + "_" + layers.getInt(i));
                        if (newId != null) {
                            log.debug((Object)String.format("Index %d: new id for application layer %d is %d", i, layers.getInt(i), newId));
                            layers.put(i, newId.longValue());
                        } else {
                            log.debug((Object)String.format("Index %d: old id %d was not a valid application layer in original", i, layers.getInt(i)));
                            layers.put(i, -1);
                        }
                        changed = true;
                    }
                }
                if (cfg.has("levels")) {
                    JSONArray levels = cfg.getJSONArray("levels");
                    for (i = 0; i < levels.length(); ++i) {
                        newId = this.idMap.get(Level.class + "_" + levels.getInt(i));
                        if (newId != null) {
                            log.debug((Object)String.format("Index %d: new id for level %d is %d", i, levels.getInt(i), newId));
                            levels.put(i, newId.longValue());
                        } else {
                            log.debug((Object)String.format("Index %d: old id %d was not a valid level in original", i, levels.getInt(i)));
                            levels.put(i, -1);
                        }
                        changed = true;
                    }
                }
                if (!changed) continue;
                log.debug((Object)("Old config: " + comp.getConfig()));
                comp.setConfig(cfg.toString());
                log.debug((Object)("New config: " + comp.getConfig()));
            }
            catch (Exception ex) {
                log.error((Object)String.format("Cannot update persistent object id's in component config on application copy, copied application=%s, component class=%s, component name=%s", this.getNameWithVersion(), comp.getClassName(), comp.getName()), (Throwable)ex);
            }
        }
    }

    private Map<String, Long> getIdMap() {
        HashMap<String, Long> idMap = new HashMap<String, Long>();
        Iterator iterator = this.originalToCopy.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry e;
            Map.Entry entry = e = iterator.next();
            Object original = entry.getKey();
            Object copy = entry.getValue();
            log.debug((Object)String.format("postPersist(): original=%s, copy=%s", original, copy));
            if (original instanceof Level) {
                Level oL = (Level)original;
                Level cL = (Level)copy;
                idMap.put(original.getClass() + "_" + oL.getId(), cL.getId());
                continue;
            }
            if (!(original instanceof ApplicationLayer)) continue;
            ApplicationLayer oAl = (ApplicationLayer)original;
            ApplicationLayer cAl = (ApplicationLayer)copy;
            idMap.put(original.getClass() + "_" + oAl.getId(), cAl.getId());
        }
        return idMap;
    }

    public void removeOldProperties() {
        this.details.remove("maxWidth");
        this.details.remove("maxHeight");
    }

    public void setGlobalLayout(String globalLayout) {
        this.details.put(DETAIL_GLOBAL_LAYOUT, new ClobElement(globalLayout));
    }

    public JSONObject getGlobalLayout() throws JSONException {
        JSONObject globalLayout = new JSONObject();
        if (this.getDetails().containsKey(DETAIL_GLOBAL_LAYOUT)) {
            globalLayout = new JSONObject(this.getDetails().get(DETAIL_GLOBAL_LAYOUT).getValue());
        }
        if (!globalLayout.has("maxWidth") && this.getDetails().containsKey("maxWidth")) {
            globalLayout.put("maxWidth", (Object)this.getDetails().get("maxWidth").getValue());
        }
        if (!globalLayout.has("maxHeight") && this.getDetails().containsKey("maxHeight")) {
            globalLayout.put("maxHeight", (Object)this.getDetails().get("maxHeight").getValue());
        }
        return globalLayout;
    }

    public static class TreeCache {
        List<Level> levels;
        Map<Level, List<Level>> childrenByParent;
        List<ApplicationLayer> applicationLayers;

        public List<ApplicationLayer> getApplicationLayers() {
            return this.applicationLayers;
        }

        public Map<Level, List<Level>> getChildrenByParent() {
            return this.childrenByParent;
        }

        public List<Level> getChildren(Level l) {
            List<Level> children = this.childrenByParent.get(l);
            return Objects.requireNonNullElse(children, Collections.emptyList());
        }

        public List<Level> getLevels() {
            return this.levels;
        }

        public void initializeLevels(String leftJoins, EntityManager em) {
            List<Level> subList;
            int i = 0;
            do {
                subList = this.levels.subList(i, Math.min(this.levels.size(), i + 500));
                em.createQuery("from Level l " + leftJoins + " where l in (:levels) ").setParameter("levels", subList).getResultList();
            } while ((i += subList.size()) < this.levels.size());
        }

        public void initializeApplicationLayers(String leftJoins, EntityManager em) {
            if (!this.getApplicationLayers().isEmpty()) {
                List<ApplicationLayer> subList;
                int i = 0;
                do {
                    subList = this.applicationLayers.subList(i, Math.min(this.applicationLayers.size(), i + 500));
                    em.createQuery("from ApplicationLayer al " + leftJoins + " where al in (:alayers) ").setParameter("alayers", subList).getResultList();
                } while ((i += subList.size()) < this.applicationLayers.size());
            }
        }
    }
}

