/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.config.app;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import nl.tailormap.viewer.config.services.FeatureSource;
import nl.tailormap.viewer.config.services.SimpleFeatureType;
import org.apache.commons.beanutils.BeanUtils;
import org.hibernate.annotations.Type;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Entity
public class ConfiguredAttribute {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    private String attributeName;
    @ManyToOne
    @JoinColumn(name="feature_type")
    private SimpleFeatureType featureType;
    private boolean visible;
    private boolean editable;
    private boolean selectable;
    private boolean filterable;
    private String editAlias;
    private String editHeight;
    @Lob
    @Type(type="org.hibernate.type.TextType")
    private String editValues;
    private String defaultValue;
    @ManyToOne
    @JoinColumn(name="value_list_feature_source")
    private FeatureSource valueListFeatureSource;
    @ManyToOne
    @JoinColumn(name="value_list_feature_type")
    private SimpleFeatureType valueListFeatureType;
    private String valueListLabelName;
    private String valueListValueName;
    private String valueList;
    private boolean allowValueListOnly;
    private boolean disallowNullValue;
    private boolean disableUserEdit;
    private String label;
    private boolean automaticValue;
    private String automaticValueType;

    public String getAttributeName() {
        return this.attributeName;
    }

    public void setAttributeName(String attributeName) {
        this.attributeName = attributeName;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public String getEditAlias() {
        return this.editAlias;
    }

    public void setEditAlias(String editAlias) {
        this.editAlias = editAlias;
    }

    public String getEditHeight() {
        return this.editHeight;
    }

    public void setEditHeight(String editHeight) {
        this.editHeight = editHeight;
    }

    public String getEditValues() {
        return this.editValues;
    }

    public void setEditValues(String editValues) {
        this.editValues = editValues;
    }

    public boolean isEditable() {
        return this.editable;
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
    }

    public boolean isFilterable() {
        return this.filterable;
    }

    public void setFilterable(boolean filterable) {
        this.filterable = filterable;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public boolean isSelectable() {
        return this.selectable;
    }

    public void setSelectable(boolean selectable) {
        this.selectable = selectable;
    }

    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public void setFeatureType(SimpleFeatureType featureType) {
        this.featureType = featureType;
    }

    public FeatureSource getValueListFeatureSource() {
        return this.valueListFeatureSource;
    }

    public void setValueListFeatureSource(FeatureSource valueListFeatureSource) {
        this.valueListFeatureSource = valueListFeatureSource;
    }

    public SimpleFeatureType getValueListFeatureType() {
        return this.valueListFeatureType;
    }

    public void setValueListFeatureType(SimpleFeatureType valueListFeatureType) {
        this.valueListFeatureType = valueListFeatureType;
    }

    public String getValueListLabelName() {
        return this.valueListLabelName;
    }

    public void setValueListLabelName(String valueListLabelName) {
        this.valueListLabelName = valueListLabelName;
    }

    public String getValueListValueName() {
        return this.valueListValueName;
    }

    public void setValueListValueName(String valueListValueName) {
        this.valueListValueName = valueListValueName;
    }

    public String getValueList() {
        return this.valueList;
    }

    public void setValueList(String valueList) {
        this.valueList = valueList;
    }

    public boolean getAllowValueListOnly() {
        return this.allowValueListOnly;
    }

    public void setAllowValueListOnly(boolean allowValueListOnly) {
        this.allowValueListOnly = allowValueListOnly;
    }

    public boolean getDisAllowNullValue() {
        return this.disallowNullValue;
    }

    public void setDisallowNullValue(boolean disallowNullValue) {
        this.disallowNullValue = disallowNullValue;
    }

    public boolean isDisableUserEdit() {
        return this.disableUserEdit;
    }

    public void setDisableUserEdit(boolean disableUserEdit) {
        this.disableUserEdit = disableUserEdit;
    }

    public String getLabel() {
        return this.label;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public boolean isAutomaticValue() {
        return this.automaticValue;
    }

    public void setAutomaticValue(boolean automaticValue) {
        this.automaticValue = automaticValue;
    }

    public String getAutomaticValueType() {
        return this.automaticValueType;
    }

    public void setAutomaticValueType(String automaticValueType) {
        this.automaticValueType = automaticValueType;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject o = new JSONObject();
        o.put("id", (Object)this.id);
        o.put("name", (Object)this.attributeName);
        o.put("visible", this.visible);
        o.put("editable", this.editable);
        o.put("disableUserEdit", this.disableUserEdit);
        o.put("filterable", this.filterable);
        o.put("selectable", this.selectable);
        o.put("editAlias", (Object)this.editAlias);
        o.put("editHeight", (Object)this.editHeight);
        o.put("allowValueListOnly", this.allowValueListOnly);
        o.put("disallowNullValue", this.disallowNullValue);
        o.put("automaticValueType", (Object)this.automaticValueType);
        o.put("automaticValue", this.automaticValue);
        o.put("folder_label", (Object)this.label);
        if (this.editValues != null) {
            try {
                if (this.valueList == null || !this.valueList.equalsIgnoreCase("dynamic")) {
                    o.put("editValues", (Object)new JSONArray(this.editValues));
                }
            }
            catch (JSONException jSONException) {
                // empty catch block
            }
        }
        o.put("defaultValue", (Object)this.defaultValue);
        if (this.featureType != null) {
            o.put("featureType", (Object)this.featureType.getId());
            o.put("longname", (Object)(this.featureType.getTypeName() + "." + this.attributeName));
        }
        o.put("valueList", (Object)this.valueList);
        if (this.valueListFeatureSource != null) {
            o.put("valueListFeatureSource", (Object)this.valueListFeatureSource.getId());
            if (this.valueListFeatureType != null) {
                o.put("valueListFeatureType", (Object)this.valueListFeatureType.getId());
                o.put("valueListLabelName", (Object)this.valueListLabelName);
                o.put("valueListValueName", (Object)this.valueListValueName);
            }
        }
        return o;
    }

    public ConfiguredAttribute deepCopy() throws Exception {
        ConfiguredAttribute copy = (ConfiguredAttribute)BeanUtils.cloneBean((Object)this);
        copy.setId(null);
        return copy;
    }

    public String getFullName() {
        Object uniqueName = "";
        if (this.getFeatureType() != null) {
            uniqueName = this.getFeatureType().getId() + ":";
        }
        uniqueName = (String)uniqueName + this.attributeName;
        return uniqueName;
    }

    public String getLongName() {
        Object longName = "";
        if (this.getFeatureType() != null) {
            longName = this.getFeatureType().getTypeName() + ".";
        }
        longName = (String)longName + this.attributeName;
        return longName;
    }
}

