/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.config.app;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import nl.tailormap.viewer.config.app.Application;
import org.apache.commons.beanutils.BeanUtils;
import org.hibernate.annotations.Type;
import org.json.JSONException;
import org.json.JSONObject;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"name", "application"})})
public class ConfiguredComponent
implements Comparable<ConfiguredComponent> {
    public static final String ADMIN_ONLY = "adminOnly";
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Basic(optional=false)
    private String name;
    @Lob
    @Type(type="org.hibernate.type.TextType")
    private String config;
    @Basic(optional=false)
    private String className;
    @ElementCollection
    @CollectionTable(joinColumns={@JoinColumn(name="configured_component")})
    private Map<String, String> details = new HashMap<String, String>();
    @ManyToOne(optional=false)
    @JoinColumn(name="application")
    private Application application;
    @ElementCollection
    @Column(name="role_name")
    @CollectionTable(joinColumns={@JoinColumn(name="configured_component")})
    private Set<String> readers = new HashSet<String>();
    @ManyToOne
    @JoinColumn(name="mother_component")
    private ConfiguredComponent motherComponent;
    @OneToMany(mappedBy="motherComponent")
    private List<ConfiguredComponent> linkedComponents = new ArrayList<ConfiguredComponent>();
    public static final List<String> classesExcludedFromPushing = new ArrayList<String>();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<String> getReaders() {
        return this.readers;
    }

    public void setReaders(Set<String> readers) {
        this.readers = readers;
    }

    public String getClassName() {
        return this.className;
    }

    public void setClassName(String className) {
        this.className = className;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public Map<String, String> getDetails() {
        return this.details;
    }

    public void setDetails(Map<String, String> details) {
        this.details = details;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public ConfiguredComponent getMotherComponent() {
        return this.motherComponent;
    }

    public void setMotherComponent(ConfiguredComponent motherComponent) {
        this.motherComponent = motherComponent;
    }

    public List<ConfiguredComponent> getLinkedComponents() {
        return this.linkedComponents;
    }

    public void setLinkedComponents(List<ConfiguredComponent> linkedComponents) {
        this.linkedComponents = linkedComponents;
    }

    @Deprecated
    public JSONObject toJSON() throws JSONException {
        return this.toJSON(false);
    }

    public JSONObject toJSON(boolean hideAdminOnly) throws JSONException {
        JSONObject o = new JSONObject();
        o.put("name", (Object)this.name);
        o.put("className", (Object)this.className);
        JSONObject d = new JSONObject();
        o.put("details", (Object)d);
        for (Map.Entry<String, String> e : this.details.entrySet()) {
            d.put(e.getKey(), (Object)e.getValue());
        }
        o.put("config", (Object)(this.config == null ? new JSONObject() : new JSONObject(this.config)));
        if (hideAdminOnly) {
            JSONObject c = o.getJSONObject("config");
            ArrayList<String> removeKeys = new ArrayList<String>();
            for (String key : c.keySet()) {
                if (!key.startsWith(ADMIN_ONLY)) continue;
                removeKeys.add(key);
            }
            for (String key : removeKeys) {
                c.remove(key);
            }
        }
        return o;
    }

    @Override
    public int compareTo(ConfiguredComponent rhs) {
        return this.className.compareTo(rhs.getClassName());
    }

    public ConfiguredComponent deepCopy(Application app) throws Exception {
        ConfiguredComponent copy = (ConfiguredComponent)BeanUtils.cloneBean((Object)this);
        copy.setId(null);
        copy.setDetails(new HashMap<String, String>(this.details));
        copy.setReaders(new HashSet<String>(this.readers));
        copy.setLinkedComponents(new ArrayList<ConfiguredComponent>());
        copy.setApplication(app);
        return copy;
    }

    static {
        classesExcludedFromPushing.add("viewer.components.HTML");
    }
}

