/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.config.app;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.MapKey;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import nl.tailormap.viewer.config.app.Application;
import nl.tailormap.viewer.config.app.ApplicationLayer;
import nl.tailormap.viewer.config.app.StartLevel;
import nl.tailormap.viewer.config.services.Document;
import org.apache.commons.beanutils.BeanUtils;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.Type;

@Entity
@Table(name="level_")
public class Level
implements Comparable<Level> {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne
    @JoinColumn(name="parent")
    private Level parent;
    @Basic(optional=false)
    private String name;
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="level_children", joinColumns={@JoinColumn(name="level_", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="child")})
    @OrderColumn(name="list_index")
    private List<Level> children = new ArrayList<Level>();
    private boolean background;
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="level_layers", joinColumns={@JoinColumn(name="level_", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="layer")})
    @OrderColumn(name="list_index")
    @Cascade(value={org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    private List<ApplicationLayer> layers = new ArrayList<ApplicationLayer>();
    @ManyToMany
    @JoinTable(name="level_documents", inverseJoinColumns={@JoinColumn(name="document")}, joinColumns={@JoinColumn(name="level_", referencedColumnName="id")})
    @OrderColumn(name="list_index")
    private List<Document> documents = new ArrayList<Document>();
    @Lob
    @Type(type="org.hibernate.type.TextType")
    private String info;
    @ElementCollection
    @JoinTable(joinColumns={@JoinColumn(name="level_")})
    @Column(name="role_name")
    private Set<String> readers = new HashSet<String>();
    private String url;
    @OneToMany(mappedBy="level", orphanRemoval=true, cascade={CascadeType.ALL})
    @MapKey(name="application")
    private Map<Application, StartLevel> startLevels = new HashMap<Application, StartLevel>();

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public List<Level> getChildren() {
        return this.children;
    }

    public void setChildren(List<Level> children) {
        this.children = children;
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String info) {
        this.info = info;
    }

    public List<ApplicationLayer> getLayers() {
        return this.layers;
    }

    public void setLayers(List<ApplicationLayer> layers) {
        this.layers = layers;
    }

    public Level getParent() {
        return this.parent;
    }

    public void setParent(Level parent) {
        this.parent = parent;
    }

    public Set<String> getReaders() {
        return this.readers;
    }

    public void setReaders(Set<String> readers) {
        this.readers = readers;
    }

    public boolean isBackground() {
        return this.background;
    }

    public void setBackground(boolean background) {
        this.background = background;
    }

    public List<Document> getDocuments() {
        return this.documents;
    }

    public void setDocuments(List<Document> documents) {
        this.documents = documents;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public Map<Application, StartLevel> getStartLevels() {
        return this.startLevels;
    }

    public void setStartLevels(Map<Application, StartLevel> startLevels) {
        this.startLevels = startLevels;
    }

    public String getPath() {
        Level l = this;
        Object s = "";
        do {
            s = l.getName() + (String)(((String)s).length() == 0 ? "" : "/" + (String)s);
        } while ((l = l.getParent()) != null);
        return s;
    }

    public Level getParentInSubtree(ApplicationLayer appLayer) {
        for (ApplicationLayer al : this.layers) {
            if (!al.equals(appLayer)) continue;
            return this;
        }
        for (Level child : this.children) {
            Level parent = child.getParentInSubtree(appLayer);
            if (parent == null) continue;
            return parent;
        }
        return null;
    }

    public Level getParentInSubtree(Level level) {
        for (Level child : this.children) {
            if (child.equals(level)) {
                return this;
            }
            Level parent = child.getParentInSubtree(level);
            if (parent == null) continue;
            return parent;
        }
        return null;
    }

    public boolean containsLayerInSubtree(ApplicationLayer appLayer) {
        return this.getParentInSubtree(appLayer) != null;
    }

    public boolean containsLevelInSubtree(Level level) {
        return this.getParentInSubtree(level) != null;
    }

    public boolean hasLayerInSubtree() {
        if (!this.layers.isEmpty()) {
            return true;
        }
        for (Level level : this.children) {
            if (!level.hasLayerInSubtree()) continue;
            return true;
        }
        return false;
    }

    public boolean isInSubtreeOf(Level level) {
        Level parentLevel = this.parent;
        do {
            if (!parentLevel.equals(level)) continue;
            return true;
        } while ((parentLevel = parentLevel.getParent()) != null);
        return false;
    }

    public void processForMashup(Application mashup, Application motherApp) throws Exception {
        for (Level child : this.children) {
            child.processForMashup(mashup, motherApp);
        }
        for (ApplicationLayer layer : this.layers) {
            layer.processStartLayers(mashup, layer, motherApp);
        }
        this.processStartLevels(mashup, this, motherApp);
    }

    public void processForWorkversion(Application workversion, Application base) throws Exception {
        for (Level child : this.children) {
            child.processForWorkversion(workversion, base);
        }
        for (ApplicationLayer layer : this.layers) {
            layer.processStartLayers(workversion, (ApplicationLayer)workversion.originalToCopy.get(layer), base);
        }
        this.processStartLevels(workversion, (Level)workversion.originalToCopy.get(this), base);
    }

    private void processStartLevels(Application app, Level original, Application copyFrom) throws Exception {
        StartLevel sl = original.getStartLevels().get(copyFrom);
        if (sl != null) {
            this.getStartLevels().put(app, sl.deepCopy(app, this));
        } else if (Objects.equals(app.getId(), copyFrom.getId())) {
            ArrayList<StartLevel> sls = new ArrayList<StartLevel>(original.startLevels.values());
            for (StartLevel value : sls) {
                this.getStartLevels().put(app, value.deepCopy(app, this));
            }
        }
    }

    public Level deepCopy(Level parent, Map originalToCopy, Application app, boolean processStartMap) throws Exception {
        Level copy = (Level)BeanUtils.cloneBean((Object)this);
        originalToCopy.put(this, copy);
        copy.setId(null);
        copy.setParent(parent);
        copy.setChildren(new ArrayList<Level>());
        for (Level child : this.children) {
            copy.getChildren().add(child.deepCopy(copy, originalToCopy, app, processStartMap));
        }
        copy.setLayers(new ArrayList<ApplicationLayer>());
        for (ApplicationLayer appLayer : this.layers) {
            copy.getLayers().add(appLayer.deepCopy(originalToCopy, app, processStartMap));
        }
        copy.setStartLevels(new HashMap<Application, StartLevel>());
        if (processStartMap) {
            copy.processStartLevels(app, this, app);
        }
        copy.setDocuments(new ArrayList<Document>(this.documents));
        copy.setReaders(new HashSet<String>(this.readers));
        copy.setInfo(this.info);
        copy.setUrl(this.url);
        return copy;
    }

    public String toString() {
        return String.format("Level [id=%d, name=%s, parent=%d]", this.id, this.name, this.parent == null ? null : this.parent.getId());
    }

    @Override
    public int compareTo(Level level) {
        return this.getName().compareTo(level.getName());
    }
}

