/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.config.security;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Set;
import javax.persistence.EntityManager;
import nl.tailormap.viewer.config.forms.Form;
import nl.tailormap.viewer.config.security.User;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Authorizations {
    public static final String AUTHORIZATIONS_KEY = "authorizations";
    private static final Log log = LogFactory.getLog(Authorizations.class);

    public static boolean isFormAuthorized(Form f, Set<String> userRoles, EntityManager em) {
        Set<String> formRoles = f.getReaders();
        return !Collections.disjoint(userRoles, formRoles) || formRoles.isEmpty();
    }

    public static boolean isUserExpired(User u) {
        Date today;
        Date expire;
        if (u == null) {
            return false;
        }
        try {
            SimpleDateFormat formatter = new SimpleDateFormat("dd-MM-yyyy");
            expire = formatter.parse(u.getDetails().getOrDefault("expiry_date", formatter.format(new Date())));
            today = formatter.parse(formatter.format(new Date()));
        }
        catch (ParseException e) {
            log.error((Object)("Error parsing expiry_date for user: " + u.getUsername()), (Throwable)e);
            return true;
        }
        return today.after(expire);
    }

    private Authorizations() {
    }
}

