/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.config.services;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import nl.tailormap.viewer.config.services.GeoService;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"parent", "name"})})
public class Category {
    public static final Long ROOT_CATEGORY_ID = 0L;
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Basic(optional=false)
    private String name;
    @ManyToOne
    @JoinColumn(name="parent")
    private Category parent;
    @ManyToMany
    @JoinTable(name="category_children", inverseJoinColumns={@JoinColumn(name="child")}, joinColumns={@JoinColumn(name="category", referencedColumnName="id")})
    @OrderColumn(name="list_index")
    private List<Category> children = new ArrayList<Category>();
    @ManyToMany
    @JoinTable(name="category_services", inverseJoinColumns={@JoinColumn(name="service")}, joinColumns={@JoinColumn(name="category", referencedColumnName="id")})
    @OrderColumn(name="list_index")
    private List<GeoService> services = new ArrayList<GeoService>();
    @ElementCollection
    @Column(name="role_name")
    @CollectionTable(joinColumns={@JoinColumn(name="category")})
    private Set<String> readers = new HashSet<String>();
    @ElementCollection
    @CollectionTable(joinColumns={@JoinColumn(name="category")})
    @Column(name="role_name")
    private Set<String> writers = new HashSet<String>();

    public List<Category> getChildren() {
        return this.children;
    }

    public void setChildren(List<Category> children) {
        this.children = children;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Category getParent() {
        return this.parent;
    }

    public void setParent(Category parent) {
        this.parent = parent;
    }

    public Set<String> getReaders() {
        return this.readers;
    }

    public void setReaders(Set<String> readers) {
        this.readers = readers;
    }

    public Set<String> getWriters() {
        return this.writers;
    }

    public void setWriters(Set<String> writers) {
        this.writers = writers;
    }

    public List<GeoService> getServices() {
        return this.services;
    }

    public void setServices(List<GeoService> services) {
        this.services = services;
    }
}

