/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.config.services;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OrderColumn;
import nl.tailormap.viewer.config.services.GeoService;
import nl.tailormap.viewer.config.services.SimpleFeatureType;
import org.apache.commons.lang3.mutable.MutableBoolean;
import org.json.JSONException;
import org.json.JSONObject;

@Entity
@DiscriminatorColumn(name="protocol")
public abstract class FeatureSource {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Basic(optional=false)
    private String name;
    @Basic(optional=false)
    private String url;
    private String username;
    private String password;
    @ManyToOne
    @JoinColumn(name="linked_service")
    private GeoService linkedService;
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(name="feature_source_feature_types", inverseJoinColumns={@JoinColumn(name="feature_type")}, joinColumns={@JoinColumn(name="feature_source", referencedColumnName="id")})
    @OrderColumn(name="list_index")
    private List<SimpleFeatureType> featureTypes = new ArrayList<SimpleFeatureType>();

    public List<SimpleFeatureType> getFeatureTypes() {
        return this.featureTypes;
    }

    public void setFeatureTypes(List<SimpleFeatureType> featureTypes) {
        this.featureTypes = featureTypes;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public GeoService getLinkedService() {
        return this.linkedService;
    }

    public void setLinkedService(GeoService linkedService) {
        this.linkedService = linkedService;
    }

    public String getProtocol() {
        return this.getClass().getAnnotation(DiscriminatorValue.class).value();
    }

    public SimpleFeatureType getFeatureType(String typeName) {
        for (SimpleFeatureType sft : this.getFeatureTypes()) {
            if (!sft.getTypeName().equals(typeName)) continue;
            return sft;
        }
        return null;
    }

    public SimpleFeatureType addOrUpdateFeatureType(String typeName, SimpleFeatureType newType, MutableBoolean updated) {
        SimpleFeatureType old = this.getFeatureType(typeName);
        if (old != null) {
            updated.setValue(old.update(newType));
            return old;
        }
        newType.setFeatureSource(this);
        this.getFeatureTypes().add(newType);
        return newType;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("id", (Object)this.getId());
        json.put("name", (Object)this.getName());
        json.put("protocol", (Object)this.getProtocol());
        json.put("url", (Object)this.getUrl());
        return json;
    }
}

