/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.config.services;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import nl.tailormap.viewer.config.services.FeatureTypeRelationKey;
import nl.tailormap.viewer.config.services.SimpleFeatureType;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Entity
public class FeatureTypeRelation {
    public static final String JOIN = "join";
    public static final String RELATE = "relate";
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne
    @JoinColumn(name="feature_type")
    private SimpleFeatureType featureType;
    @ManyToOne
    @JoinColumn(name="foreign_feature_type")
    private SimpleFeatureType foreignFeatureType;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="relation", orphanRemoval=true)
    private List<FeatureTypeRelationKey> relationKeys = new ArrayList<FeatureTypeRelationKey>();
    private String type;
    private boolean searchNextRelation;
    private boolean canCreateNewRelation;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public void setFeatureType(SimpleFeatureType featureType) {
        this.featureType = featureType;
    }

    public List<FeatureTypeRelationKey> getRelationKeys() {
        return this.relationKeys;
    }

    public void setRelationKeys(List<FeatureTypeRelationKey> relationKeys) {
        this.relationKeys = relationKeys;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public SimpleFeatureType getForeignFeatureType() {
        return this.foreignFeatureType;
    }

    public void setForeignFeatureType(SimpleFeatureType foreignFeatureType) {
        this.foreignFeatureType = foreignFeatureType;
    }

    public boolean isSearchNextRelation() {
        return this.searchNextRelation;
    }

    public void setSearchNextRelation(boolean searchNextRelation) {
        this.searchNextRelation = searchNextRelation;
    }

    public boolean isCanCreateNewRelation() {
        return this.canCreateNewRelation;
    }

    public void setCanCreateNewRelation(boolean canCreateNewRelation) {
        this.canCreateNewRelation = canCreateNewRelation;
    }

    public JSONObject toJSONObject(SimpleFeatureType head) throws JSONException {
        JSONObject j = new JSONObject();
        j.put("type", (Object)this.type);
        if (this.featureType != null) {
            j.put("featureType", (Object)this.featureType.getId());
            j.put("featureTypeName", (Object)this.featureType.getTypeName());
            j.put("featureTypePrimaryKeyAttribute", (Object)this.featureType.getPrimaryKeyAttribute());
            JSONArray keys = new JSONArray();
            j.put("relationKeys", (Object)keys);
            this.relationKeys.forEach(key -> keys.put((Object)key.toJSONObject()));
        }
        if (this.foreignFeatureType != null) {
            j.put("foreignFeatureType", (Object)this.foreignFeatureType.getId());
            j.put("foreignFeatureTypeName", (Object)this.foreignFeatureType.getTypeName());
            j.put("foreignFeatureTypePrimaryKeyAttribute", (Object)this.foreignFeatureType.getPrimaryKeyAttribute());
            JSONArray jRel = new JSONArray();
            if (!this.foreignFeatureType.getRelations().isEmpty() && this.isSearchNextRelation() && !head.getTypeName().equals(this.foreignFeatureType.getTypeName())) {
                j.put("relations", (Object)jRel);
                for (FeatureTypeRelation rel : this.foreignFeatureType.getRelations()) {
                    jRel.put((Object)rel.toJSONObject(head));
                }
            }
        }
        return j;
    }
}

