/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.config.services;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.persistence.Basic;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.DiscriminatorColumn;
import javax.persistence.DiscriminatorValue;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToOne;
import javax.persistence.NoResultException;
import javax.persistence.OneToMany;
import javax.persistence.OneToOne;
import javax.persistence.OrderColumn;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import nl.tailormap.viewer.config.ClobElement;
import nl.tailormap.viewer.config.services.Category;
import nl.tailormap.viewer.config.services.Layer;
import nl.tailormap.viewer.config.services.StyleLibrary;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.hibernate.annotations.Type;

@Entity
@DiscriminatorColumn(name="protocol")
public abstract class GeoService
implements Serializable {
    public static final String PARAM_ONLINE_CHECK_ONLY = "onlineCheckOnly";
    public static final String PARAM_MUST_LOGIN = "mustLogin";
    public static final String DETAIL_OVERRIDDEN_URL = "overridenUrl";
    public static final String DETAIL_ORIGINAL_NAME = "originalName";
    public static final String DETAIL_USE_INTERSECT = "useIntersect";
    public static final String DETAIL_USE_PROXY = "useProxy";
    public static final String PARAM_USERNAME = "username";
    public static final String PARAM_PASSWORD = "password";
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Basic(optional=false)
    private String name;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="category")
    private Category category;
    @Basic(optional=false)
    private String url;
    private String username;
    private String password;
    private String geofenceHeader;
    private String version;
    private boolean monitoringEnabled;
    private boolean monitoringStatusok = true;
    @OneToOne(cascade={CascadeType.PERSIST})
    @JoinColumn(name="top_layer")
    private Layer topLayer;
    @ElementCollection
    @CollectionTable(joinColumns={@JoinColumn(name="geo_service")})
    @Column(name="keyword")
    private Set<String> keywords = new HashSet<String>();
    @Transient
    private List<Layer> layers;
    @Transient
    private Map<Layer, List<Layer>> childrenByParent = null;
    @Basic(optional=false)
    @Temporal(value=TemporalType.TIMESTAMP)
    private Date authorizationsModified = new Date();
    @ElementCollection
    @JoinTable(joinColumns={@JoinColumn(name="geoservice")})
    private Map<String, ClobElement> details = new HashMap<String, ClobElement>();
    @JoinTable(name="geo_service_style_libraries", joinColumns={@JoinColumn(name="geo_service")}, inverseJoinColumns={@JoinColumn(name="style_library")})
    @OneToMany(cascade={CascadeType.PERSIST})
    @OrderColumn(name="list_index")
    private List<StyleLibrary> styleLibraries = new ArrayList<StyleLibrary>();
    @ElementCollection
    @CollectionTable(joinColumns={@JoinColumn(name="geo_service")})
    @Column(name="role_name")
    private Set<String> readers = new HashSet<String>();
    @Lob
    @Basic(fetch=FetchType.LAZY)
    @Type(type="org.hibernate.type.TextType")
    @Column(name="capabilities_doc")
    private String capabilitiesDoc;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Category getCategory() {
        return this.category;
    }

    public void setCategory(Category category) {
        this.category = category;
    }

    public Layer getTopLayer() {
        return this.topLayer;
    }

    public void setTopLayer(Layer topLayer) {
        this.topLayer = topLayer;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public Set<String> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(Set<String> keywords) {
        this.keywords = keywords;
    }

    public boolean isMonitoringEnabled() {
        return this.monitoringEnabled;
    }

    public void setMonitoringEnabled(boolean monitoringEnabled) {
        this.monitoringEnabled = monitoringEnabled;
    }

    public Date getAuthorizationsModified() {
        return this.authorizationsModified;
    }

    public void setAuthorizationsModified(Date authorizationsModified) {
        this.authorizationsModified = authorizationsModified;
    }

    public boolean isMonitoringStatusok() {
        return this.monitoringStatusok;
    }

    public void setMonitoringStatusok(boolean monitoringStatusOK) {
        this.monitoringStatusok = monitoringStatusOK;
    }

    public Map<String, ClobElement> getDetails() {
        return this.details;
    }

    public void setDetails(Map<String, ClobElement> details) {
        this.details = details;
    }

    public List<StyleLibrary> getStyleLibraries() {
        return this.styleLibraries;
    }

    public void setStyleLibraries(List<StyleLibrary> styleLibraries) {
        this.styleLibraries = styleLibraries;
    }

    public Set<String> getReaders() {
        return this.readers;
    }

    public void setReaders(Set<String> readers) {
        this.readers = readers;
    }

    public String getGeofenceHeader() {
        return this.geofenceHeader;
    }

    public void setGeofenceHeader(String geofenceHeader) {
        this.geofenceHeader = geofenceHeader;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getCapabilitiesDoc() {
        return this.capabilitiesDoc;
    }

    public void setCapabilitiesDoc(String capabilitiesDoc) {
        this.capabilitiesDoc = capabilitiesDoc;
    }

    public String getProtocol() {
        return this.getClass().getAnnotation(DiscriminatorValue.class).value();
    }

    public void authorizationsModified() {
        this.authorizationsModified = new Date();
    }

    public List<Layer> loadLayerTree(EntityManager em) {
        if (this.layers != null) {
            return this.layers;
        }
        if (!em.contains((Object)this)) {
            return Collections.emptyList();
        }
        this.layers = em.createNamedQuery("getLayerTree", Layer.class).setParameter("rootId", (Object)this.topLayer.getId()).getResultList();
        this.childrenByParent = new HashMap<Layer, List<Layer>>();
        for (Layer l : this.layers) {
            if (l.getParent() == null) continue;
            List parentChildren = this.childrenByParent.computeIfAbsent(l.getParent(), k -> new ArrayList());
            parentChildren.add(l);
        }
        return this.layers;
    }

    public List<Layer> getLayerChildrenCache(Layer l, EntityManager em) {
        if (this.childrenByParent != null) {
            if (!em.getEntityManagerFactory().getPersistenceUnitUtil().isLoaded(l.getChildren())) {
                List<Layer> childrenList = this.childrenByParent.get(l);
                return Objects.requireNonNullElse(childrenList, Collections.emptyList());
            }
            return l.getChildren();
        }
        return l.getChildren();
    }

    public Layer getSingleLayer(String layerName, EntityManager em) {
        try {
            return (Layer)em.createQuery("from Layer where service = :service and name = :n order by virtual desc").setParameter("service", (Object)this).setParameter("n", (Object)layerName).setMaxResults(1).getSingleResult();
        }
        catch (NoResultException nre) {
            return null;
        }
    }

    public Layer getLayer(String layerName, EntityManager em) {
        this.loadLayerTree(em);
        if (layerName == null || this.topLayer == null) {
            return null;
        }
        MutableObject layer = new MutableObject(null);
        this.topLayer.accept((l, em1) -> {
            if (StringUtils.equals((CharSequence)l.getName(), (CharSequence)layerName)) {
                layer.setValue((Object)l);
                return false;
            }
            return true;
        }, em);
        return (Layer)layer.getValue();
    }
}

