/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.config.services;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.CascadeType;
import javax.persistence.CollectionTable;
import javax.persistence.Column;
import javax.persistence.ElementCollection;
import javax.persistence.Entity;
import javax.persistence.EntityManager;
import javax.persistence.FetchType;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.Lob;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OrderColumn;
import nl.tailormap.viewer.config.ClobElement;
import nl.tailormap.viewer.config.RemoveEmptyMapValuesUtil;
import nl.tailormap.viewer.config.app.ApplicationLayer;
import nl.tailormap.viewer.config.services.BoundingBox;
import nl.tailormap.viewer.config.services.CoordinateReferenceSystem;
import nl.tailormap.viewer.config.services.GeoService;
import nl.tailormap.viewer.config.services.SimpleFeatureType;
import nl.tailormap.viewer.config.services.TileMatrixSet;
import nl.tailormap.viewer.config.services.TileSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.annotations.Type;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Entity
@DynamicUpdate
public class Layer
implements Serializable {
    private static final Log log = LogFactory.getLog(Layer.class);
    public static final String EXTRA_KEY_METADATA_URL = "metadata.url";
    public static final String EXTRA_KEY_METADATA_STYLESHEET_URL = "metadata.stylesheet";
    public static final String EXTRA_KEY_DOWNLOAD_URL = "download.url";
    public static final String EXTRA_KEY_FILTERABLE = "filterable";
    public static final String EXTRA_IMAGE_EXTENSION = "image_extension";
    public static final String EXTRA_KEY_ATTRIBUTION = "attribution";
    public static final String DETAIL_WMS_STYLES = "wms.styles";
    public static final String DETAIL_ALL_CHILDREN = "all_children";
    public static final String DETAIL_ALTERNATE_LEGEND_IMAGE_URL = "alternateLegendImageUrl";
    public static final String DETAIL_USERLAYER_FILTER = "userlayer_filter";
    public static final String DETAIL_USERLAYER_ORIGINAL_LAYERNAME = "userlayer_original_layername";
    public static final String DETAIL_USERLAYER_ORIGINAL_FEATURE_TYPE_NAME = "userlayer_original_feature_type_name";
    public static final String DETAIL_USERLAYER_ORIGINAL_LAYER_ID = "userlayer_original_layerid";
    public static final String DETAIL_USERLAYER_DATE_ADDED = "userlayer_date_added";
    public static final String DETAIL_USERLAYER_USER = "userlayer_user";
    private static final Set<String> interestingDetails = new HashSet<String>(Arrays.asList("metadata.url", "metadata.stylesheet", "download.url", "filterable", "image_extension", "all_children", "wms.styles", "alternateLegendImageUrl", "attribution"));
    private static final Set<String> updatableDetails = new HashSet<String>(Arrays.asList("metadata.url", "all_children", "wms.styles"));
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="service")
    private GeoService service;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="parent")
    private Layer parent;
    private String name;
    private String title;
    private String titleAlias;
    @Lob
    @Type(type="org.hibernate.type.TextType")
    private String legendImageUrl;
    private Double minScale;
    private Double maxScale;
    @ElementCollection
    @CollectionTable(joinColumns={@JoinColumn(name="layer")})
    private Set<CoordinateReferenceSystem> crsList = new HashSet<CoordinateReferenceSystem>();
    @ElementCollection
    @CollectionTable(joinColumns={@JoinColumn(name="layer")})
    private Map<CoordinateReferenceSystem, BoundingBox> boundingBoxes = new HashMap<CoordinateReferenceSystem, BoundingBox>();
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="tileset")
    private TileSet tileset;
    private boolean virtual;
    private boolean queryable;
    private boolean filterable;
    private Boolean userlayer = false;
    @ManyToOne(fetch=FetchType.LAZY, cascade={CascadeType.PERSIST, CascadeType.MERGE})
    @JoinColumn(name="feature_type")
    private SimpleFeatureType featureType;
    @ElementCollection
    @JoinTable(joinColumns={@JoinColumn(name="layer", referencedColumnName="id")})
    @Column(name="keyword")
    private Set<String> keywords = new HashSet<String>();
    @ElementCollection
    @JoinTable(joinColumns={@JoinColumn(name="layer", referencedColumnName="id")})
    @Column(name="role_name")
    private Set<String> readers = new HashSet<String>();
    @ElementCollection
    @JoinTable(joinColumns={@JoinColumn(name="layer", referencedColumnName="id")})
    @Column(name="role_name")
    public Set<String> writers = new HashSet<String>();
    @ElementCollection
    @JoinTable(joinColumns={@JoinColumn(name="layer", referencedColumnName="id")})
    @Column(name="role_name")
    public Set<String> preventGeomEditors = new HashSet<String>();
    @ManyToMany(cascade={CascadeType.PERSIST})
    @JoinTable(name="layer_children", inverseJoinColumns={@JoinColumn(name="child", unique=true)}, joinColumns={@JoinColumn(name="layer", referencedColumnName="id")})
    @OrderColumn(name="list_index")
    private List<Layer> children = new ArrayList<Layer>();
    @ElementCollection
    @JoinTable(joinColumns={@JoinColumn(name="layer")})
    private Map<String, ClobElement> details = new HashMap<String, ClobElement>();
    @ManyToMany(cascade={CascadeType.PERSIST})
    @JoinTable(name="layer_matrix_sets", joinColumns={@JoinColumn(name="layer", referencedColumnName="id")}, inverseJoinColumns={@JoinColumn(name="matrix_set")})
    @OrderColumn(name="list_index")
    private List<TileMatrixSet> matrixSets = new ArrayList<TileMatrixSet>();

    public Layer clone() throws CloneNotSupportedException {
        return (Layer)super.clone();
    }

    public void update(Layer update) {
        this.update(update, null);
    }

    public void update(Layer update, Set<String> additionalUpdatableDetails) {
        if (!this.getName().equals(update.getName())) {
            throw new IllegalArgumentException("Cannot update layer with properties from layer with different name!");
        }
        this.virtual = update.virtual;
        this.queryable = update.queryable;
        this.filterable = update.filterable;
        this.title = update.title;
        this.minScale = update.minScale;
        this.maxScale = update.maxScale;
        if (!this.boundingBoxes.equals(update.boundingBoxes)) {
            this.boundingBoxes.clear();
            this.boundingBoxes.putAll(update.boundingBoxes);
        }
        if (!this.crsList.equals(update.crsList)) {
            this.crsList.clear();
            this.crsList.addAll(update.crsList);
        }
        if (!this.keywords.equals(update.keywords)) {
            this.keywords.clear();
            this.keywords.addAll(update.keywords);
        }
        for (String s : updatableDetails) {
            this.details.remove(s);
        }
        if (additionalUpdatableDetails != null) {
            for (String s : additionalUpdatableDetails) {
                this.details.remove(s);
            }
        }
        this.details.putAll(update.getDetails());
        RemoveEmptyMapValuesUtil.removeEmptyMapValues(this.details);
        this.legendImageUrl = update.legendImageUrl;
    }

    public void copyUserModifiedProperties(Layer other) {
        this.setTitleAlias(other.getTitleAlias());
        this.getReaders().clear();
        this.getReaders().addAll(other.getReaders());
        this.getWriters().clear();
        this.getWriters().addAll(other.getWriters());
    }

    public boolean isBufferable() {
        return this.getFeatureType() != null;
    }

    public boolean accept(Visitor visitor, EntityManager em) {
        for (Layer child : this.getCachedChildren(em)) {
            if (child.accept(visitor, em)) continue;
            return false;
        }
        return visitor.visit(this, em);
    }

    public String getDisplayName() {
        if (StringUtils.isNotBlank((CharSequence)this.titleAlias)) {
            return this.titleAlias;
        }
        if (StringUtils.isNotBlank((CharSequence)this.title)) {
            return this.title;
        }
        return this.name;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject o = new JSONObject();
        o.put("id", (Object)this.id);
        o.put("serviceId", (Object)this.service.getId());
        o.put("name", (Object)this.name);
        o.put("virtual", this.virtual);
        o.put("queryable", this.queryable);
        o.put(EXTRA_KEY_FILTERABLE, this.filterable);
        o.put("userlayer", (Object)this.userlayer);
        if (this.title != null) {
            o.put("title", (Object)this.title);
        }
        if (this.titleAlias != null) {
            o.put("titleAlias", (Object)this.titleAlias);
        }
        if (this.legendImageUrl != null) {
            o.put("legendImageUrl", (Object)this.legendImageUrl);
        }
        if (this.minScale != null) {
            if (this.minScale.isNaN() || this.minScale.isInfinite()) {
                log.error((Object)("Can't use minScale: " + this.minScale + " of Servicelayer" + this.service.getName() + " - " + this.name));
            } else {
                o.put("minScale", (Object)this.minScale);
            }
        }
        if (this.maxScale != null) {
            if (this.maxScale.isNaN() || this.maxScale.isInfinite()) {
                log.error((Object)("Can't use maxScale: " + this.maxScale + " of Servicelayer" + this.service.getName() + " - " + this.name));
            } else {
                o.put("maxScale", (Object)this.maxScale);
            }
        }
        o.put("hasFeatureType", this.featureType != null);
        if (this.featureType != null) {
            o.put("featureTypeName", (Object)this.featureType.getTypeName());
            o.put("featureTypeId", (Object)this.featureType.getId());
        }
        if (!this.details.isEmpty()) {
            JSONObject d = new JSONObject();
            o.put("details", (Object)d);
            for (Map.Entry<String, ClobElement> e : this.details.entrySet()) {
                if (!interestingDetails.contains(e.getKey())) continue;
                d.put(e.getKey(), (Object)e.getValue().getValue());
            }
        }
        if (this.tileset != null) {
            o.put("tileHeight", this.tileset.getHeight());
            o.put("tileWidth", this.tileset.getWidth());
            if (this.tileset.getResolutions() != null) {
                StringBuilder resolutions = new StringBuilder();
                for (Double d : this.tileset.getResolutions()) {
                    if (resolutions.length() > 0) {
                        resolutions.append(",");
                    }
                    resolutions.append(d.toString());
                }
                o.put("resolutions", (Object)resolutions.toString());
            }
        }
        if (this.boundingBoxes.size() == 1) {
            BoundingBox bbox = this.boundingBoxes.values().iterator().next();
            o.put("bbox", (Object)bbox.toJSONObject());
        }
        JSONArray sets = new JSONArray();
        o.put("matrixSets", (Object)sets);
        for (TileMatrixSet matrixSet : this.matrixSets) {
            sets.put((Object)matrixSet.toJSONObject());
        }
        return o;
    }

    public List<Layer> getCachedChildren(EntityManager em) {
        return this.service.getLayerChildrenCache(this, em);
    }

    public List<ApplicationLayer> getApplicationLayers(EntityManager em) {
        return em.createQuery("from ApplicationLayer where service = :service and layerName = :layerName", ApplicationLayer.class).setParameter("service", (Object)this.service).setParameter("layerName", (Object)this.getName()).getResultList();
    }

    public Layer getParent() {
        return this.parent;
    }

    public void setParent(Layer parent) {
        this.parent = parent;
    }

    public boolean isVirtual() {
        return this.virtual;
    }

    public void setVirtual(boolean virtual) {
        this.virtual = virtual;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getTitleAlias() {
        return this.titleAlias;
    }

    public void setTitleAlias(String titleAlias) {
        this.titleAlias = titleAlias;
    }

    public GeoService getService() {
        return this.service;
    }

    public void setService(GeoService service) {
        this.service = service;
    }

    public Set<CoordinateReferenceSystem> getCrsList() {
        return this.crsList;
    }

    public void setCrsList(Set<CoordinateReferenceSystem> crsList) {
        this.crsList = crsList;
    }

    public SimpleFeatureType getFeatureType() {
        return this.featureType;
    }

    public void setFeatureType(SimpleFeatureType featureType) {
        this.featureType = featureType;
    }

    public boolean isFilterable() {
        return this.filterable;
    }

    public void setFilterable(boolean filterable) {
        this.filterable = filterable;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isQueryable() {
        return this.queryable;
    }

    public void setQueryable(boolean queryable) {
        this.queryable = queryable;
    }

    public Set<String> getReaders() {
        return this.readers;
    }

    public void setReaders(Set<String> readers) {
        this.readers = readers;
    }

    public Set<String> getWriters() {
        return this.writers;
    }

    public void setWriters(Set<String> writers) {
        this.writers = writers;
    }

    public Set<String> getPreventGeomEditors() {
        return this.preventGeomEditors;
    }

    public void setPreventGeomEditors(Set<String> preventGeomEditors) {
        this.preventGeomEditors = preventGeomEditors;
    }

    public List<Layer> getChildren() {
        return this.children;
    }

    public void setChildren(List<Layer> children) {
        this.children = children;
    }

    public Set<String> getKeywords() {
        return this.keywords;
    }

    public void setKeywords(Set<String> keywords) {
        this.keywords = keywords;
    }

    public Map<String, ClobElement> getDetails() {
        return this.details;
    }

    public void setDetails(Map<String, ClobElement> details) {
        this.details = details;
    }

    public Double getMaxScale() {
        return this.maxScale;
    }

    public void setMaxScale(Double maxScale) {
        this.maxScale = maxScale;
    }

    public Double getMinScale() {
        return this.minScale;
    }

    public void setMinScale(Double minScale) {
        this.minScale = minScale;
    }

    public TileSet getTileset() {
        return this.tileset;
    }

    public void setTileset(TileSet tileset) {
        this.tileset = tileset;
    }

    public String getLegendImageUrl() {
        return this.legendImageUrl;
    }

    public void setLegendImageUrl(String legendImageUrl) {
        this.legendImageUrl = legendImageUrl;
    }

    public Map<CoordinateReferenceSystem, BoundingBox> getBoundingBoxes() {
        return this.boundingBoxes;
    }

    public void setBoundingBoxes(Map<CoordinateReferenceSystem, BoundingBox> boundingBoxes) {
        this.boundingBoxes = boundingBoxes;
    }

    public List<TileMatrixSet> getMatrixSets() {
        return this.matrixSets;
    }

    public void setMatrixSets(List<TileMatrixSet> matrixSets) {
        this.matrixSets = matrixSets;
    }

    public Boolean isUserlayer() {
        return this.userlayer;
    }

    public void setUserlayer(boolean userlayer) {
        this.userlayer = userlayer;
    }

    public static interface Visitor {
        public boolean visit(Layer var1, EntityManager var2);
    }
}

