/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.config.services;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinTable;
import javax.persistence.ManyToMany;
import javax.persistence.ManyToOne;
import javax.persistence.OneToMany;
import javax.persistence.OrderColumn;
import javax.persistence.Table;
import nl.tailormap.viewer.config.services.AttributeDescriptor;
import nl.tailormap.viewer.config.services.FeatureSource;
import nl.tailormap.viewer.config.services.FeatureTypeRelation;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.DynamicUpdate;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

@Entity
@Table(name="feature_type")
@DynamicUpdate
public class SimpleFeatureType {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @ManyToOne(cascade={CascadeType.PERSIST})
    @JoinColumn(name="feature_source")
    private FeatureSource featureSource;
    private String typeName;
    private String description;
    private boolean writeable;
    private String geometryAttribute;
    private String primaryKeyAttribute;
    @OneToMany(cascade={CascadeType.ALL}, mappedBy="featureType")
    private List<FeatureTypeRelation> relations = new ArrayList<FeatureTypeRelation>();
    @ManyToMany(cascade={CascadeType.ALL})
    @JoinTable(inverseJoinColumns={@JoinColumn(name="attribute_descriptor")}, name="feature_type_attributes", joinColumns={@JoinColumn(name="feature_type", referencedColumnName="id")})
    @OrderColumn(name="list_index")
    private List<AttributeDescriptor> attributes = new ArrayList<AttributeDescriptor>();

    public List<AttributeDescriptor> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(List<AttributeDescriptor> attributes) {
        this.attributes = attributes;
    }

    public FeatureSource getFeatureSource() {
        return this.featureSource;
    }

    public void setFeatureSource(FeatureSource featureSource) {
        this.featureSource = featureSource;
    }

    public String getGeometryAttribute() {
        return this.geometryAttribute;
    }

    public void setGeometryAttribute(String geometryAttribute) {
        this.geometryAttribute = geometryAttribute;
    }

    public boolean isWriteable() {
        return this.writeable;
    }

    public void setWriteable(boolean writeable) {
        this.writeable = writeable;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public List<FeatureTypeRelation> getRelations() {
        return this.relations;
    }

    public void setRelations(List<FeatureTypeRelation> relations) {
        this.relations = relations;
    }

    public String getPrimaryKeyAttribute() {
        return this.primaryKeyAttribute;
    }

    public void setPrimaryKeyAttribute(String primaryKeyAttribute) {
        this.primaryKeyAttribute = primaryKeyAttribute;
    }

    public boolean update(SimpleFeatureType update) {
        if (!this.getTypeName().equals(update.getTypeName())) {
            throw new IllegalArgumentException("Cannot update feature type with properties from feature type with different type name!");
        }
        this.description = update.description;
        this.writeable = update.writeable;
        this.geometryAttribute = update.geometryAttribute;
        this.primaryKeyAttribute = update.primaryKeyAttribute;
        boolean changed = false;
        HashMap<String, String> aliasesByAttributeName = new HashMap<String, String>();
        for (AttributeDescriptor ad : this.attributes) {
            if (!StringUtils.isNotBlank((CharSequence)ad.getAlias())) continue;
            aliasesByAttributeName.put(ad.getName(), ad.getAlias());
        }
        if (!this.attributes.equals(update.attributes)) {
            int i;
            changed = true;
            for (i = 0; i < this.attributes.size(); ++i) {
                boolean notFound = true;
                for (AttributeDescriptor newAttribute : update.attributes) {
                    if (!this.attributes.get(i).getName().equals(newAttribute.getName())) continue;
                    notFound = false;
                    AttributeDescriptor oldAttr = this.attributes.get(i);
                    if (Objects.equals(oldAttr.getType(), newAttribute.getType())) break;
                    this.attributes.remove(i);
                    this.attributes.add(i, newAttribute);
                    break;
                }
                if (!notFound) continue;
                this.attributes.remove(i);
            }
            for (i = 0; i < update.attributes.size(); ++i) {
                boolean notFound = true;
                for (AttributeDescriptor oldAttribute : this.attributes) {
                    if (!update.attributes.get(i).getName().equals(oldAttribute.getName())) continue;
                    notFound = false;
                    break;
                }
                if (!notFound) continue;
                this.attributes.add(update.attributes.get(i));
            }
        }
        for (AttributeDescriptor ad : this.attributes) {
            String alias = (String)aliasesByAttributeName.get(ad.getName());
            if (alias == null) continue;
            ad.setAlias(alias);
        }
        return changed;
    }

    public AttributeDescriptor getAttribute(String attributeName) {
        for (AttributeDescriptor ad : this.attributes) {
            if (!ad.getName().equals(attributeName)) continue;
            return ad;
        }
        return null;
    }

    public JSONObject toJSONObject() throws JSONException {
        JSONObject o = new JSONObject();
        o.put("id", (Object)this.id);
        o.put("typeName", (Object)this.typeName);
        o.put("writeable", this.writeable);
        o.put("geometryAttribute", (Object)this.geometryAttribute);
        o.put("primaryKeyAttribute", (Object)this.primaryKeyAttribute);
        JSONArray atts = new JSONArray();
        o.put("attributes", (Object)atts);
        for (AttributeDescriptor a : this.attributes) {
            JSONObject ja = new JSONObject();
            ja.put("id", (Object)a.getId());
            ja.put("name", (Object)a.getName());
            ja.put("alias", (Object)a.getAlias());
            ja.put("type", (Object)a.getType());
            atts.put((Object)ja);
        }
        return o;
    }

    public boolean hasRelations() {
        return this.relations != null && !this.relations.isEmpty();
    }
}

