/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.config.services;

import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Lob;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.hibernate.annotations.Type;
import org.json.JSONArray;
import org.json.JSONObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

@Entity
public class StyleLibrary {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    private Long id;
    @Basic(optional=false)
    private String title;
    private boolean defaultStyle;
    @Column(length=1000)
    private String externalUrl;
    @Lob
    @Type(type="org.hibernate.type.TextType")
    private String sldBody;
    @Lob
    @Type(type="org.hibernate.type.TextType")
    private String namedLayerUserStylesJson;
    private String extraLegendParameters;

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public boolean isDefaultStyle() {
        return this.defaultStyle;
    }

    public void setDefaultStyle(boolean defaultStyle) {
        this.defaultStyle = defaultStyle;
    }

    public String getExternalUrl() {
        return this.externalUrl;
    }

    public void setExternalUrl(String externalUrl) {
        this.externalUrl = externalUrl;
    }

    public String getSldBody() {
        return this.sldBody;
    }

    public void setSldBody(String sldBody) {
        this.sldBody = sldBody;
    }

    public String getNamedLayerUserStylesJson() {
        return this.namedLayerUserStylesJson;
    }

    public void setNamedLayerUserStylesJson(String namedLayerUserStylesJson) {
        this.namedLayerUserStylesJson = namedLayerUserStylesJson;
    }

    public String getExtraLegendParameters() {
        return this.extraLegendParameters;
    }

    public void setExtraLegendParameters(String extraLegendParameters) {
        this.extraLegendParameters = extraLegendParameters;
    }

    public static JSONObject parseSLDNamedLayerUserStyles(InputSource sldBody) throws Exception {
        JSONObject j = new JSONObject();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        DocumentBuilder db = dbf.newDocumentBuilder();
        Document sld = db.parse(sldBody);
        NodeList namedLayers = sld.getDocumentElement().getElementsByTagName("NamedLayer");
        for (int i = 0; i < namedLayers.getLength(); ++i) {
            Node child;
            Node namedLayer = namedLayers.item(i);
            for (child = namedLayer.getFirstChild(); child != null && !"Name".equals(child.getLocalName()); child = child.getNextSibling()) {
            }
            if (child == null) continue;
            String layerName = child.getTextContent();
            JSONObject layer = new JSONObject();
            JSONArray styles = new JSONArray();
            layer.put("styles", (Object)styles);
            child = child.getNextSibling();
            if (child != null && !"Description".equals(child.getLocalName()) && !"UserStyle".equals(child.getLocalName())) {
                child = child.getNextSibling();
            }
            if (child != null && "Description".equals(child.getLocalName())) {
                Node descNode;
                for (descNode = child.getFirstChild(); descNode != null && !"Title".equals(descNode.getLocalName()); descNode = descNode.getNextSibling()) {
                }
                if (descNode != null) {
                    layer.put("title", (Object)descNode.getTextContent());
                }
            }
            while (true) {
                if (child != null && !"UserStyle".equals(child.getLocalName())) {
                    child = child.getNextSibling();
                    continue;
                }
                if (child != null) {
                    Node child2;
                    for (child2 = child.getFirstChild(); child2 != null && !"Name".equals(child2.getLocalName()); child2 = child2.getNextSibling()) {
                    }
                    if (child2 != null) {
                        JSONObject style = new JSONObject();
                        style.put("name", (Object)child2.getTextContent());
                        styles.put((Object)style);
                        for (child2 = child2.getNextSibling(); child2 != null && !"Description".equals(child2.getLocalName()) && !"Title".equals(child2.getLocalName()); child2 = child2.getNextSibling()) {
                        }
                        if (child2 != null) {
                            if ("Title".equals(child2.getLocalName())) {
                                style.put("title", (Object)child2.getTextContent());
                            } else {
                                Node descNode;
                                for (descNode = child2.getFirstChild(); descNode != null && !"Title".equals(descNode.getLocalName()); descNode = descNode.getNextSibling()) {
                                }
                                if (descNode != null) {
                                    style.put("title", (Object)descNode.getTextContent());
                                }
                            }
                        }
                    }
                    child = child.getNextSibling();
                }
                if (child == null) break;
            }
            j.put(layerName, (Object)layer);
        }
        return j;
    }
}

