/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.config.services;

import java.util.ArrayList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.DiscriminatorValue;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import nl.tailormap.viewer.config.services.GeoService;
import nl.tailormap.viewer.config.services.Layer;
import nl.tailormap.viewer.config.services.TileMatrixSet;

@Entity
@DiscriminatorValue(value="tiled")
public class TileService
extends GeoService {
    public static final String PROTOCOL = "tiled";
    public static final String PARAM_RESOLUTIONS = "resolutions";
    public static final String PARAM_TILESIZE = "tileSize";
    public static final String PARAM_TILINGPROTOCOL = "tilingProtocol";
    public static final String PARAM_SERVICENAME = "ServiceName";
    public static final String PARAM_SERVICEBBOX = "serviceBbox";
    public static final String PARAM_IMAGEEXTENSION = "imageExtension";
    public static final String PARAM_CRS = "crs";
    public static final String TILING_PROTOCOL_WMTS = "WMTS";
    public static final String TILING_PROTOCOL_TMS = "TMS";
    @OneToMany(cascade={CascadeType.ALL}, fetch=FetchType.LAZY, mappedBy="tileService")
    private List<TileMatrixSet> matrixSets = new ArrayList<TileMatrixSet>();
    private String tilingProtocol;

    public Layer getTilingLayer() {
        if (this.getTopLayer() != null && this.getTopLayer().getChildren().size() > 0) {
            return this.getTopLayer().getChildren().get(0);
        }
        return null;
    }

    public List<TileMatrixSet> getMatrixSets() {
        return this.matrixSets;
    }

    public void setMatrixSets(List<TileMatrixSet> matrixSets) {
        this.matrixSets = matrixSets;
    }

    public String getTilingProtocol() {
        return this.tilingProtocol;
    }

    public void setTilingProtocol(String tilingProtocol) {
        this.tilingProtocol = tilingProtocol;
    }
}

