/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.util;

import java.io.IOException;
import java.io.LineNumberReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ScriptRunner {
    private static final Log log = LogFactory.getLog(ScriptRunner.class);
    private static final String DEFAULT_DELIMITER = ";";
    private final Connection connection;
    private final boolean stopOnError;
    private final boolean autoCommit;
    private String delimiter = ";";
    private boolean fullLineDelimiter = false;

    public ScriptRunner(Connection connection, boolean autoCommit, boolean stopOnError) {
        this.connection = connection;
        this.autoCommit = autoCommit;
        this.stopOnError = stopOnError;
    }

    public void setDelimiter(String delimiter, boolean fullLineDelimiter) {
        this.delimiter = delimiter;
        this.fullLineDelimiter = fullLineDelimiter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runScript(Reader reader, boolean canFail) throws SQLException {
        try {
            boolean originalAutoCommit = this.connection.getAutoCommit();
            try {
                if (originalAutoCommit != this.autoCommit) {
                    this.connection.setAutoCommit(this.autoCommit);
                }
                this.runScript(this.connection, reader, canFail);
            }
            finally {
                this.connection.setAutoCommit(originalAutoCommit);
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException("Error running script.  Cause: " + e.getLocalizedMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runScript(Connection conn, Reader reader, boolean canFail) throws IOException, SQLException {
        StringBuffer command = null;
        try {
            String line;
            LineNumberReader lineReader = new LineNumberReader(reader);
            while ((line = lineReader.readLine()) != null) {
                String trimmedLine;
                if (command == null) {
                    command = new StringBuffer();
                }
                if ((trimmedLine = line.trim()).startsWith("--")) {
                    log.debug((Object)trimmedLine);
                    continue;
                }
                if (trimmedLine.length() < 1 || trimmedLine.startsWith("//") || trimmedLine.length() < 1 || trimmedLine.startsWith("--")) continue;
                if (!this.fullLineDelimiter && trimmedLine.endsWith(this.getDelimiter()) || this.fullLineDelimiter && trimmedLine.equals(this.getDelimiter())) {
                    command.append(line, 0, line.lastIndexOf(this.getDelimiter()));
                    command.append(" ");
                    Statement statement = conn.createStatement();
                    log.debug((Object)command);
                    boolean hasResults = false;
                    if (this.stopOnError) {
                        hasResults = statement.execute(command.toString());
                    } else {
                        try {
                            statement.execute(command.toString());
                        }
                        catch (SQLException e) {
                            e.fillInStackTrace();
                            log.error((Object)("Error executing command: " + command), (Throwable)e);
                        }
                    }
                    if (this.autoCommit && !conn.getAutoCommit()) {
                        conn.commit();
                    }
                    ResultSet rs = statement.getResultSet();
                    if (hasResults && rs != null) {
                        int i;
                        ResultSetMetaData md = rs.getMetaData();
                        int cols = md.getColumnCount();
                        for (i = 0; i < cols; ++i) {
                            String name = md.getColumnLabel(i);
                            log.debug((Object)(name + "\t"));
                        }
                        while (rs.next()) {
                            for (i = 0; i < cols; ++i) {
                                String value = rs.getString(i);
                                log.debug((Object)(value + "\t"));
                            }
                        }
                    }
                    command = null;
                    try {
                        if (null != rs) {
                            rs.close();
                        }
                        statement.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    Thread.yield();
                    continue;
                }
                command.append(line);
                command.append(" ");
            }
            if (!this.autoCommit) {
                conn.commit();
            }
        }
        catch (IOException | SQLException e) {
            e.fillInStackTrace();
            if (!canFail) {
                log.error((Object)("Error executing: " + command), (Throwable)e);
                throw e;
            }
            log.error((Object)("Error executing: " + command + " but ignoring, because it is allowed to fail." + e.getLocalizedMessage()));
        }
        finally {
            if (!this.autoCommit) {
                conn.rollback();
            }
        }
    }

    private String getDelimiter() {
        return this.delimiter;
    }
}

