
    create table application (
       id  bigserial not null,
        authenticated_required boolean not null,
        authorizations_modified timestamp not null,
        lang varchar(255),
        layout text,
        max_crs varchar(255),
        max_maxx float8,
        max_maxy float8,
        max_minx float8,
        max_miny float8,
        name varchar(255) not null,
        projection_code varchar(255),
        start_crs varchar(255),
        start_maxx float8,
        start_maxy float8,
        start_minx float8,
        start_miny float8,
        title varchar(255),
        version varchar(30),
        owner varchar(255),
        root int8,
        primary key (id)
    );

    create table application_details (
       application int8 not null,
        value text,
        details_key varchar(255) not null,
        primary key (application, details_key)
    );

    create table application_layer_attributes (
       application_layer int8 not null,
        attribute_ int8 not null,
        list_index int4 not null,
        primary key (application_layer, list_index)
    );

    create table application_readers (
       application int8 not null,
        role_name varchar(255)
    );

    create table application_layer (
       id  bigserial not null,
        layer_name varchar(255) not null,
        service int8,
        primary key (id)
    );

    create table application_layer_details (
       application_layer int8 not null,
        value text,
        details_key varchar(255) not null,
        primary key (application_layer, details_key)
    );

    create table application_layer_readers (
       application_layer int8 not null,
        role_name varchar(255)
    );

    create table application_layer_writers (
       application_layer int8 not null,
        role_name varchar(255)
    );

    create table attribute_descriptor (
       id  bigserial not null,
        name_alias varchar(255),
        name varchar(255) not null,
        type varchar(255),
        primary key (id)
    );

    create table bookmark (
       id  bigserial not null,
        code varchar(255),
        created_at timestamp,
        created_by varchar(255),
        params text not null,
        application int8,
        primary key (id)
    );

    create table category (
       id  bigserial not null,
        name varchar(255) not null,
        parent int8,
        primary key (id)
    );

    create table category_children (
       category int8 not null,
        child int8 not null,
        list_index int4 not null,
        primary key (category, list_index)
    );

    create table category_readers (
       category int8 not null,
        role_name varchar(255)
    );

    create table category_services (
       category int8 not null,
        service int8 not null,
        list_index int4 not null,
        primary key (category, list_index)
    );

    create table category_writers (
       category int8 not null,
        role_name varchar(255)
    );

    create table configured_attribute (
       id  bigserial not null,
        allow_value_list_only boolean not null,
        attribute_name varchar(255),
        automatic_value boolean not null,
        automatic_value_type varchar(255),
        default_value varchar(255),
        disable_user_edit boolean not null,
        disallow_null_value boolean not null,
        edit_alias varchar(255),
        edit_height varchar(255),
        edit_values text,
        editable boolean not null,
        filterable boolean not null,
        label varchar(255),
        selectable boolean not null,
        value_list varchar(255),
        value_list_label_name varchar(255),
        value_list_value_name varchar(255),
        visible boolean not null,
        feature_type int8,
        value_list_feature_source int8,
        value_list_feature_type int8,
        primary key (id)
    );

    create table configured_component (
       id  bigserial not null,
        class_name varchar(255) not null,
        config text,
        name varchar(255) not null,
        application int8 not null,
        mother_component int8,
        primary key (id)
    );

    create table configured_component_details (
       configured_component int8 not null,
        details varchar(255),
        details_key varchar(255) not null,
        primary key (configured_component, details_key)
    );

    create table configured_component_readers (
       configured_component int8 not null,
        role_name varchar(255)
    );

    create table document (
       id  bigserial not null,
        category varchar(255),
        name varchar(255) not null,
        url varchar(255) not null,
        primary key (id)
    );

    create table feature_source_feature_types (
       feature_source int8 not null,
        feature_type int8 not null,
        list_index int4 not null,
        primary key (feature_source, list_index)
    );

    create table feature_type (
       id  bigserial not null,
        description varchar(255),
        geometry_attribute varchar(255),
        primary_key_attribute varchar(255),
        type_name varchar(255),
        writeable boolean not null,
        feature_source int8,
        primary key (id)
    );

    create table feature_type_attributes (
       feature_type int8 not null,
        attribute_descriptor int8 not null,
        list_index int4 not null,
        primary key (feature_type, list_index)
    );

    create table feature_source (
       protocol varchar(31) not null,
        id  bigserial not null,
        name varchar(255) not null,
        password varchar(255),
        url varchar(255) not null,
        username varchar(255),
        db_schema varchar(255),
        linked_service int8,
        primary key (id)
    );

    create table feature_type_relation (
       id  bigserial not null,
        can_create_new_relation boolean not null,
        search_next_relation boolean not null,
        type varchar(255),
        feature_type int8,
        foreign_feature_type int8,
        primary key (id)
    );

    create table feature_type_relation_key (
       id  bigserial not null,
        left_side int8,
        relation int8,
        right_side int8,
        primary key (id)
    );

    create table file_upload (
       id  bigserial not null,
        created_at timestamp,
        created_by varchar(255),
        fid varchar(255),
        filename varchar(255),
        location varchar(255),
        mimetype varchar(255),
        type_ varchar(255),
        sft int8,
        primary key (id)
    );

    create table form (
       id  bigserial not null,
        feature_type_name varchar(255),
        json text,
        name varchar(255),
        sft int8,
        primary key (id)
    );

    create table form_readers (
       form int8 not null,
        role_name varchar(255)
    );

    create table geo_service_style_libraries (
       geo_service int8 not null,
        style_library int8 not null,
        list_index int4 not null,
        primary key (geo_service, list_index)
    );

    create table geo_service (
       protocol varchar(31) not null,
        id  bigserial not null,
        authorizations_modified timestamp not null,
        capabilities_doc text,
        geofence_header varchar(255),
        monitoring_enabled boolean not null,
        monitoring_statusok boolean not null,
        name varchar(255) not null,
        password varchar(255),
        url varchar(255) not null,
        username varchar(255),
        version varchar(255),
        exception_type varchar(255),
        override_url boolean,
        skip_discoverwfs boolean,
        tiling_protocol varchar(255),
        category int8,
        top_layer int8,
        primary key (id)
    );

    create table geo_service_details (
       geoservice int8 not null,
        value text,
        details_key varchar(255) not null,
        primary key (geoservice, details_key)
    );

    create table geo_service_keywords (
       geo_service int8 not null,
        keyword varchar(255)
    );

    create table geo_service_readers (
       geo_service int8 not null,
        role_name varchar(255)
    );

    create table group_ (
       name varchar(255) not null,
        description text,
        primary key (name)
    );

    create table layer (
       id  bigserial not null,
        filterable boolean not null,
        legend_image_url text,
        max_scale float8,
        min_scale float8,
        name varchar(255),
        queryable boolean not null,
        title varchar(255),
        title_alias varchar(255),
        userlayer boolean,
        virtual boolean not null,
        feature_type int8,
        parent int8,
        service int8,
        tileset varchar(255),
        primary key (id)
    );

    create table layer_bounding_boxes (
       layer int8 not null,
        name varchar(255),
        maxx float8,
        maxy float8,
        minx float8,
        miny float8,
        crs varchar(255) not null,
        primary key (layer, crs)
    );

    create table layer_children (
       layer int8 not null,
        child int8 not null,
        list_index int4 not null,
        primary key (layer, list_index)
    );

    create table layer_crs_list (
       layer int8 not null,
        crs varchar(255)
    );

    create table layer_details (
       layer int8 not null,
        value text,
        details_key varchar(255) not null,
        primary key (layer, details_key)
    );

    create table layer_keywords (
       layer int8 not null,
        keyword varchar(255)
    );

    create table layer_matrix_sets (
       layer int8 not null,
        matrix_set int8 not null,
        list_index int4 not null,
        primary key (layer, list_index)
    );

    create table layer_prevent_geom_editors (
       layer int8 not null,
        role_name varchar(255)
    );

    create table layer_readers (
       layer int8 not null,
        role_name varchar(255)
    );

    create table layer_writers (
       layer int8 not null,
        role_name varchar(255)
    );

    create table level_ (
       id  bigserial not null,
        background boolean not null,
        info text,
        name varchar(255) not null,
        url varchar(255),
        parent int8,
        primary key (id)
    );

    create table level_children (
       level_ int8 not null,
        child int8 not null,
        list_index int4 not null,
        primary key (level_, list_index)
    );

    create table level_documents (
       level_ int8 not null,
        document int8 not null,
        list_index int4 not null,
        primary key (level_, list_index)
    );

    create table level_layers (
       level_ int8 not null,
        layer int8 not null,
        list_index int4 not null,
        primary key (level_, list_index)
    );

    create table level_readers (
       level_ int8 not null,
        role_name varchar(255)
    );

    create table metadata (
       id  bigserial not null,
        config_key varchar(255),
        config_value varchar(255),
        primary key (id)
    );

    create table resource_ (
       name varchar(255) not null,
        content_type varchar(255),
        data_ oid not null,
        modified timestamp not null,
        size_ int8 not null,
        primary key (name)
    );

    create table solr_conf_index_attributes (
       solr_conf int8 not null,
        attribute_ varchar(255)
    );

    create table solr_conf_result_attributes (
       solr_conf int8 not null,
        attribute_ varchar(255)
    );

    create table solr_conf (
       id  bigserial not null,
        last_updated timestamp,
        name varchar(255),
        simple_feature_type int8,
        primary key (id)
    );

    create table start_layer (
       id  bigserial not null,
        checked boolean not null,
        removed boolean not null,
        selected_index int4,
        application int8,
        application_layer int8,
        primary key (id)
    );

    create table start_level (
       id  bigserial not null,
        removed boolean not null,
        selected_index int4,
        application int8,
        level_ int8,
        primary key (id)
    );

    create table style_library (
       id  bigserial not null,
        default_style boolean not null,
        external_url varchar(1000),
        extra_legend_parameters varchar(255),
        named_layer_user_styles_json text,
        sld_body text,
        title varchar(255) not null,
        primary key (id)
    );

    create table tile_matrix (
       id  bigserial not null,
        description varchar(255),
        identifier varchar(255),
        matrix_height int4 not null,
        matrix_width int4 not null,
        scale_denominator varchar(255),
        tile_height int4 not null,
        tile_width int4 not null,
        title varchar(255),
        top_left_corner varchar(255),
        matrix_set int8,
        primary key (id)
    );

    create table tile_matrix_set (
       id  bigserial not null,
        max_crs varchar(255),
        max_maxx float8,
        max_maxy float8,
        max_minx float8,
        max_miny float8,
        crs varchar(255),
        identifier varchar(255),
        tile_service int8,
        primary key (id)
    );

    create table tile_set (
       name varchar(255) not null,
        height int4 not null,
        width int4 not null,
        primary key (name)
    );

    create table tile_set_resolutions (
       tile_set varchar(255) not null,
        resolution float8,
        list_index int4 not null,
        primary key (tile_set, list_index)
    );

    create table user_ (
       username varchar(255) not null,
        password varchar(255),
        primary key (username)
    );

    create table user_details (
       username varchar(255) not null,
        details varchar(255),
        details_key varchar(255) not null,
        primary key (username, details_key)
    );

    create table user_groups (
       username varchar(255) not null,
        group_ varchar(255) not null,
        primary key (username, group_)
    );

    create table user_ips (
       user_ varchar(255) not null,
        ipaddress varchar(45)
    );

    alter table application 
       add constraint UKbek0xek0mdygawapgjoxv7yx3 unique (name, version);

    alter table bookmark 
       add constraint UKgmrgudavjnlg5rjfelqih1nha unique (code, application);

    alter table category 
       add constraint UKbn682bbbggixvs9lgin2316co unique (parent, name);

    alter table configured_component 
       add constraint UKacf25q50a96eptoqik6wqfn0k unique (name, application);

    alter table geo_service_style_libraries 
       add constraint UK_o8oij2ixybkkwyholrdxa0qig unique (style_library);

    alter table layer_children 
       add constraint UK_robohoibndy7875030jy23qf6 unique (child);

    alter table application 
       add constraint FKqmw3r70o5g022mbs3mn8lct3v 
       foreign key (owner) 
       references user_;

    alter table application 
       add constraint FKsc18kstdyav9xqx9mipx65lgq 
       foreign key (root) 
       references level_;

    alter table application_details 
       add constraint FK54rclw2aflrq61cw4ifvc3q5y 
       foreign key (application) 
       references application;

    alter table application_layer_attributes 
       add constraint FK2fwq0jlrepfhs9mpnmen93v9c 
       foreign key (attribute_) 
       references configured_attribute;

    alter table application_layer_attributes 
       add constraint FKcarpdhaohisgddm05v3ryuq4x 
       foreign key (application_layer) 
       references application_layer;

    alter table application_readers 
       add constraint FKc3pea8ha1x0dgvg7rqbo8d00u 
       foreign key (application) 
       references application;

    alter table application_layer 
       add constraint FKqejf84ms77adpgdtalv9mvn8g 
       foreign key (service) 
       references geo_service;

    alter table application_layer_details 
       add constraint FKd57xg4v98qfi8sl2dgkiwpuw7 
       foreign key (application_layer) 
       references application_layer;

    alter table application_layer_readers 
       add constraint FKg2am71kbvsk0xp5fjerhmnoo 
       foreign key (application_layer) 
       references application_layer;

    alter table application_layer_writers 
       add constraint FKea9oq7uvgsslbv1iv9fg2kc51 
       foreign key (application_layer) 
       references application_layer;

    alter table bookmark 
       add constraint FK1gmebhfavyypikxgi1e58mbx8 
       foreign key (application) 
       references application;

    alter table category 
       add constraint FKcmtwvovxcdalvlgifxh6luun8 
       foreign key (parent) 
       references category;

    alter table category_children 
       add constraint FKalf02yyo973qjxsrklbfo7bcp 
       foreign key (child) 
       references category;

    alter table category_children 
       add constraint FK2o3gajmxlcbvj6ody5tlv70v1 
       foreign key (category) 
       references category;

    alter table category_readers 
       add constraint FK2pex295ouwv5uwi9whb9h3wyv 
       foreign key (category) 
       references category;

    alter table category_services 
       add constraint FKa8idxmx3hqu6wplg1j3o1hspo 
       foreign key (service) 
       references geo_service;

    alter table category_services 
       add constraint FKkjwx4kcfk5sw9nrgy8xwqrkjc 
       foreign key (category) 
       references category;

    alter table category_writers 
       add constraint FKql7kwuqd9amifiyxejkuylc6i 
       foreign key (category) 
       references category;

    alter table configured_attribute 
       add constraint FKircv5vgxknc68ok6c9rjy8naf 
       foreign key (feature_type) 
       references feature_type;

    alter table configured_attribute 
       add constraint FKn0cmcojxd1h7ek3c2qbfy55je 
       foreign key (value_list_feature_source) 
       references feature_source;

    alter table configured_attribute 
       add constraint FKnk5vl417l01v2dqjgtbsgrc0l 
       foreign key (value_list_feature_type) 
       references feature_type;

    alter table configured_component 
       add constraint FKfqsuvvhu0lu04nss05g4go6d3 
       foreign key (application) 
       references application;

    alter table configured_component 
       add constraint FKc5msytqhho4am6yy25ilft761 
       foreign key (mother_component) 
       references configured_component;

    alter table configured_component_details 
       add constraint FKf92ta2vyw74jvgb7fls0d04uh 
       foreign key (configured_component) 
       references configured_component;

    alter table configured_component_readers 
       add constraint FKmivr74e2h4p7n7nyv3wj72t2a 
       foreign key (configured_component) 
       references configured_component;

    alter table feature_source_feature_types 
       add constraint FKialv7u190qacshwe0th4ss03j 
       foreign key (feature_type) 
       references feature_type;

    alter table feature_source_feature_types 
       add constraint FKn1cxq8bek5m0g4f8bgsvqtnvm 
       foreign key (feature_source) 
       references feature_source;

    alter table feature_type 
       add constraint FK4kmha9ln2r1aniq9ydyg8n3fn 
       foreign key (feature_source) 
       references feature_source;

    alter table feature_type_attributes 
       add constraint FKlns4t7i49wertw06r0wfb1f78 
       foreign key (attribute_descriptor) 
       references attribute_descriptor;

    alter table feature_type_attributes 
       add constraint FKs5ter1g5ugfp3akxfdaaoljcy 
       foreign key (feature_type) 
       references feature_type;

    alter table feature_source 
       add constraint FKg90hruoavk77lv4xq54cwtv3 
       foreign key (linked_service) 
       references geo_service;

    alter table feature_type_relation 
       add constraint FKgum528ld40nukoobh9drur676 
       foreign key (feature_type) 
       references feature_type;

    alter table feature_type_relation 
       add constraint FKchqrlr5bgy78dpv4iit04a518 
       foreign key (foreign_feature_type) 
       references feature_type;

    alter table feature_type_relation_key 
       add constraint FK9dcvypkvffwk12vqe4nhn65ua 
       foreign key (left_side) 
       references attribute_descriptor;

    alter table feature_type_relation_key 
       add constraint FK2kx1wa5gieo4byhbaw9tm0ubg 
       foreign key (relation) 
       references feature_type_relation;

    alter table feature_type_relation_key 
       add constraint FK8nxngbt1ko0og0j4g57bqywhx 
       foreign key (right_side) 
       references attribute_descriptor;

    alter table file_upload 
       add constraint FK4rpxtldducu9kwll3bjdh5mbh 
       foreign key (sft) 
       references feature_type;

    alter table form 
       add constraint FKqfxg1h4l70r4b8gfynpht0mns 
       foreign key (sft) 
       references feature_type;

    alter table form_readers 
       add constraint FKim2ct2f1q067cke41xls7kjpy 
       foreign key (form) 
       references form;

    alter table geo_service_style_libraries 
       add constraint FKiwsd2kyv2gihtuw28fqyp1ctm 
       foreign key (style_library) 
       references style_library;

    alter table geo_service_style_libraries 
       add constraint FKofutel83y99vh8t3dvrardkuv 
       foreign key (geo_service) 
       references geo_service;

    alter table geo_service 
       add constraint FKe6s9r3ykvjx6cdrd7yutf1met 
       foreign key (category) 
       references category;

    alter table geo_service 
       add constraint FKa00jwexwccpsw16xvc58cu49g 
       foreign key (top_layer) 
       references layer;

    alter table geo_service_details 
       add constraint FK4ymyhutqn4ki4ivi7kbpjst8d 
       foreign key (geoservice) 
       references geo_service;

    alter table geo_service_keywords 
       add constraint FKj6v2qoawiu8duksaog8jflnp7 
       foreign key (geo_service) 
       references geo_service;

    alter table geo_service_readers 
       add constraint FKhm6q8rtqc0c3q9mb7f1se7y89 
       foreign key (geo_service) 
       references geo_service;

    alter table layer 
       add constraint FK515kklogow84cv8dd4y62k2ty 
       foreign key (feature_type) 
       references feature_type;

    alter table layer 
       add constraint FK2rn8de6b0mjre1xiex1u3o0mo 
       foreign key (parent) 
       references layer;

    alter table layer 
       add constraint FK6jxl7im7d8bt8kb6kttqkr0ec 
       foreign key (service) 
       references geo_service;

    alter table layer 
       add constraint FK67ie2pjm6t380hfwn9oy8am9w 
       foreign key (tileset) 
       references tile_set;

    alter table layer_bounding_boxes 
       add constraint FK7oq6vyrbthy6kcr9jfyckiwvd 
       foreign key (layer) 
       references layer;

    alter table layer_children 
       add constraint FKptfqcou1g6emabu5glgr9y9x8 
       foreign key (child) 
       references layer;

    alter table layer_children 
       add constraint FKd3kqmfv2xnrv1kq1rwtyu96aa 
       foreign key (layer) 
       references layer;

    alter table layer_crs_list 
       add constraint FKp5603au9yyrorsn8i1ynck65a 
       foreign key (layer) 
       references layer;

    alter table layer_details 
       add constraint FKi1j48omeeqreypr31shqaq2lo 
       foreign key (layer) 
       references layer;

    alter table layer_keywords 
       add constraint FKp3rutkqk6kth3d9pxo6t3vdbg 
       foreign key (layer) 
       references layer;

    alter table layer_matrix_sets 
       add constraint FK9fvw6bjd8uvxsxeoold9r7xf4 
       foreign key (matrix_set) 
       references tile_matrix_set;

    alter table layer_matrix_sets 
       add constraint FKffgw1qhdk3tlkodywfogak3p3 
       foreign key (layer) 
       references layer;

    alter table layer_prevent_geom_editors 
       add constraint FK4llvt840pg6v1kyjwd4t004hm 
       foreign key (layer) 
       references layer;

    alter table layer_readers 
       add constraint FKnahh2p1hkb5sa894dyo3eeknl 
       foreign key (layer) 
       references layer;

    alter table layer_writers 
       add constraint FKklvsvu5b2nbqdsvxxs4rj1mfv 
       foreign key (layer) 
       references layer;

    alter table level_ 
       add constraint FKpx2ond5r2mvmdg7nwi0a881e9 
       foreign key (parent) 
       references level_;

    alter table level_children 
       add constraint FK96km3dk73idsnw4558ytv9cs6 
       foreign key (child) 
       references level_;

    alter table level_children 
       add constraint FK3oiw8wrcj7lk7qfo4u8f9yg1 
       foreign key (level_) 
       references level_;

    alter table level_documents 
       add constraint FKp9rt0mpvlhfe3pndqw7uj14ws 
       foreign key (document) 
       references document;

    alter table level_documents 
       add constraint FKeu1v5bbv02pck1bslgvcgfs7q 
       foreign key (level_) 
       references level_;

    alter table level_layers 
       add constraint FK3cpe6x6gsiv7tmu0umf48twiq 
       foreign key (layer) 
       references application_layer;

    alter table level_layers 
       add constraint FKsp6agh1dy7o4qrcixerol112n 
       foreign key (level_) 
       references level_;

    alter table level_readers 
       add constraint FKailn99uki5t68yf45dmivpred 
       foreign key (level_) 
       references level_;

    alter table solr_conf_index_attributes 
       add constraint FK7b8otap9samhk5nigkbalyd6d 
       foreign key (solr_conf) 
       references solr_conf;

    alter table solr_conf_result_attributes 
       add constraint FKpu2jki6h3f6gfxygbj94os52n 
       foreign key (solr_conf) 
       references solr_conf;

    alter table solr_conf 
       add constraint FKhm9vmb42abpssp06qonjf4fft 
       foreign key (simple_feature_type) 
       references feature_type;

    alter table start_layer 
       add constraint FK3lu7cqw0d3jmpwwe6ikv26klm 
       foreign key (application) 
       references application;

    alter table start_layer 
       add constraint FKohqjyc6juhos4p6g9314nskpe 
       foreign key (application_layer) 
       references application_layer;

    alter table start_level 
       add constraint FKfsa7bg0j48ewgydobm3qi6m52 
       foreign key (application) 
       references application;

    alter table start_level 
       add constraint FKfbpgykyxubh3duc0j5eradj60 
       foreign key (level_) 
       references level_;

    alter table tile_matrix 
       add constraint FK6nyyfk22u93e4k3940hdpit0k 
       foreign key (matrix_set) 
       references tile_matrix_set;

    alter table tile_matrix_set 
       add constraint FK64513gotf2fm35lj72niuecf8 
       foreign key (tile_service) 
       references geo_service;

    alter table tile_set_resolutions 
       add constraint FK2ge08mop7phjj6dv4jeacwwwj 
       foreign key (tile_set) 
       references tile_set;

    alter table user_details 
       add constraint FK7xq9wq3yvwe1vva9nscerw7h 
       foreign key (username) 
       references user_;

    alter table user_groups 
       add constraint FKrcu4lhv6f858ysh8leseqadgc 
       foreign key (group_) 
       references group_;

    alter table user_groups 
       add constraint FKckdwav53kdt57waq2vf2yc0dc 
       foreign key (username) 
       references user_;

    alter table user_ips 
       add constraint FKr63ny9h2oi28xu7k7nyfwjspt 
       foreign key (user_) 
       references user_;
