/*
 * Copyright (C) 2011-2013 B3Partners B.V.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
package nl.tailormap.viewer.config.services;

import javax.persistence.Column;
import javax.persistence.Embeddable;

/**
 *
 * @author Matthijs Laan
 */
@Embeddable
public class CoordinateReferenceSystem implements Cloneable {

    @Column(name="crs")
    private String name;

    public CoordinateReferenceSystem() {
    }

    public CoordinateReferenceSystem(String s) {
        name = s;
    }

    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public CoordinateReferenceSystem clone() throws CloneNotSupportedException { 
        return (CoordinateReferenceSystem)super.clone();
    }
    
    @Override
    public int hashCode() {
        return name.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (getClass() != obj.getClass()) {
            return false;
        }
        final CoordinateReferenceSystem other = (CoordinateReferenceSystem) obj;
        return (this.name == null) ? (other.name == null) : this.name.equals(other.name);
    }
}
