/*
 * Decompiled with CFR 0.152.
 */
package nl.tailormap.viewer.util;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.persistence.EntityManager;
import javax.persistence.Persistence;
import nl.tailormap.viewer.config.app.Application;
import nl.tailormap.viewer.config.app.ApplicationLayer;
import nl.tailormap.viewer.config.app.ConfiguredAttribute;
import nl.tailormap.viewer.config.app.ConfiguredComponent;
import nl.tailormap.viewer.config.app.Level;
import nl.tailormap.viewer.config.app.StartLayer;
import nl.tailormap.viewer.config.app.StartLevel;
import nl.tailormap.viewer.config.metadata.Metadata;
import nl.tailormap.viewer.config.services.FeatureSource;
import nl.tailormap.viewer.config.services.GeoService;
import nl.tailormap.viewer.config.services.Layer;
import nl.tailormap.viewer.config.services.SimpleFeatureType;
import nl.tailormap.viewer.config.services.WFSFeatureSource;
import nl.tailormap.viewer.config.services.WMSService;
import nl.tailormap.viewer.util.LoggingTestUtil;
import nl.tailormap.viewer.util.ScriptRunner;
import org.apache.commons.lang3.RandomStringUtils;
import org.hibernate.Session;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestInfo;

public abstract class TestUtil
extends LoggingTestUtil {
    public static String originalVersion = null;
    protected static int TEST_VERSION_NUMBER = 666;
    public final Long applicationId = 1L;
    public ApplicationLayer testAppLayer;
    public Level testLevel;
    public StartLayer testStartLayer;
    public StartLevel testStartLevel;
    public ConfiguredComponent testComponent;
    public Application app;
    protected EntityManager entityManager;
    protected final String layerName = "Test_omgeving:unittest";
    protected final String geometryAttribute = "geom";
    protected final String url = "https://flamingo5.b3p.nl/geoserver/Test_omgeving/ows";
    protected final List<ConfiguredAttribute> attributes = new ArrayList<ConfiguredAttribute>();

    @BeforeEach
    public void setUp(TestInfo testInfo) throws Exception {
        String persistenceUnit = System.getProperty("test.persistence.unit");
        HashMap<String, CallSite> config = new HashMap<String, CallSite>();
        String testname = testInfo.getDisplayName();
        testname = testname.replaceAll(":", "-").replaceAll("[)(\\s]", "");
        String randomizer = RandomStringUtils.randomAlphabetic((int)8);
        config.put("javax.persistence.jdbc.url", (CallSite)((Object)("jdbc:hsqldb:file:./target/unittest-hsqldb_" + testname + "_" + randomizer + "/db;shutdown=true")));
        this.entityManager = Persistence.createEntityManagerFactory((String)persistenceUnit, config).createEntityManager();
        if (!this.entityManager.getTransaction().isActive()) {
            this.entityManager.getTransaction().begin();
        }
        this.loadTestData();
        if (!this.entityManager.getTransaction().isActive()) {
            this.entityManager.getTransaction().begin();
        }
    }

    @AfterEach
    public void closeTransaction() {
        if (this.entityManager.getTransaction().isActive()) {
            this.entityManager.getTransaction().commit();
        }
        if (this.entityManager.isOpen()) {
            this.entityManager.close();
        }
    }

    public <T> void persistEntityTest(T entity, Class<T> clazz) {
        this.entityManager.persist(entity);
        this.entityManager.getTransaction().commit();
        this.entityManager.getTransaction().begin();
    }

    public void loadTestData() throws IOException {
        Application app = (Application)this.entityManager.find(Application.class, (Object)this.applicationId);
        if (app == null) {
            try (InputStreamReader f = new InputStreamReader(Objects.requireNonNull(TestUtil.class.getResourceAsStream("testdata.sql")));){
                this.executeScript(f);
            }
        }
        Metadata version = (Metadata)this.entityManager.createQuery("From Metadata where configKey = :v", Metadata.class).setParameter("v", (Object)"database_version").getSingleResult();
        originalVersion = version.getConfigValue();
    }

    public void executeScript(Reader f) {
        Session session = (Session)this.entityManager.getDelegate();
        try {
            session.doWork(con -> {
                ScriptRunner sr = new ScriptRunner(con, true, true);
                sr.runScript(f, false);
                con.commit();
            });
        }
        finally {
            this.entityManager.flush();
            if (this.entityManager.getTransaction().isActive()) {
                this.entityManager.getTransaction().commit();
                this.entityManager.getTransaction().begin();
            }
        }
    }

    public void initData(boolean addToStartmap) {
        this.app = new Application();
        this.app.setName("testapp");
        this.app.setVersion("154");
        this.app.getReaders().add("pietje");
        this.app.getReaders().add("puk");
        this.persistEntityTest(this.app, Application.class);
        Level root = new Level();
        root.setName("root");
        this.app.setRoot(root);
        this.entityManager.persist((Object)this.app);
        this.persistEntityTest(root, Level.class);
        this.testLevel = new Level();
        this.testLevel.setName("testLevel");
        this.testLevel.setParent(root);
        root.getChildren().add(this.testLevel);
        this.persistEntityTest(this.testLevel, Level.class);
        this.testStartLevel = new StartLevel();
        this.testStartLevel.setApplication(this.app);
        this.testStartLevel.setLevel(this.testLevel);
        this.testLevel.getStartLevels().put(this.app, this.testStartLevel);
        this.app.getStartLevels().add(this.testStartLevel);
        this.persistEntityTest(this.testStartLevel, StartLevel.class);
        if (addToStartmap) {
            WFSFeatureSource fs = new WFSFeatureSource();
            fs.setName("pietje");
            fs.setUrl("https://flamingo5.b3p.nl/geoserver/Test_omgeving/ows");
            this.persistEntityTest(fs, FeatureSource.class);
            SimpleFeatureType sft = new SimpleFeatureType();
            sft.setTypeName("Test_omgeving:unittest");
            sft.setGeometryAttribute("geom");
            sft.setFeatureSource((FeatureSource)fs);
            this.persistEntityTest(sft, SimpleFeatureType.class);
            fs.getFeatureTypes().add(sft);
            this.persistEntityTest(fs, FeatureSource.class);
            Layer rlayer = new Layer();
            rlayer.setName("root");
            this.persistEntityTest(rlayer, Layer.class);
            Layer l = new Layer();
            l.setName("Test_omgeving:unittest");
            l.setFeatureType(sft);
            l.setParent(rlayer);
            this.persistEntityTest(l, Layer.class);
            rlayer.getChildren().add(l);
            this.persistEntityTest(rlayer, Layer.class);
            WMSService gs = new WMSService();
            gs.setName("gsname");
            gs.setUrl("https://flamingo5.b3p.nl/geoserver/Test_omgeving/ows");
            gs.setTopLayer(rlayer);
            this.persistEntityTest(gs, GeoService.class);
            rlayer.setService((GeoService)gs);
            l.setService((GeoService)gs);
            this.testAppLayer = new ApplicationLayer();
            this.testAppLayer.setLayerName("Test_omgeving:unittest");
            this.testAppLayer.setService((GeoService)gs);
            this.testAppLayer.setAttributes(this.attributes);
            this.testLevel.getLayers().add(this.testAppLayer);
            this.testStartLayer = new StartLayer();
            this.testStartLayer.setApplicationLayer(this.testAppLayer);
            this.testStartLayer.setApplication(this.app);
            this.testStartLayer.setSelectedIndex(Integer.valueOf(16));
            this.app.getStartLayers().add(this.testStartLayer);
            this.testAppLayer.getStartLayers().put(this.app, this.testStartLayer);
            this.persistEntityTest(this.testAppLayer, ApplicationLayer.class);
            this.testStartLevel.setSelectedIndex(Integer.valueOf(9));
            this.entityManager.persist((Object)this.testStartLevel);
            this.entityManager.persist((Object)this.testAppLayer);
            this.entityManager.persist((Object)this.app);
            this.persistEntityTest(this.testStartLayer, StartLayer.class);
        }
        this.testComponent = new ConfiguredComponent();
        this.testComponent.setApplication(this.app);
        this.testComponent.setClassName("viewer.components.Bookmark");
        this.testComponent.setConfig("{value: 'aapnootmies'}");
        this.testComponent.setName("testClassName1");
        this.app.getComponents().add(this.testComponent);
        this.persistEntityTest(this.testComponent, ConfiguredComponent.class);
        this.entityManager.getTransaction().commit();
        this.entityManager.getTransaction().begin();
    }
}

