/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.topnl;

import com.vividsolutions.jts.io.ParseException;
import java.io.IOException;
import java.net.URL;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.TransformerException;
import nl.b3p.topnl.Database;
import nl.b3p.topnl.TopNLType;
import nl.b3p.topnl.TopNLTypeFactory;
import nl.b3p.topnl.converters.Converter;
import nl.b3p.topnl.converters.ConverterFactory;
import nl.b3p.topnl.entities.TopNLEntity;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jdom2.JDOMException;
import org.xml.sax.SAXException;

public class Processor {
    protected static final Log log = LogFactory.getLog(Processor.class);
    private Database database;
    private ConverterFactory converterFactory;

    public Processor(DataSource ds) throws JAXBException, SQLException {
        this.database = new Database(ds);
        this.converterFactory = new ConverterFactory();
    }

    public void importIntoDb(URL in, TopNLType type) throws JDOMException {
        XMLInputFactory xif = XMLInputFactory.newFactory();
        try {
            log.info((Object)("Importing file " + in.toExternalForm() + ", type: " + type.getType()));
            Unmarshaller jaxbUnmarshaller = this.converterFactory.getContext(type).createUnmarshaller();
            XMLStreamReader xsr = xif.createXMLStreamReader(in.openStream());
            while (xsr.hasNext()) {
                int eventType = xsr.next();
                if (eventType != 1) continue;
                String localname = xsr.getLocalName();
                if (!xsr.getLocalName().equals("FeatureMember")) continue;
                try {
                    JAXBElement jb = (JAXBElement)jaxbUnmarshaller.unmarshal(xsr);
                    Object obj = jb.getValue();
                    ArrayList<Object> list = new ArrayList<Object>();
                    list.add(obj);
                    List<TopNLEntity> entities = this.convert(list, type);
                    this.save(entities, type);
                }
                catch (ParseException | IOException | JAXBException | ParserConfigurationException | TransformerException | SAXException ex) {
                    log.error((Object)"Error parsing", ex);
                }
            }
            xsr.close();
        }
        catch (IOException | JAXBException | XMLStreamException ex) {
            log.error((Object)"cannot correctly stream xml file:", ex);
        }
    }

    public List parse(URL in) throws JAXBException, IOException {
        ArrayList<Object> list = new ArrayList<Object>();
        try {
            TopNLType type = TopNLTypeFactory.getTopNLType(in);
            Unmarshaller jaxbUnmarshaller = this.converterFactory.getContext(type).createUnmarshaller();
            XMLInputFactory xif = XMLInputFactory.newFactory();
            XMLStreamReader xsr = xif.createXMLStreamReader(in.openStream());
            while (xsr.hasNext()) {
                int eventType = xsr.next();
                if (eventType != 1) continue;
                String localname = xsr.getLocalName();
                if (!xsr.getLocalName().equals("FeatureMember")) continue;
                JAXBElement jb = (JAXBElement)jaxbUnmarshaller.unmarshal(xsr);
                list.add(jb.getValue());
            }
            xsr.close();
        }
        catch (XMLStreamException ex) {
            log.error((Object)"cannot correctly stream xml file:", (Throwable)ex);
        }
        catch (JDOMException ex) {
            log.error((Object)"Cannot retrieve topnltype: ", (Throwable)ex);
        }
        return list;
    }

    public List<TopNLEntity> convert(List listOfJaxbObjects, TopNLType type) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        Converter converter = this.converterFactory.getConverter(type);
        List<TopNLEntity> entity = converter.convert(listOfJaxbObjects);
        return entity;
    }

    public void save(TopNLEntity entity, TopNLType type) throws ParseException {
        this.database.save(entity);
    }

    public void save(List<TopNLEntity> entities, TopNLType type) throws ParseException {
        for (TopNLEntity entity : entities) {
            this.save(entity, type);
        }
    }
}

