/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.topnl.converters;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import nl.b3p.topnl.TopNLType;
import nl.b3p.topnl.converters.Converter;
import nl.b3p.topnl.converters.Top100NLConverter;
import nl.b3p.topnl.converters.Top10NLConverter;
import nl.b3p.topnl.converters.Top250NLConverter;
import nl.b3p.topnl.converters.Top50NLConverter;

public class ConverterFactory {
    private final Converter top250nlConverter = new Top250NLConverter();
    private final Converter top100nlConverter = new Top100NLConverter();
    private final Converter top50nlConverter = new Top50NLConverter();
    private final Converter top10nlConverter = new Top10NLConverter();
    private JAXBContext context250nl = JAXBContext.newInstance((String)"nl.b3p.topnl.top250nl");
    private JAXBContext context100nl = JAXBContext.newInstance((String)"nl.b3p.topnl.top100nl");
    private JAXBContext context50nl = JAXBContext.newInstance((String)"nl.b3p.topnl.top50nl");
    private JAXBContext context10nl = JAXBContext.newInstance((String)"nl.b3p.topnl.top10nl");

    public Converter getConverter(TopNLType type) {
        switch (type) {
            case TOP250NL: {
                return this.top250nlConverter;
            }
            case TOP100NL: {
                return this.top100nlConverter;
            }
            case TOP50NL: {
                return this.top50nlConverter;
            }
            case TOP10NL: {
                return this.top10nlConverter;
            }
        }
        throw new IllegalArgumentException("Converter not yet implemented: " + type.getType());
    }

    public JAXBContext getContext(TopNLType type) {
        switch (type) {
            case TOP10NL: {
                return this.context10nl;
            }
            case TOP50NL: {
                return this.context50nl;
            }
            case TOP100NL: {
                return this.context100nl;
            }
            case TOP250NL: {
                return this.context250nl;
            }
        }
        throw new IllegalArgumentException("TopNL type " + type.getType() + " not (yet) supported.");
    }
}

