/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.topnl;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.ParseException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import javax.sql.DataSource;
import nl.b3p.brmo.loader.jdbc.GeometryJdbcConverter;
import nl.b3p.brmo.loader.jdbc.GeometryJdbcConverterFactory;
import nl.b3p.topnl.converters.DbUtilsGeometryColumnConverter;
import nl.b3p.topnl.entities.FunctioneelGebied;
import nl.b3p.topnl.entities.Gebouw;
import nl.b3p.topnl.entities.GeografischGebied;
import nl.b3p.topnl.entities.Hoogte;
import nl.b3p.topnl.entities.Inrichtingselement;
import nl.b3p.topnl.entities.Plaats;
import nl.b3p.topnl.entities.PlanTopografie;
import nl.b3p.topnl.entities.RegistratiefGebied;
import nl.b3p.topnl.entities.Relief;
import nl.b3p.topnl.entities.Spoorbaandeel;
import nl.b3p.topnl.entities.Terrein;
import nl.b3p.topnl.entities.TopNLEntity;
import nl.b3p.topnl.entities.Waterdeel;
import nl.b3p.topnl.entities.Wegdeel;
import org.apache.commons.dbutils.BasicRowProcessor;
import org.apache.commons.dbutils.BeanProcessor;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.RowProcessor;
import org.apache.commons.dbutils.handlers.BeanHandler;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class Database {
    protected static final Log log = LogFactory.getLog(Database.class);
    private final DataSource dataSource;
    private GeometryJdbcConverter gjc;
    private QueryRunner run;

    public Database(DataSource ds) throws SQLException {
        this.dataSource = ds;
        if (ds != null) {
            this.gjc = GeometryJdbcConverterFactory.getGeometryJdbcConverter((Connection)this.dataSource.getConnection());
            this.run = new QueryRunner(this.dataSource, this.gjc.isPmdKnownBroken());
        }
    }

    public void save(TopNLEntity entity) throws ParseException {
        block15: {
            try {
                if (entity instanceof Hoogte) {
                    this.saveHoogte(entity);
                    break block15;
                }
                if (entity instanceof FunctioneelGebied) {
                    this.saveFunctioneelGebied(entity);
                    break block15;
                }
                if (entity instanceof Gebouw) {
                    this.saveGebouw(entity);
                    break block15;
                }
                if (entity instanceof GeografischGebied) {
                    this.saveGeografischGebied(entity);
                    break block15;
                }
                if (entity instanceof Inrichtingselement) {
                    this.saveInrichtingselement(entity);
                    break block15;
                }
                if (entity instanceof Plaats) {
                    this.savePlaats(entity);
                    break block15;
                }
                if (entity instanceof RegistratiefGebied) {
                    this.saveRegistratiefGebied(entity);
                    break block15;
                }
                if (entity instanceof Relief) {
                    this.saveRelief(entity);
                    break block15;
                }
                if (entity instanceof Spoorbaandeel) {
                    this.saveSpoorbaandeel(entity);
                    break block15;
                }
                if (entity instanceof Terrein) {
                    this.saveTerrein(entity);
                    break block15;
                }
                if (entity instanceof Waterdeel) {
                    this.saveWaterdeel(entity);
                    break block15;
                }
                if (entity instanceof Wegdeel) {
                    this.saveWegdeel(entity);
                    break block15;
                }
                if (entity instanceof PlanTopografie) {
                    this.savePlanTopografie(entity);
                    break block15;
                }
                throw new IllegalArgumentException("Type of entity not (yet) implemented.");
            }
            catch (SQLException e) {
                log.error((Object)"Error inserting entity: ", (Throwable)e);
            }
        }
    }

    private Gebouw saveGebouw(TopNLEntity entity) throws SQLException, ParseException {
        Gebouw h = (Gebouw)entity;
        BeanHandler handler = new BeanHandler(Gebouw.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(this.gjc)));
        Object nativeGeom = this.gjc.convertToNativeGeometryObject(h.getGeometrie());
        Object[] args = this.getVarargs(entity, h.getTypeGebouw(), h.getStatus(), h.getFysiekVoorkomen(), h.getHoogteklasse(), h.getHoogte(), h.getSoortnaam(), h.getNaam(), h.getNaamFries(), nativeGeom);
        Gebouw inserted = (Gebouw)this.run.insert("INSERT INTO " + h.getTopnltype() + ".gebouw (" + this.getTopNLEntityColumns() + ",typegebouw,status,fysiekvoorkomen,hoogteklasse,hoogte,soortnaam,naam,naamfries,geometrie) VALUES (" + this.getTopNLEntityReplacementChars() + ",?,?,?,?,?,?,?,?,?)", (ResultSetHandler)handler, args);
        return inserted;
    }

    private PlanTopografie savePlanTopografie(TopNLEntity entity) throws SQLException, ParseException {
        PlanTopografie h = (PlanTopografie)entity;
        BeanHandler handler = new BeanHandler(PlanTopografie.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(this.gjc)));
        Object nativeGeom = this.gjc.convertToNativeGeometryObject(h.getGeometrie());
        Object[] args = this.getVarargs(entity, h.getTypePlanTopografie(), h.getNaam(), nativeGeom);
        PlanTopografie inserted = (PlanTopografie)this.run.insert("INSERT INTO " + h.getTopnltype() + ".PlanTopoGrafie (" + this.getTopNLEntityColumns() + ",typePlanTopografie,naam,geometrie) VALUES (" + this.getTopNLEntityReplacementChars() + ",?,?,?)", (ResultSetHandler)handler, args);
        return inserted;
    }

    private GeografischGebied saveGeografischGebied(TopNLEntity entity) throws SQLException, ParseException {
        GeografischGebied h = (GeografischGebied)entity;
        BeanHandler handler = new BeanHandler(GeografischGebied.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(this.gjc)));
        Object nativeGeom = this.gjc.convertToNativeGeometryObject(h.getGeometrie());
        Object[] args = this.getVarargs(entity, h.getTypeGeografischGebied(), h.getNaamNL(), h.getNaamFries(), nativeGeom);
        GeografischGebied inserted = (GeografischGebied)this.run.insert("INSERT INTO " + h.getTopnltype() + ".geografischgebied (" + this.getTopNLEntityColumns() + ",typeGeografischGebied,naamNL,naamFries,geometrie) VALUES (" + this.getTopNLEntityReplacementChars() + ",?,?,?,?)", (ResultSetHandler)handler, args);
        return inserted;
    }

    private Inrichtingselement saveInrichtingselement(TopNLEntity entity) throws SQLException, ParseException {
        Inrichtingselement h = (Inrichtingselement)entity;
        BeanHandler handler = new BeanHandler(Inrichtingselement.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(this.gjc)));
        Object nativeGeom = this.gjc.convertToNativeGeometryObject(h.getGeometrie());
        Object[] args = this.getVarargs(entity, h.getTypeInrichtingselement(), h.getSoortnaam(), h.getStatus(), h.getHoogteniveau(), nativeGeom);
        Inrichtingselement inserted = (Inrichtingselement)this.run.insert("INSERT INTO " + h.getTopnltype() + ".inrichtingselement (" + this.getTopNLEntityColumns() + ",typeInrichtingselement,soortnaam,status,hoogteniveau,geometrie) VALUES (" + this.getTopNLEntityReplacementChars() + ",?,?,?,?,?)", (ResultSetHandler)handler, args);
        return inserted;
    }

    private Plaats savePlaats(TopNLEntity entity) throws SQLException, ParseException {
        Plaats h = (Plaats)entity;
        BeanHandler handler = new BeanHandler(Plaats.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(this.gjc)));
        Object nativeGeom = this.gjc.convertToNativeGeometryObject(h.getGeometrie());
        Object[] args = this.getVarargs(entity, h.getTypeGebied(), h.getAantalInwoners(), h.getNaamOfficieel(), h.getNaamNL(), h.getNaamFries(), nativeGeom);
        Plaats inserted = (Plaats)this.run.insert("INSERT INTO " + h.getTopnltype() + ".plaats (" + this.getTopNLEntityColumns() + ",typeGebied,aantalInwoners,naamOfficieel,naamNL,naamFries,geometrie) VALUES (" + this.getTopNLEntityReplacementChars() + ",?,?,?,?,?,?)", (ResultSetHandler)handler, args);
        return inserted;
    }

    private RegistratiefGebied saveRegistratiefGebied(TopNLEntity entity) throws SQLException, ParseException {
        RegistratiefGebied h = (RegistratiefGebied)entity;
        BeanHandler handler = new BeanHandler(RegistratiefGebied.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(this.gjc)));
        Object nativeGeom = this.gjc.convertToNativeGeometryObject(h.getGeometrie());
        Object[] args = this.getVarargs(entity, h.getTypeRegistratiefGebied(), h.getNaamOfficieel(), h.getNaamNL(), h.getNaamFries(), h.getNummer(), nativeGeom);
        RegistratiefGebied inserted = (RegistratiefGebied)this.run.insert("INSERT INTO " + h.getTopnltype() + ".registratiefgebied (" + this.getTopNLEntityColumns() + ",typeRegistratiefGebied,naamOfficieel,naamNL,naamFries,nummer,geometrie) VALUES (" + this.getTopNLEntityReplacementChars() + ",?,?,?,?,?,?)", (ResultSetHandler)handler, args);
        return inserted;
    }

    private Relief saveRelief(TopNLEntity entity) throws SQLException, ParseException {
        Relief h = (Relief)entity;
        BeanHandler handler = new BeanHandler(Relief.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(this.gjc)));
        Object nativeGeom = this.gjc.convertToNativeGeometryObject((Geometry)h.getGeometrie());
        Object nativeLageZijde = this.gjc.convertToNativeGeometryObject((Geometry)h.getTaludLageZijde());
        Object nativeHogeZijde = this.gjc.convertToNativeGeometryObject((Geometry)h.getTaludHogeZijde());
        Object[] args = this.getVarargs(entity, h.getTypeRelief(), h.getHoogteklasse(), h.getHoogteniveau(), nativeGeom, nativeLageZijde, nativeHogeZijde);
        Relief inserted = (Relief)this.run.insert("INSERT INTO " + h.getTopnltype() + ".relief (" + this.getTopNLEntityColumns() + ",typeRelief,hoogteklasse,hoogteniveau,geometrie,taludLageZijde,taludHogeZijde) VALUES (" + this.getTopNLEntityReplacementChars() + ",?,?,?,?,?,?)", (ResultSetHandler)handler, args);
        return inserted;
    }

    private Spoorbaandeel saveSpoorbaandeel(TopNLEntity entity) throws SQLException, ParseException {
        Spoorbaandeel h = (Spoorbaandeel)entity;
        BeanHandler handler = new BeanHandler(Spoorbaandeel.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(this.gjc)));
        Object nativeGeom = this.gjc.convertToNativeGeometryObject((Geometry)h.getGeometrie());
        Object[] args = this.getVarargs(entity, h.getTypeInfrastructuur(), h.getTypeSpoorbaan(), h.getFysiekVoorkomen(), h.getSpoorbreedte(), h.getAantalSporen(), h.getVervoerfunctie(), h.getElektrificatie(), h.getStatus(), h.getBrugnaam(), h.getTunnelnaam(), h.getBaanvaknaam(), h.getHoogteniveau(), nativeGeom);
        Spoorbaandeel inserted = (Spoorbaandeel)this.run.insert("INSERT INTO " + h.getTopnltype() + ".spoorbaandeel (" + this.getTopNLEntityColumns() + ",typeInfrastructuur,typeSpoorbaan,fysiekVoorkomen,spoorbreedte,aantalSporen,vervoerfunctie,elektrificatie,status,brugnaam,tunnelnaam,baanvaknaam,hoogteniveau,geometrie) VALUES (" + this.getTopNLEntityReplacementChars() + ",?,?,?,?,?,?,?,?,?,?,?,?,?)", (ResultSetHandler)handler, args);
        return inserted;
    }

    private Terrein saveTerrein(TopNLEntity entity) throws SQLException, ParseException {
        Terrein h = (Terrein)entity;
        BeanHandler handler = new BeanHandler(Terrein.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(this.gjc)));
        Object nativeGeom = this.gjc.convertToNativeGeometryObject((Geometry)h.getGeometrie());
        Object[] args = this.getVarargs(entity, h.getTypeLandgebruik(), h.getNaam(), nativeGeom);
        Terrein inserted = (Terrein)this.run.insert("INSERT INTO " + h.getTopnltype() + ".terrein (" + this.getTopNLEntityColumns() + ",typelandgebruik,naam,geometrie) VALUES (" + this.getTopNLEntityReplacementChars() + ",?,?,?)", (ResultSetHandler)handler, args);
        return inserted;
    }

    private Waterdeel saveWaterdeel(TopNLEntity entity) throws SQLException, ParseException {
        Waterdeel h = (Waterdeel)entity;
        BeanHandler handler = new BeanHandler(Waterdeel.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(this.gjc)));
        Object nativeGeom = this.gjc.convertToNativeGeometryObject(h.getGeometrie());
        Object[] args = this.getVarargs(entity, h.getTypeWater(), h.getBreedteklasse(), h.getFysiekVoorkomen(), h.getVoorkomen(), h.getGetijdeinvloed(), h.getVaarwegklasse(), h.getNaamOfficieel(), h.getNaamNL(), h.getNaamFries(), h.getIsBAGnaam(), h.getSluisnaam(), h.getBrugnaam(), h.getHoogteniveau(), h.getFunctie(), h.isHoofdAfwatering(), nativeGeom);
        Waterdeel inserted = (Waterdeel)this.run.insert("INSERT INTO " + h.getTopnltype() + ".waterdeel (" + this.getTopNLEntityColumns() + ",typewater,breedteklasse,fysiekvoorkomen,voorkomen,getijdeinvloed,vaarwegklasse,naamofficieel,naamnl,naamfries,isbagnaam,sluisnaam,brugnaam,hoogteniveau,functie,hoofdAfwatering,geometrie) VALUES (" + this.getTopNLEntityReplacementChars() + ",?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)", (ResultSetHandler)handler, args);
        return inserted;
    }

    private Wegdeel saveWegdeel(TopNLEntity entity) throws SQLException, ParseException {
        Wegdeel h = (Wegdeel)entity;
        BeanHandler handler = new BeanHandler(Wegdeel.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(this.gjc)));
        Object nativeGeom = this.gjc.convertToNativeGeometryObject(h.getGeometrie());
        Object nativeHartGeom = this.gjc.convertToNativeGeometryObject(h.getHartGeometrie());
        Object[] args = this.getVarargs(entity, h.getTypeInfrastructuur(), h.getTypeWeg(), h.getHoofdverkeersgebruik(), h.getFysiekVoorkomen(), h.getVerhardingsbreedteklasse(), h.getGescheidenRijbaan(), h.getVerhardingstype(), h.getAantalRijstroken(), h.getHoogteniveau(), h.getStatus(), h.getNaam(), h.getIsBAGnaam(), h.getaWegnummer(), h.getnWegnummer(), h.geteWegnummer(), h.getsWegnummer(), h.getAfritnummer(), h.getAfritnaam(), h.getKnooppuntnaam(), h.getBrugnaam(), h.getTunnelnaam(), nativeHartGeom, nativeGeom);
        String query = "INSERT INTO " + h.getTopnltype() + ".wegdeel (" + this.getTopNLEntityColumns() + ",typeInfrastructuur,typeWeg,hoofdverkeersgebruik,fysiekVoorkomen,verhardingsbreedteklasse,gescheidenRijbaan,verhardingstype,aantalRijstroken,hoogteniveau,status,naam,isBAGnaam,aWegnummer,nWegnummer,eWegnummer,sWegnummer,afritnummer,afritnaam,knooppuntnaam,brugnaam,tunnelnaam,hartGeometrie,geometrie) VALUES (" + this.getTopNLEntityReplacementChars() + ",?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";
        Wegdeel inserted = (Wegdeel)this.run.insert(query, (ResultSetHandler)handler, args);
        return inserted;
    }

    private FunctioneelGebied saveFunctioneelGebied(TopNLEntity entity) throws SQLException, ParseException {
        FunctioneelGebied h = (FunctioneelGebied)entity;
        BeanHandler handler = new BeanHandler(FunctioneelGebied.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(this.gjc)));
        Object nativeGeom = this.gjc.convertToNativeGeometryObject(h.getGeometrie());
        Object[] args = this.getVarargs(entity, h.getTypeFunctioneelGebied(), h.getSoortnaam(), h.getNaamNL(), h.getNaamFries(), nativeGeom);
        FunctioneelGebied inserted = (FunctioneelGebied)this.run.insert("INSERT INTO " + h.getTopnltype() + ".functioneelgebied (" + this.getTopNLEntityColumns() + ",typefunctioneelgebied,soortnaam,naamnl,naamfries,geometrie) VALUES (" + this.getTopNLEntityReplacementChars() + ",?,?,?,?,?)", (ResultSetHandler)handler, args);
        return inserted;
    }

    private Hoogte saveHoogte(TopNLEntity entity) throws SQLException, ParseException {
        Hoogte h = (Hoogte)entity;
        BeanHandler handler = new BeanHandler(Hoogte.class, (RowProcessor)new BasicRowProcessor((BeanProcessor)new DbUtilsGeometryColumnConverter(this.gjc)));
        Object nativeGeom = this.gjc.convertToNativeGeometryObject(h.getGeometrie());
        Object[] args = this.getVarargs(entity, h.getTypeHoogte(), h.getReferentieVlak(), h.getHoogte(), nativeGeom);
        Hoogte inserted = (Hoogte)this.run.insert("INSERT INTO " + h.getTopnltype() + ".hoogte (" + this.getTopNLEntityColumns() + ",typeHoogte,referentieVlak,hoogte, geometrie) VALUES (" + this.getTopNLEntityReplacementChars() + ",?,?,?,?)", (ResultSetHandler)handler, args);
        return inserted;
    }

    private String getTopNLEntityColumns() {
        return "identificatie,topnltype,brontype,bronactualiteit,bronbeschrijving,bronnauwkeurigheid,objectBeginTijd,objectEindTijd,visualisatieCode";
    }

    private String getTopNLEntityReplacementChars() {
        return "?,?,?,?,?,?,?,?,?";
    }

    private Object[] getVarargs(TopNLEntity entity, Object ... specificArgs) {
        Object[] genericArgs = new Object[]{entity.getIdentificatie(), entity.getTopnltype(), entity.getBrontype(), entity.getBronactualiteit() != null ? new Date(entity.getBronactualiteit().getTime()) : null, entity.getBronbeschrijving(), entity.getBronnauwkeurigheid(), entity.getObjectBeginTijd() != null ? new Date(entity.getObjectBeginTijd().getTime()) : null, entity.getObjectEindTijd() != null ? new Date(entity.getObjectEindTijd().getTime()) : null, entity.getVisualisatieCode()};
        int numGeneric = genericArgs.length;
        Object[] completeArgs = new Object[numGeneric + specificArgs.length];
        System.arraycopy(genericArgs, 0, completeArgs, 0, numGeneric);
        for (int i = 0; i < specificArgs.length; ++i) {
            Object specificArg;
            completeArgs[numGeneric + i] = specificArg = specificArgs[i];
        }
        return completeArgs;
    }

    public GeometryJdbcConverter getGjc() {
        return this.gjc;
    }
}

