/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.topnl.converters;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.PrecisionModel;
import com.vividsolutions.jts.simplify.DouglasPeuckerSimplifier;
import java.io.IOException;
import java.io.InvalidClassException;
import java.io.Reader;
import java.io.StringReader;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.gml3.ArcParameters;
import org.geotools.gml3.CircleRadiusTolerance;
import org.geotools.gml3.GMLConfiguration;
import org.geotools.gml3.LinearizationTolerance;
import org.geotools.xml.Configuration;
import org.geotools.xml.Parser;
import org.jdom.Element;
import org.jdom.input.DOMBuilder;
import org.jdom.output.XMLOutputter;
import org.xml.sax.SAXException;

public class GeometryConverter {
    protected static final Log log = LogFactory.getLog(GeometryConverter.class);
    private static final double DISTANCE_TOLERANCE = 0.001;
    protected static final double LINEARIZATION_TOLERANCE_MULTIPLIER = 0.01;
    private Parser parser;
    private GeometryFactory geometryFactory;
    protected static final int SRID = 28992;

    public GeometryConverter() {
        GeometryFactory gf = new GeometryFactory(new PrecisionModel(), 28992);
        ArcParameters arcParameters = new ArcParameters((LinearizationTolerance)new CircleRadiusTolerance(0.01));
        GMLConfiguration gml3Config = new GMLConfiguration();
        gml3Config.setExtendedArcSurfaceSupport(true);
        gml3Config.getContext().registerComponentInstance((Object)gf);
        gml3Config.getContext().registerComponentInstance((Object)arcParameters);
        this.parser = new Parser((Configuration)gml3Config);
        this.geometryFactory = gf;
    }

    public Geometry convertGeometry(org.w3c.dom.Element el) throws IOException, SAXException, ParserConfigurationException, TransformerException {
        if (!(el instanceof org.w3c.dom.Element)) {
            throw new IllegalArgumentException("gml org.w3c.node is not an org.w3c.Element");
        }
        Element elem = new DOMBuilder().build(el);
        String gmlString = new XMLOutputter().outputString(elem);
        Object parsedObject = this.parser.parse((Reader)new StringReader(gmlString = gmlString.replaceAll("gml:", "")));
        if (parsedObject instanceof Geometry) {
            Geometry geom = (Geometry)parsedObject;
            if (!geom.isValid()) {
                geom = geom.buffer(0.0);
                log.debug((Object)"Geometry is invalid. Made valid by buffering with 0");
            }
            Geometry simplGeom = DouglasPeuckerSimplifier.simplify((Geometry)geom, (double)0.001);
            return simplGeom;
        }
        throw new InvalidClassException(parsedObject.getClass().getCanonicalName(), "Parsed object not of class Geometry.");
    }
}

