/*
 * Decompiled with CFR 0.152.
 */
package nl.opengeogroep;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.ErrorResolution;
import net.sourceforge.stripes.action.Resolution;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.mutable.MutableObject;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpResponse;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.methods.RequestBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;

public class SafetyConnectProxy {
    private static final Log log = LogFactory.getLog(SafetyConnectProxy.class);

    public static Resolution proxy(final ActionBeanContext context, String authorization, String url, String path) throws Exception {
        Resolution resolution;
        block9: {
            if (authorization == null || url == null) {
                return new ErrorResolution(500, "Geen toegangsgegevens voor webservice geconfigureerd door beheerder");
            }
            String qs = context.getRequest().getQueryString();
            final HttpUriRequest req = RequestBuilder.get().setUri(url + "/" + path + (qs == null ? "" : "?" + qs)).addHeader("Authorization", authorization).build();
            CloseableHttpClient client = HttpClients.createDefault();
            try {
                final MutableObject contentType = new MutableObject((Object)"text/plain");
                final String content = (String)client.execute(req, (ResponseHandler)new ResponseHandler<String>(){

                    public String handleResponse(HttpResponse hr) {
                        log.debug((Object)("proxy for user " + context.getRequest().getRemoteUser() + " URL " + req.getURI() + ", response: " + hr.getStatusLine().getStatusCode() + " " + hr.getStatusLine().getReasonPhrase()));
                        contentType.setValue((Object)hr.getEntity().getContentType().getValue());
                        try {
                            return IOUtils.toString((InputStream)hr.getEntity().getContent(), (String)"UTF-8");
                        }
                        catch (IOException e) {
                            log.error((Object)"Exception reading HTTP content", (Throwable)e);
                            return "Exception " + e.getClass() + ": " + e.getMessage();
                        }
                    }
                });
                resolution = new Resolution(){

                    public void execute(HttpServletRequest request, HttpServletResponse response) throws Exception {
                        Object out;
                        String encoding = "UTF-8";
                        response.setCharacterEncoding(encoding);
                        response.setContentType((String)contentType.getValue());
                        String acceptEncoding = request.getHeader("Accept-Encoding");
                        if (acceptEncoding != null && acceptEncoding.contains("gzip")) {
                            response.setHeader("Content-Encoding", "gzip");
                            out = new GZIPOutputStream((OutputStream)response.getOutputStream(), true);
                        } else {
                            out = response.getOutputStream();
                        }
                        IOUtils.copy((Reader)new StringReader(content), (OutputStream)out, (String)encoding);
                        out.flush();
                        out.close();
                    }
                };
                if (client == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (client != null) {
                        try {
                            client.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error((Object)"Failed to write output:", (Throwable)e);
                    return null;
                }
            }
            client.close();
        }
        return resolution;
    }
}

