/*
 * Decompiled with CFR 0.152.
 */
package nl.opengeogroep;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.nio.file.Files;
import java.sql.Connection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.ErrorResolution;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import nl.opengeogroep.ViewerDataExporter;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ColumnListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.apache.commons.io.IOUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class SafetymapsApi {
    public static Resolution features(Connection c, ActionBeanContext context, int version, final int indent, int srid) {
        ViewerDataExporter vde = new ViewerDataExporter(c);
        try {
            final String etag = '\"' + vde.getObjectsETag() + '\"';
            String ifNoneMatch = context.getRequest().getHeader("If-None-Match");
            if (ifNoneMatch != null && ifNoneMatch.contains(etag)) {
                return new ErrorResolution(304);
            }
            final JSONObject o = version < 3 ? SafetymapsApi.getFeaturesLegacy(c, version, srid) : SafetymapsApi.getFeaturesJson(vde);
            return new Resolution(){

                public void execute(HttpServletRequest request, HttpServletResponse response) throws Exception {
                    Object out;
                    String encoding = "UTF-8";
                    response.setCharacterEncoding(encoding);
                    response.setContentType("application/json");
                    response.addHeader("ETag", etag);
                    String acceptEncoding = request.getHeader("Accept-Encoding");
                    if (acceptEncoding != null && acceptEncoding.contains("gzip")) {
                        response.setHeader("Content-Encoding", "gzip");
                        out = new GZIPOutputStream((OutputStream)response.getOutputStream(), true);
                    } else {
                        out = response.getOutputStream();
                    }
                    IOUtils.copy((Reader)new StringReader(o.toString(indent)), (OutputStream)out, (String)encoding);
                    ((OutputStream)out).flush();
                    ((OutputStream)out).close();
                }
            };
        }
        catch (Exception e) {
            return new StreamingResolution("application/json", "error");
        }
    }

    private static JSONObject getFeaturesJson(ViewerDataExporter vde) throws Exception {
        JSONObject o = new JSONObject("{success:true}");
        o.put("results", (Object)vde.getViewerObjectMapOverview());
        return o;
    }

    private static JSONObject getFeaturesLegacy(Connection c, int version, int srid) throws Exception {
        JSONObject o = new JSONObject();
        o.put("type", (Object)"FeatureCollection");
        JSONArray ja = new JSONArray();
        o.put("features", (Object)ja);
        boolean version2 = version == 2;
        String from = version2 ? "dbk2.dbkfeatures_json" : " dbk.dbkfeatures_adres_json";
        List rows = (List)new QueryRunner().query(c, "select \"feature\" from " + from + "(" + srid + ")", (ResultSetHandler)new ColumnListHandler());
        for (Object row : rows) {
            JSONObject d = new JSONObject(row.toString());
            JSONObject j = new JSONObject();
            ja.put((Object)j);
            j.put("type", (Object)"Feature");
            j.put("id", (Object)("DBKFeature.gid--" + d.get("gid")));
            j.put("geometry", d.get("geometry"));
            JSONObject properties = new JSONObject();
            j.put("properties", (Object)properties);
            for (Object key : d.keySet()) {
                if ("geometry".equals(key)) continue;
                properties.put((String)key, d.get((String)key));
            }
        }
        return o;
    }

    public static Resolution styles(Connection c, int indent) throws Exception {
        JSONObject o = new ViewerDataExporter(c).getStyles();
        return new StreamingResolution("application/json", o.toString(indent));
    }

    public static Resolution object(Connection c, int version, int indent, String path) throws Exception {
        Pattern p = Pattern.compile("object\\/([0-9]+)\\.json");
        Matcher m = p.matcher(path);
        if (!m.find()) {
            return new ErrorResolution(404, "No object id found: /api/" + path);
        }
        int id = Integer.parseInt(m.group(1));
        JSONObject o = null;
        if (version == 3) {
            o = new ViewerDataExporter(c).getViewerObjectDetails(id);
        } else {
            Object json = new QueryRunner().query(c, "select \"DBKObject\" from " + (version == 2 ? "dbk2" : "dbk") + ".dbkobject_json(?)", (ResultSetHandler)new ScalarHandler(), new Object[]{id});
            if (json != null) {
                o = new JSONObject();
                o.put("DBKObject", (Object)new JSONObject(json.toString()));
            }
        }
        if (o == null) {
            return new ErrorResolution(404, "Object id not found: " + id);
        }
        return new StreamingResolution("application/json", o.toString(indent));
    }

    public static Resolution media(String filename, String mediaPath) throws Exception {
        if (filename.contains("..")) {
            return new ErrorResolution(404, "Document '" + filename + "' niet gevonden");
        }
        File mediaPathDir = new File(mediaPath);
        File f = new File(mediaPath, filename);
        if (!f.getParentFile().equals(mediaPathDir)) {
            return new ErrorResolution(400, "Filename contains path breaker: " + filename);
        }
        if (!f.exists() || !f.canRead()) {
            return new ErrorResolution(404, "Document '" + filename + "' niet gevonden");
        }
        String mimeType = Files.probeContentType(f.toPath());
        return new StreamingResolution(mimeType, (InputStream)new FileInputStream(f));
    }
}

