/*
 * Decompiled with CFR 0.152.
 */
package nl.opengeogroep;

import java.util.Map;
import org.apache.commons.logging.Log;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class SafetymapsUtils {
    public static JSONObject logExceptionAndReturnJSONObject(Log log, String msg, Exception e) {
        log.error((Object)msg, (Throwable)e);
        JSONObject o = new JSONObject();
        o.put("success", false);
        msg = msg + ": " + e.getClass() + ": " + e.getMessage();
        if (e.getCause() != null) {
            msg = msg + ", cause: " + e.getCause().getClass() + ": " + e.getCause().getMessage();
        }
        o.put("error", (Object)msg);
        return o;
    }

    public static JSONObject rowToJson(Map<String, Object> row, boolean skipNull, boolean skipEmptyString) throws Exception {
        JSONObject o = new JSONObject();
        for (Map.Entry<String, Object> e : row.entrySet()) {
            if (e.getValue() == null) {
                if (skipNull) continue;
                o.put(e.getKey(), null);
                continue;
            }
            if ("".equals(e.getValue())) {
                if (skipEmptyString) continue;
                o.put(e.getKey(), (Object)"");
                continue;
            }
            if (e.getValue().getClass().getName().endsWith("PGobject")) {
                try {
                    String json = e.getValue().toString();
                    Object pgj = json.startsWith("[") ? new JSONArray(json) : (json.startsWith("{") ? new JSONObject(json) : json);
                    o.put(e.getKey(), pgj);
                    continue;
                }
                catch (JSONException ex) {
                    throw new Exception("Error parsing PostgreSQL JSON for property " + e.getKey() + ": " + ex.getMessage() + ", JSON=" + e.getValue());
                }
            }
            o.put(e.getKey(), e.getValue());
        }
        return o;
    }
}

