/*
 * Decompiled with CFR 0.152.
 */
package nl.opengeogroep;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import nl.opengeogroep.SafetymapsUtils;
import org.apache.commons.dbutils.QueryRunner;
import org.apache.commons.dbutils.ResultSetHandler;
import org.apache.commons.dbutils.handlers.ColumnListHandler;
import org.apache.commons.dbutils.handlers.KeyedHandler;
import org.apache.commons.dbutils.handlers.MapListHandler;
import org.apache.commons.dbutils.handlers.ScalarHandler;
import org.json.JSONArray;
import org.json.JSONObject;

public class ViewerDataExporter {
    private Connection c;

    public ViewerDataExporter(Connection c) {
        this.c = c;
    }

    public String getObjectsETag() throws Exception {
        String key = (String)new QueryRunner().query(this.c, "select max(datum_actualisatie) || '_' || count(*) from viewer.viewer_object", (ResultSetHandler)new ScalarHandler());
        if ((key = key + "_v" + new QueryRunner().query(this.c, "select max(value) from viewer.schema_version", (ResultSetHandler)new ScalarHandler())) == null) {
            return "empty_db";
        }
        return key;
    }

    public JSONArray getViewerObjectMapOverview() throws Exception {
        List rows = (List)new QueryRunner().query(this.c, "select * from viewer.viewer_object_map", (ResultSetHandler)new MapListHandler());
        HashSet verdiepingenIds = new HashSet((Collection)new QueryRunner().query(this.c, "select hoofdobject_id from viewer.viewer_object where hoofdobject_id is not null", (ResultSetHandler)new ColumnListHandler()));
        Map selectieadressen = (Map)new QueryRunner().query(this.c, "select * from viewer.viewer_object_selectieadressen", (ResultSetHandler)new KeyedHandler("id"));
        JSONArray a = new JSONArray();
        for (Map row : rows) {
            Integer id = (Integer)row.get("id");
            String name = (String)row.get("formele_naam");
            try {
                Map sa;
                JSONObject o = SafetymapsUtils.rowToJson(row, true, true);
                if (verdiepingenIds.contains(id)) {
                    o.put("heeft_verdiepingen", true);
                }
                if ((sa = (Map)selectieadressen.get(id)) != null) {
                    o.put("selectieadressen", (Object)new JSONArray(sa.get("selectieadressen").toString()));
                }
                a.put((Object)o);
            }
            catch (Exception e) {
                throw new Exception(String.format("Error processing object id=%d, name \"%s\"", id, name), e);
            }
        }
        return a;
    }

    public JSONObject getViewerObjectDetails(long id) throws Exception {
        List rows = (List)new QueryRunner().query(this.c, "select * from viewer.viewer_object_details where id = ?", (ResultSetHandler)new MapListHandler(), new Object[]{id});
        if (rows.isEmpty()) {
            return null;
        }
        try {
            return SafetymapsUtils.rowToJson((Map)rows.get(0), true, true);
        }
        catch (Exception e) {
            throw new Exception(String.format("Error getting object details for id " + id, new Object[0]), e);
        }
    }

    public List<Integer> getViewerObjectIds() throws Exception {
        return (List)new QueryRunner().query(this.c, "select id from viewer.viewer_object_map", (ResultSetHandler)new ColumnListHandler());
    }

    public List<JSONObject> getAllViewerObjectDetails() throws Exception {
        List rows = (List)new QueryRunner().query(this.c, "select * from viewer.viewer_object_details", (ResultSetHandler)new MapListHandler());
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        for (Map row : rows) {
            Object id = row.get("id");
            Object name = row.get("name");
            try {
                result.add(SafetymapsUtils.rowToJson(row, true, true));
            }
            catch (Exception e) {
                throw new Exception(String.format("Error converting object details to JSON for id " + id + ", name " + name, new Object[0]), e);
            }
        }
        return result;
    }

    public JSONObject getStyles() throws Exception {
        JSONObject o = new JSONObject();
        JSONObject compartments = new JSONObject();
        o.put("compartments", (Object)compartments);
        List rows = (List)new QueryRunner().query(this.c, "select * from wfs.type_compartment", (ResultSetHandler)new MapListHandler());
        for (Object row : rows) {
            String code = (String)row.get("code");
            JSONObject compartment = SafetymapsUtils.rowToJson((Map<String, Object>)row, false, false);
            compartments.put(code, (Object)compartment);
        }
        JSONObject lines = new JSONObject();
        o.put("custom_lines", (Object)lines);
        rows = (List)new QueryRunner().query(this.c, "select * from wfs.type_custom_line", (ResultSetHandler)new MapListHandler());
        for (Map row : rows) {
            String code = (String)row.get("code");
            JSONObject line = SafetymapsUtils.rowToJson(row, false, false);
            lines.put(code, (Object)line);
        }
        JSONObject polygons = new JSONObject();
        o.put("custom_polygons", (Object)polygons);
        rows = (List)new QueryRunner().query(this.c, "select * from wfs.type_custom_polygon", (ResultSetHandler)new MapListHandler());
        for (Map row : rows) {
            String code = (String)row.get("code");
            JSONObject polygon = SafetymapsUtils.rowToJson(row, false, false);
            polygons.put(code, (Object)polygon);
        }
        return o;
    }
}

