/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gbi.converter;

import java.util.ArrayList;
import java.util.List;
import nl.b3p.gbi.converter.Attribuut;
import nl.b3p.gbi.converter.Formulier;
import nl.b3p.gbi.converter.FormulierField;
import nl.b3p.gbi.converter.FormulierFieldType;
import nl.b3p.gbi.converter.FormulierTabConfig;
import nl.b3p.gbi.converter.Paspoort;
import nl.b3p.gbi.converter.PaspoortControl;

public class Converter {
    private List<Attribuut> attrs;
    private int numFields = 0;
    private final int MAX_FIELDS_PER_COLUMN = 10;
    private int currentColumn = 1;

    public Converter(List<Attribuut> attrs) {
        this.attrs = attrs;
    }

    public List<Formulier> convert(List<Paspoort> ps) {
        ArrayList<Formulier> forms = new ArrayList<Formulier>();
        ps.forEach(paspoort -> forms.add(this.convert((Paspoort)paspoort)));
        return forms;
    }

    public Formulier convert(Paspoort p) {
        Formulier form = new Formulier();
        form.setName(p.getNaam());
        String tableName = p.getTabelnaam().toLowerCase();
        if (tableName.contains("gb_")) {
            tableName = tableName.substring(3);
        }
        form.setFeatureType(tableName);
        form.setTabs(p.getTabs().size());
        form.setTreeNodeColumn(p.getTabs().get(0).getControls().get(0).getKolom().toLowerCase());
        form.setFields(this.convertFields(p));
        form.setTabConfig(this.convertTabConfig(p));
        return form;
    }

    public FormulierTabConfig convertTabConfig(Paspoort p) {
        FormulierTabConfig tabConfig = new FormulierTabConfig();
        p.getTabs().forEach(paspoortTab -> tabConfig.getTabs().put("" + (paspoortTab.getIndex() + 1), paspoortTab.getCaption()));
        return tabConfig;
    }

    public List<FormulierField> convertFields(Paspoort p) {
        ArrayList<FormulierField> fields = new ArrayList<FormulierField>();
        p.getTabs().forEach(tab -> {
            this.numFields = 0;
            this.currentColumn = 1;
            tab.getControls().forEach(paspoortControl -> {
                fields.add(this.convertField((PaspoortControl)paspoortControl, tab.getIndex() + 1, p));
                ++this.numFields;
                if (this.numFields >= 10) {
                    this.numFields = 0;
                    ++this.currentColumn;
                }
            });
        });
        return fields;
    }

    public FormulierField convertField(PaspoortControl control, int tabNumber, Paspoort paspoort) {
        FormulierField field = new FormulierField();
        field.setKey(control.getKolom().toLowerCase());
        field.setColumn(this.currentColumn);
        field.setTab(tabNumber);
        field.setLabel(control.getNaam());
        field.setType(this.getType(control.getType()).toString());
        this.processFieldForDomain(control, field, paspoort);
        return field;
    }

    private void processFieldForDomain(PaspoortControl control, FormulierField field, Paspoort paspoort) {
        if (control.getDomein() != null && !control.getDomein().isEmpty() && this.attrs != null) {
            boolean a = false;
            for (Attribuut attr : this.attrs) {
                if (!attr.getTabel_naam().equals(paspoort.getTabelnaam()) || !attr.getKolom_naam().equals(control.getDomein())) continue;
                field.setLinkedList(attr.getId());
                field.setType("domain");
            }
        }
    }

    public FormulierFieldType getType(String dqType) {
        switch (dqType) {
            case "GeoVisia.Framework.DQTextBox": {
                return FormulierFieldType.TEXT;
            }
            case "GeoVisia.Framework.DQChoiceList": {
                return FormulierFieldType.SELECT;
            }
        }
        System.err.println("Field type not recognized: " + dqType);
        return FormulierFieldType.TEXT;
    }
}

