/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gbi.converter;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import java.io.File;
import java.io.IOException;
import java.util.List;
import nl.b3p.gbi.converter.FormulierField;
import nl.b3p.gbi.converter.FormulierRelation;
import nl.b3p.gbi.converter.FormulierTabConfig;
import nl.b3p.gbi.converter.TabConfigSerializer;

public class Formulier {
    private int tabs;
    private String name;
    private String featureType;
    private String treeNodeColumn;
    private boolean newPossible;
    private FormulierTabConfig tabConfig;
    private List<FormulierRelation> relation;
    private List<FormulierField> fields;
    private ObjectMapper mapper = new ObjectMapper();

    public Formulier() {
        this.mapper.enable(SerializationFeature.INDENT_OUTPUT);
        SimpleModule module = new SimpleModule("TabConfigSerializer", new Version(2, 1, 3, null, null, null));
        module.addSerializer(FormulierTabConfig.class, (JsonSerializer)new TabConfigSerializer());
        this.mapper.registerModule((Module)module);
    }

    public JsonNode toJSON() throws IOException {
        return this.mapper.valueToTree((Object)this);
    }

    public File toFile(String filename) throws IOException {
        JsonNode n = this.toJSON();
        File f = new File(filename);
        this.mapper.writeValue(f, (Object)n);
        return f;
    }

    public String toString() {
        try {
            return this.toJSON().toPrettyString();
        }
        catch (IOException e) {
            System.err.println("cannot print form: " + e.getLocalizedMessage());
            return "error: " + e.getLocalizedMessage();
        }
    }

    public int getTabs() {
        return this.tabs;
    }

    public void setTabs(int tabs) {
        this.tabs = tabs;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getFeatureType() {
        return this.featureType;
    }

    public void setFeatureType(String featureType) {
        this.featureType = featureType;
    }

    public String getTreeNodeColumn() {
        return this.treeNodeColumn;
    }

    public void setTreeNodeColumn(String treeNodeColumn) {
        this.treeNodeColumn = treeNodeColumn;
    }

    public boolean isNewPossible() {
        return this.newPossible;
    }

    public void setNewPossible(boolean newPossible) {
        this.newPossible = newPossible;
    }

    public FormulierTabConfig getTabConfig() {
        return this.tabConfig;
    }

    public void setTabConfig(FormulierTabConfig tabConfig) {
        this.tabConfig = tabConfig;
    }

    public List<FormulierRelation> getRelation() {
        return this.relation;
    }

    public void setRelation(List<FormulierRelation> relation) {
        this.relation = relation;
    }

    public List<FormulierField> getFields() {
        return this.fields;
    }

    public void setFields(List<FormulierField> fields) {
        this.fields = fields;
    }
}

