/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.gbi.converter;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyNamingStrategy;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import nl.b3p.gbi.converter.Paspoort;

public class Parser {
    ObjectMapper mapper = new ObjectMapper();

    public Parser() {
        this.mapper.setPropertyNamingStrategy(PropertyNamingStrategy.LOWER_CAMEL_CASE);
    }

    public List<Paspoort> parse(String content) throws IOException {
        return Collections.singletonList(this.parseFile(content));
    }

    public List<Paspoort> parse(File f) throws IOException {
        if (f.isDirectory()) {
            File[] fs = f.listFiles();
            ArrayList<Paspoort> ps = new ArrayList<Paspoort>();
            for (File file : fs) {
                try {
                    ps.add(this.parseFile(file));
                }
                catch (IOException e) {
                    System.err.println("Cannot parse " + file + ". Skipping file.");
                }
            }
            return ps;
        }
        return Collections.singletonList(this.parseFile(f));
    }

    private Paspoort parseFile(File f) throws IOException {
        if (f.isDirectory()) {
            throw new IOException("Parameter is not a file, but a directory. Aborting");
        }
        ObjectMapper mapper = new ObjectMapper();
        mapper.setPropertyNamingStrategy(PropertyNamingStrategy.LOWER_CAMEL_CASE);
        return (Paspoort)mapper.readValue(f, Paspoort.class);
    }

    private Paspoort parseFile(String f) throws IOException {
        return (Paspoort)this.mapper.readValue(f, Paspoort.class);
    }
}

