/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.ibis.util;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.Polygon;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.persistence.EntityManager;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.viewer.ibis.util.IbisConstants;
import nl.b3p.viewer.ibis.util.WorkflowStatus;
import nl.b3p.viewer.ibis.util.WorkflowUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.Transaction;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.jts.JTSFactoryFinder;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.ExcludeFilter;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;

public class WorkflowUtil
implements IbisConstants {
    private static final Log log = LogFactory.getLog(WorkflowUtil.class);

    private WorkflowUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateTerreinGeometry(Integer terreinID, Layer layer, WorkflowStatus kavelStatus, Application application, EntityManager em) {
        log.debug((Object)("Updating terrein geometry for " + terreinID));
        SimpleFeatureStore terreinStore = null;
        SimpleFeatureStore kavelStore = null;
        FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2();
        DefaultTransaction terreinTransaction = new DefaultTransaction("edit-terrein-geom");
        DefaultTransaction kavelTransaction = new DefaultTransaction("get-kavel-geom");
        try {
            ExcludeFilter kavelFilter = Filter.EXCLUDE;
            switch (2.$SwitchMap$nl$b3p$viewer$ibis$util$WorkflowStatus[kavelStatus.ordinal()]) {
                case 1: {
                    kavelFilter = ff.and((Filter)ff.equals((Expression)ff.property("terreinid"), (Expression)ff.literal((Object)terreinID)), (Filter)ff.or((Filter)ff.equal((Expression)ff.property("workflow_status"), (Expression)ff.literal((Object)WorkflowStatus.bewerkt.toString()), false), (Filter)ff.equal((Expression)ff.property("workflow_status"), (Expression)ff.literal((Object)WorkflowStatus.definitief.toString()), false)));
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    kavelFilter = ff.and((Filter)ff.equals((Expression)ff.property("terreinid"), (Expression)ff.literal((Object)terreinID)), (Filter)ff.equal((Expression)ff.property("workflow_status"), (Expression)ff.literal((Object)WorkflowStatus.definitief.toString()), false));
                    break;
                }
            }
            log.debug((Object)("Looking for kavel with filter: " + kavelFilter));
            kavelStore = (SimpleFeatureStore)layer.getFeatureType().openGeoToolsFeatureSource();
            kavelStore.setTransaction((Transaction)kavelTransaction);
            SimpleFeatureCollection kavels = kavelStore.getFeatures((Filter)kavelFilter);
            ArrayList kavelGeoms = new ArrayList();
            kavels.accepts((FeatureVisitor)new /* Unavailable Anonymous Inner Class!! */, null);
            log.debug((Object)("Kavels found: " + kavelGeoms.size()));
            GeometryFactory factory = JTSFactoryFinder.getGeometryFactory(null);
            GeometryCollection geometryCollection = (GeometryCollection)factory.buildGeometry(kavelGeoms);
            Geometry newTerreinGeom = geometryCollection.union();
            if (!newTerreinGeom.getGeometryType().equalsIgnoreCase("MultiPolygon")) {
                GeometryFactory f = JTSFactoryFinder.getGeometryFactory();
                newTerreinGeom = f.createMultiPolygon(new Polygon[]{(Polygon)newTerreinGeom});
            }
            ApplicationLayer terreinAppLyr = null;
            List lyrs = application.loadTreeCache(em).getApplicationLayers();
            ListIterator it = lyrs.listIterator();
            while (it.hasNext() && !(terreinAppLyr = (ApplicationLayer)it.next()).getLayerName().equalsIgnoreCase("bedrijventerrein")) {
            }
            Layer l = terreinAppLyr.getService().getLayer("bedrijventerrein", em);
            terreinStore = (SimpleFeatureStore)l.getFeatureType().openGeoToolsFeatureSource();
            terreinStore.setTransaction((Transaction)terreinTransaction);
            ExcludeFilter terreinFilter = Filter.EXCLUDE;
            switch (2.$SwitchMap$nl$b3p$viewer$ibis$util$WorkflowStatus[kavelStatus.ordinal()]) {
                case 1: {
                    terreinFilter = ff.and((Filter)ff.equals((Expression)ff.property("ibis_id"), (Expression)ff.literal((Object)terreinID)), (Filter)ff.equal((Expression)ff.property("workflow_status"), (Expression)ff.literal((Object)WorkflowStatus.bewerkt.name()), false));
                    break;
                }
                case 2: 
                case 3: 
                case 4: {
                    terreinFilter = ff.and((Filter)ff.equals((Expression)ff.property("ibis_id"), (Expression)ff.literal((Object)terreinID)), (Filter)ff.equal((Expression)ff.property("workflow_status"), (Expression)ff.literal((Object)WorkflowStatus.definitief.name()), false));
                    break;
                }
            }
            log.debug((Object)("Update terrein geom for kavels filtered by: " + terreinFilter));
            String geomAttrName = ((SimpleFeatureType)terreinStore.getSchema()).getGeometryDescriptor().getLocalName();
            terreinStore.modifyFeatures(geomAttrName, (Object)newTerreinGeom, (Filter)terreinFilter);
            terreinTransaction.commit();
        }
        catch (Exception e) {
            log.error((Object)String.format("Update van terrein geometrie %s is mislukt", terreinID), (Throwable)e);
        }
        finally {
            try {
                kavelTransaction.close();
                terreinTransaction.close();
            }
            catch (IOException iOException) {}
            if (terreinStore != null) {
                terreinStore.getDataStore().dispose();
            }
            if (kavelStore != null) {
                kavelStore.getDataStore().dispose();
            }
        }
    }
}

