/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPrivateKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.viewer.config.CycloramaAccount;
import nl.b3p.viewer.stripes.LayerListActionBean;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/cyclorama")
@StrictBinding
public class CycloramaActionBean
implements ActionBean {
    private final String SIG_ALGORITHM = "SHA1withRSA";
    private final String URL_ENCODING = "utf-8";
    private static final Log log = LogFactory.getLog(LayerListActionBean.class);
    private ActionBeanContext context;
    @Validate
    private Long appId;
    @Validate
    private Long accountId;
    @Validate
    private String imageId;
    private String tid;
    private String apiKey;

    public ActionBeanContext getContext() {
        return this.context;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public Long getAppId() {
        return this.appId;
    }

    public void setAppId(Long appId) {
        this.appId = appId;
    }

    public Long getAccountId() {
        return this.accountId;
    }

    public void setAccountId(Long accountId) {
        this.accountId = accountId;
    }

    public String getImageId() {
        return this.imageId;
    }

    public void setImageId(String imageId) {
        this.imageId = imageId;
    }

    public String getTid() {
        return this.tid;
    }

    public void setTid(String tid) {
        this.tid = tid;
    }

    public String getApiKey() {
        return this.apiKey;
    }

    public void setApiKey(String apiKey) {
        this.apiKey = apiKey;
    }

    @DefaultHandler
    public Resolution sign() throws JSONException {
        JSONObject json = new JSONObject();
        json.put("success", false);
        EntityManager em = Stripersist.getEntityManager();
        CycloramaAccount account = (CycloramaAccount)em.find(CycloramaAccount.class, (Object)this.accountId);
        if (this.imageId != null && account != null) {
            try {
                this.apiKey = "K3MRqDUdej4JGvohGfM5e78xaTUxmbYBqL0tSHsNWnwdWPoxizYBmjIBGHAhS3U1";
                SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                df.setTimeZone(TimeZone.getTimeZone("GMT"));
                String date = df.format(new Date());
                String token = "X" + account.getUsername() + "&" + this.imageId + "&" + date + "Z";
                String privateBase64Key = account.getPrivateBase64Key();
                if (privateBase64Key == null || privateBase64Key.equals("")) {
                    log.error((Object)"Kon private key voor aanmaken TID niet ophalen!");
                }
                this.tid = this.getTIDFromBase64EncodedString(privateBase64Key, token);
                json.put("tid", (Object)this.tid);
                json.put("imageId", (Object)this.imageId);
                json.put("apiKey", (Object)this.apiKey);
                json.put("success", true);
            }
            catch (Exception ex) {
                json.put("message", (Object)ex.getLocalizedMessage());
            }
        }
        return new StreamingResolution("application/json", json.toString());
    }

    private String getTIDFromBase64EncodedString(String base64Encoded, String token) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, SignatureException, UnsupportedEncodingException {
        String tid = null;
        Base64 encoder = new Base64();
        byte[] tempBytes = encoder.decode(base64Encoded.getBytes());
        KeyFactory rsaKeyFac = KeyFactory.getInstance("RSA");
        PKCS8EncodedKeySpec encodedKeySpec = new PKCS8EncodedKeySpec(tempBytes);
        RSAPrivateKey privKey = (RSAPrivateKey)rsaKeyFac.generatePrivate(encodedKeySpec);
        byte[] signature = this.sign((PrivateKey)privKey, token);
        String base64 = new String(encoder.encode(signature));
        tid = URLEncoder.encode(token + "&" + base64, "utf-8");
        return tid;
    }

    private byte[] sign(PrivateKey privateKey, String token) throws NoSuchAlgorithmException, InvalidKeyException, SignatureException {
        Signature instance = Signature.getInstance("SHA1withRSA");
        instance.initSign(privateKey);
        instance.update(token.getBytes());
        byte[] signature = instance.sign();
        return signature;
    }
}

