/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.print;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Date;
import javax.servlet.http.HttpServletResponse;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.util.JAXBSource;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import nl.b3p.mail.Mailer;
import nl.b3p.viewer.print.PrintInfo;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.apps.FOUserAgent;
import org.apache.fop.apps.Fop;
import org.apache.fop.apps.FopFactory;

/*
 * Exception performing whole class analysis ignored.
 */
public class PrintGenerator
implements Runnable {
    private static final Log log = LogFactory.getLog(PrintGenerator.class);
    private final PrintInfo info;
    private final String mimeType;
    private final File xsl;
    private final String filename;
    private final String fromName;
    private final String fromMail;
    private final String toMail;

    public PrintGenerator(PrintInfo info, String mimeType, File xsl, String filename, String fromName, String fromMail, String toMail) {
        this.info = info;
        this.mimeType = mimeType;
        this.xsl = xsl;
        this.filename = filename;
        this.fromName = fromName;
        this.fromMail = fromMail;
        this.toMail = toMail;
    }

    @Override
    public void run() {
        try {
            this.mailPrint();
        }
        catch (Exception ex) {
            log.error((Object)"Cannot creat print.");
            try {
                Mailer.sendMail((String)this.fromName, (String)this.fromMail, (String)this.toMail, (String)"Fout bij printen", (String)("De print kon niet worden gemaakt. De foutmelding is: " + ex.getLocalizedMessage()));
            }
            catch (Exception ex1) {
                log.error((Object)"Cannot send mail for reporting exception");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mailPrint() throws Exception {
        File temp = File.createTempFile("flamingo", "print");
        try {
            FileOutputStream fos = new FileOutputStream(temp);
            String path = new File(this.xsl.getParent()).toURI().toString();
            PrintGenerator.createOutput((PrintInfo)this.info, (String)this.mimeType, (InputStream)new FileInputStream(this.xsl), (String)path, (OutputStream)fos, (String)this.filename);
            Mailer.sendMail((String)this.fromName, (String)this.fromMail, (String)this.toMail, (String)"Print is klaar", (String)"De print is klaar en staat in de bijlage", (File)temp, (String)this.filename);
        }
        finally {
            temp.delete();
        }
    }

    public static void createOutput(PrintInfo info, String mimeType, File xslFile, boolean addJavascript, HttpServletResponse response, String filename) throws URISyntaxException, IOException {
        String path = new File(xslFile.getParent()).toURI().toString();
        PrintGenerator.createOutput((PrintInfo)info, (String)mimeType, (InputStream)new FileInputStream(xslFile), (String)path, (boolean)addJavascript, (HttpServletResponse)response, (String)filename);
    }

    public static void createOutput(PrintInfo info, String mimeType, URL xslUrl, boolean addJavascript, HttpServletResponse response, String filename) throws URISyntaxException, IOException {
        String path = xslUrl.toString().substring(0, xslUrl.toString().lastIndexOf("/") + 1);
        PrintGenerator.createOutput((PrintInfo)info, (String)mimeType, (InputStream)xslUrl.openStream(), (String)path, (boolean)addJavascript, (HttpServletResponse)response, (String)filename);
    }

    public static void createOutput(PrintInfo info, String mimeType, InputStream xslIs, String basePath, boolean addJavascript, HttpServletResponse response, String filename) throws URISyntaxException, IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PrintGenerator.createOutput((PrintInfo)info, (String)mimeType, (InputStream)xslIs, (String)basePath, (OutputStream)out, (String)filename);
        response.setContentType(mimeType);
        response.setContentLength(out.size());
        response.setHeader("Content-Disposition", "attachment; filename=" + filename);
        response.getOutputStream().write(out.toByteArray());
        response.getOutputStream().flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void createOutput(PrintInfo info, String mimeType, InputStream xslIs, String basePath, OutputStream out, String filename) throws URISyntaxException, IOException {
        FopFactory fopFactory = FopFactory.newInstance((URI)new URI(basePath));
        try {
            FOUserAgent foUserAgent = fopFactory.newFOUserAgent();
            foUserAgent.setCreator("Flamingo");
            foUserAgent.setProducer("Flamingo");
            Date now = new Date();
            foUserAgent.setCreationDate(now);
            foUserAgent.setTitle("Kaart");
            Fop fop = fopFactory.newFop(mimeType, foUserAgent, out);
            JAXBContext jc = JAXBContext.newInstance((Class[])new Class[]{PrintInfo.class});
            JAXBSource src = new JAXBSource(jc, (Object)info);
            if (log.isDebugEnabled()) {
                JAXBContext jaxbContext = JAXBContext.newInstance((Class[])new Class[]{PrintInfo.class});
                StringWriter sw = new StringWriter();
                jaxbContext.createMarshaller().marshal((Object)info, (Writer)sw);
                log.debug((Object)("Print XML:\n" + sw.toString()));
            }
            StreamSource xsltSrc = new StreamSource(xslIs);
            xsltSrc.setSystemId(basePath);
            TransformerFactory factory = TransformerFactory.newInstance();
            Transformer transformer = factory.newTransformer(xsltSrc);
            SAXResult res = new SAXResult(fop.getDefaultHandler());
            transformer.transform((Source)src, res);
        }
        catch (JAXBException | TransformerException | FOPException ex) {
            log.error((Object)"Fout tijdens print output: ", ex);
        }
        finally {
            out.close();
        }
    }
}

