/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import java.io.Reader;
import java.io.StringReader;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.persistence.EntityManager;
import javax.servlet.http.HttpServletRequest;
import net.sourceforge.stripes.action.ActionBean;
import net.sourceforge.stripes.action.ActionBeanContext;
import net.sourceforge.stripes.action.After;
import net.sourceforge.stripes.action.Before;
import net.sourceforge.stripes.action.DefaultHandler;
import net.sourceforge.stripes.action.Resolution;
import net.sourceforge.stripes.action.StreamingResolution;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import net.sourceforge.stripes.controller.LifecycleStage;
import net.sourceforge.stripes.validation.DateTypeConverter;
import net.sourceforge.stripes.validation.EnumeratedTypeConverter;
import net.sourceforge.stripes.validation.Validate;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.app.ApplicationLayer;
import nl.b3p.viewer.config.security.Authorizations;
import nl.b3p.viewer.config.services.FeatureTypeRelation;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.viewer.ibis.util.DateUtils;
import nl.b3p.viewer.ibis.util.IbisConstants;
import nl.b3p.viewer.stripes.IbisAttributeListActionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataUtilities;
import org.geotools.data.Query;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.text.ecql.ECQL;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.opengis.feature.Property;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/ibisattributes")
@StrictBinding
public class IbisAttributeListActionBean
implements ActionBean,
IbisConstants {
    private static final Log log = LogFactory.getLog(IbisAttributeListActionBean.class);
    private static final String JSON_METADATA = "metaData";
    private ActionBeanContext context;
    @Validate
    private String data;
    @Validate
    private String filename;
    @Validate
    private String mimetype;
    @Validate
    private Application application;
    @Validate
    private ApplicationLayer appLayer;
    @Validate(converter=DateTypeConverter.class)
    private Date fromDate;
    @Validate(converter=DateTypeConverter.class)
    private Date toDate;
    @Validate
    private String regio;
    @Validate
    private String gemeente;
    @Validate
    private String terrein;
    @Validate
    private List<String> attrNames;
    @Validate(converter=EnumeratedTypeConverter.class)
    private ReportType reportType;
    @Validate(converter=EnumeratedTypeConverter.class)
    private QueryArea aggregationLevel;
    @Validate(converter=EnumeratedTypeConverter.class)
    private AggregationLevelDate aggregationLevelDate;
    private Layer layer = null;
    private boolean unauthorized;
    private String gebiedsNaamQuery;
    private QueryArea areaType;
    private static final String TERREINID_FIELDNAME = "id";
    private static final String GEMEENTE_FIELDNAME = "naam";
    private static final String REGIO_FIELDNAME = "vvr_naam";
    private static final String TERREIN_FIELDNAME = "a_plannaam";
    private static final String STATUS_FIELDNAME = "status";
    private static final String KAVELID_RELATED_FIELDNAME = "kavelid";
    private static final String GEMEENTE_RELATED_FIELDNAME = "gemeentenaam";
    private static final String REGIO_RELATED_FIELDNAME = "regionaam";
    private static final String TERREIN_RELATED_FIELDNAME = "terreinnaam";
    private static final String TERREINID_RELATED_FIELDNAME = "terreinid";
    private static final String UITGIFTEDATUM_RELATED_FIELDNAME = "datumuitgifte";
    private static final String OPPERVLAKTE_GEOM_RELATED_FIELDNAME = "opp_geometrie";
    private static final String GEBIED_FIELDNAME = "gebied";
    private static final String RELATED_FT_NAME = null;

    @After(stages={LifecycleStage.BindingAndValidation})
    public void loadLayer() {
        this.layer = this.appLayer.getService().getSingleLayer(this.appLayer.getLayerName(), Stripersist.getEntityManager());
    }

    @Before(stages={LifecycleStage.EventHandling})
    public void checkAuthorization() {
        EntityManager em = Stripersist.getEntityManager();
        if (this.application == null || this.appLayer == null || !Authorizations.isAppLayerReadAuthorized((Application)this.application, (ApplicationLayer)this.appLayer, (HttpServletRequest)this.context.getRequest(), (EntityManager)em)) {
            this.unauthorized = true;
        }
    }

    public Resolution download() throws Exception {
        if (this.data == null) {
            throw new IllegalArgumentException("Data cannot be null.");
        }
        if (this.unauthorized) {
            throw new IllegalStateException("Not authorized.");
        }
        if (this.mimetype == null) {
            this.mimetype = "application/vnd.ms-excel";
        }
        if (this.filename == null) {
            this.filename = "ibisrapportage.xls";
        }
        log.debug((Object)("returning excel:" + this.data));
        return new StreamingResolution(this.mimetype, (Reader)new StringReader(this.data)).setFilename(this.filename).setAttachment(false);
    }

    @DefaultHandler
    public Resolution query() throws Exception {
        JSONObject json = new JSONObject();
        json.put("success", (Object)Boolean.FALSE);
        JSONObject metadata = new JSONObject().put("root", (Object)"data").put("totalProperty", (Object)"total").put("successProperty", (Object)"success").put("messageProperty", (Object)"message").put("idProperty", (Object)"rownum");
        json.put(JSON_METADATA, (Object)metadata);
        String error = null;
        if (this.appLayer == null) {
            error = "Invalid parameters.";
        } else if (this.unauthorized) {
            error = "Not authorized.";
        } else if (this.reportType == null) {
            error = "Report type is required.";
        } else {
            try {
                if (this.terrein != null) {
                    this.areaType = QueryArea.TERREIN;
                    this.gebiedsNaamQuery = "a_plannaam='" + this.terrein + "'";
                } else if (this.gemeente != null) {
                    this.areaType = QueryArea.GEMEENTE;
                    this.gebiedsNaamQuery = "naam='" + this.gemeente + "'";
                } else if (this.regio != null) {
                    this.areaType = QueryArea.REGIO;
                    this.gebiedsNaamQuery = "vvr_naam='" + this.regio + "'";
                } else {
                    throw new IllegalArgumentException("Geen gebied opgegeven voor rapport.");
                }
                switch (4.$SwitchMap$nl$b3p$viewer$stripes$IbisAttributeListActionBean$ReportType[this.reportType.ordinal()]) {
                    case 1: {
                        this.reportIssued(json);
                        break;
                    }
                    case 2: {
                        this.reportIndividualData(json);
                        break;
                    }
                    case 3: {
                        this.reportAggregateData(json);
                    }
                }
                json.put("message", (Object)"OK");
                json.put("success", (Object)Boolean.TRUE);
            }
            catch (Exception e) {
                log.error((Object)"Error generating report data.", (Throwable)e);
                error = e.getLocalizedMessage();
            }
        }
        if (error != null) {
            json.put("success", (Object)Boolean.FALSE);
            json.put("message", (Object)error);
        }
        log.debug((Object)("returning json:" + json));
        return new StreamingResolution("application/json", (Reader)new StringReader(json.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportIssued(JSONObject json) throws Exception {
        if (this.fromDate == null || this.toDate == null) {
            throw new IllegalArgumentException("Datum vanaf en datum tot zijn verplicht voor uitgifte.");
        }
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
        sdf.setTimeZone(TimeZone.getDefault());
        nl.b3p.viewer.config.services.SimpleFeatureType ft = this.layer.getFeatureType();
        nl.b3p.viewer.config.services.SimpleFeatureType relFt = this.getRelatedSFT(ft, RELATED_FT_NAME);
        SimpleFeatureSource fs = (SimpleFeatureSource)ft.openGeoToolsFeatureSource();
        SimpleFeatureSource foreignFs = (SimpleFeatureSource)relFt.openGeoToolsFeatureSource();
        Filter filter = ECQL.toFilter((String)this.gebiedsNaamQuery);
        List<String> tPropnames = Arrays.asList(TERREINID_FIELDNAME, TERREIN_FIELDNAME, GEMEENTE_FIELDNAME, REGIO_FIELDNAME);
        Query q = new Query(fs.getName().toString());
        q.setPropertyNames(tPropnames);
        q.setFilter(filter);
        q.setHandle("uitgifte-rapport");
        q.setMaxFeatures(1000);
        try {
            SimpleFeatureCollection inMem = DataUtilities.collection((SimpleFeatureIterator)fs.getFeatures(q).features());
            StringBuilder in = new StringBuilder();
            SimpleFeatureIterator inMemFeats = inMem.features();
            TreeSet<String> terreinNames = new TreeSet<String>((Comparator<String>)new /* Unavailable Anonymous Inner Class!! */);
            TreeSet<String> regioNames = new TreeSet<String>((Comparator<String>)new /* Unavailable Anonymous Inner Class!! */);
            TreeSet<String> gemeenteNames = new TreeSet<String>((Comparator<String>)new /* Unavailable Anonymous Inner Class!! */);
            while (inMemFeats.hasNext()) {
                SimpleFeature f = (SimpleFeature)inMemFeats.next();
                in.append(f.getAttribute(TERREINID_FIELDNAME)).append(",");
                terreinNames.add((String)f.getAttribute(TERREIN_FIELDNAME));
                regioNames.add((String)f.getAttribute(REGIO_FIELDNAME));
                gemeenteNames.add((String)f.getAttribute(GEMEENTE_FIELDNAME));
            }
            inMemFeats.close();
            Query foreignQ = new Query(foreignFs.getName().toString());
            foreignQ.setHandle("uitgifte-rapport-related");
            List<String> propnames = Arrays.asList(KAVELID_RELATED_FIELDNAME, OPPERVLAKTE_GEOM_RELATED_FIELDNAME, UITGIFTEDATUM_RELATED_FIELDNAME, TERREIN_RELATED_FIELDNAME, REGIO_RELATED_FIELDNAME, GEMEENTE_RELATED_FIELDNAME);
            foreignQ.setPropertyNames(propnames);
            String query = "status= 'uitgegeven' AND terreinid IN (" + in.substring(0, in.length() - 1) + ") AND " + UITGIFTEDATUM_RELATED_FIELDNAME + " DURING " + sdf.format(this.fromDate) + "/" + sdf.format(this.toDate);
            log.debug((Object)("uitgifte query: " + query));
            foreignQ.setFilter(ECQL.toFilter((String)query));
            SimpleFeatureCollection sfc = DataUtilities.collection((SimpleFeatureIterator)foreignFs.getFeatures(foreignQ).features());
            SimpleFeatureType type = DataUtilities.createType((String)"AGGREGATE", (String)"id:String,*geom:MultiPolygon:28992,maand:String,oppervlakte:Double,gebied:String");
            ArrayList<nl.b3p.viewer.config.services.AttributeDescriptor> relFeatureTypeAttributes = new ArrayList<nl.b3p.viewer.config.services.AttributeDescriptor>();
            nl.b3p.viewer.config.services.AttributeDescriptor maand = new nl.b3p.viewer.config.services.AttributeDescriptor();
            maand.setName("maand");
            maand.setAlias("maand");
            maand.setType("date");
            maand.setId(Long.valueOf(1L));
            relFeatureTypeAttributes.add(maand);
            nl.b3p.viewer.config.services.AttributeDescriptor opp = new nl.b3p.viewer.config.services.AttributeDescriptor();
            opp.setName("oppervlakte");
            opp.setAlias("oppervlakte");
            opp.setType("double");
            opp.setId(Long.valueOf(2L));
            relFeatureTypeAttributes.add(opp);
            nl.b3p.viewer.config.services.AttributeDescriptor plan = new nl.b3p.viewer.config.services.AttributeDescriptor();
            plan.setName(GEBIED_FIELDNAME);
            plan.setAlias("gebiedsnaam");
            plan.setType("string");
            plan.setId(Long.valueOf(3L));
            relFeatureTypeAttributes.add(plan);
            block1 : switch (4.$SwitchMap$nl$b3p$viewer$stripes$IbisAttributeListActionBean$QueryArea[this.aggregationLevel.ordinal()]) {
                case 1: {
                    switch (4.$SwitchMap$nl$b3p$viewer$stripes$IbisAttributeListActionBean$AggregationLevelDate[this.aggregationLevelDate.ordinal()]) {
                        case 1: {
                            sfc = this.aggregateUitgifteByMonthAndArea(sfc, type, "oppervlakte", regioNames, REGIO_RELATED_FIELDNAME);
                            break;
                        }
                        case 2: {
                            sfc = this.aggregateUitgifteByArea(sfc, type, "oppervlakte", regioNames, REGIO_RELATED_FIELDNAME);
                        }
                    }
                    break;
                }
                case 2: {
                    switch (4.$SwitchMap$nl$b3p$viewer$stripes$IbisAttributeListActionBean$AggregationLevelDate[this.aggregationLevelDate.ordinal()]) {
                        case 1: {
                            sfc = this.aggregateUitgifteByMonthAndArea(sfc, type, "oppervlakte", gemeenteNames, GEMEENTE_RELATED_FIELDNAME);
                            break;
                        }
                        case 2: {
                            sfc = this.aggregateUitgifteByArea(sfc, type, "oppervlakte", gemeenteNames, GEMEENTE_RELATED_FIELDNAME);
                        }
                    }
                    break;
                }
                case 3: {
                    switch (4.$SwitchMap$nl$b3p$viewer$stripes$IbisAttributeListActionBean$AggregationLevelDate[this.aggregationLevelDate.ordinal()]) {
                        case 1: {
                            sfc = this.aggregateUitgifteByMonthAndArea(sfc, type, "oppervlakte", terreinNames, TERREIN_RELATED_FIELDNAME);
                            break block1;
                        }
                        case 2: {
                            sfc = this.aggregateUitgifteByArea(sfc, type, "oppervlakte", terreinNames, TERREIN_RELATED_FIELDNAME);
                        }
                    }
                }
            }
            switch (4.$SwitchMap$nl$b3p$viewer$stripes$IbisAttributeListActionBean$AggregationLevelDate[this.aggregationLevelDate.ordinal()]) {
                case 1: {
                    propnames = Arrays.asList("maand", "oppervlakte", GEBIED_FIELDNAME);
                    break;
                }
                case 2: {
                    propnames = Arrays.asList("oppervlakte", GEBIED_FIELDNAME);
                }
            }
            this.featuresToJson(sfc, json, relFeatureTypeAttributes, propnames);
        }
        finally {
            foreignFs.getDataStore().dispose();
            fs.getDataStore().dispose();
        }
    }

    private SimpleFeatureCollection aggregateUitgifteByMonthAndArea(SimpleFeatureCollection sfc, SimpleFeatureType type, String sfTypeAreaName, Set<String> featNames, String gebiedFieldName) {
        int months = DateUtils.differenceInMonths((Date)this.fromDate, (Date)this.toDate);
        SimpleDateFormat YYYYMM = new SimpleDateFormat("YYYY.MM");
        TreeMap<String, SimpleFeature> newfeats = new TreeMap<String, SimpleFeature>();
        for (String fName : featNames) {
            Date newDate = this.fromDate;
            for (int m = 0; m < months; ++m) {
                String key = fName + YYYYMM.format(newDate);
                SimpleFeature month = DataUtilities.createFeature((SimpleFeatureType)type, (String)(key + "|null|" + YYYYMM.format(newDate) + "|0d|" + fName));
                newfeats.put(key, month);
                newDate = DateUtils.addMonth((Date)newDate);
            }
        }
        SimpleFeatureIterator items = sfc.features();
        while (items.hasNext()) {
            SimpleFeature f = (SimpleFeature)items.next();
            Date d = (Date)f.getAttribute(UITGIFTEDATUM_RELATED_FIELDNAME);
            SimpleFeature newFeat = (SimpleFeature)newfeats.get(f.getAttribute(gebiedFieldName) + YYYYMM.format(d));
            newFeat.setAttribute(sfTypeAreaName, (Object)((Double)newFeat.getAttribute(sfTypeAreaName) + ((BigDecimal)f.getAttribute(OPPERVLAKTE_GEOM_RELATED_FIELDNAME)).doubleValue()));
        }
        items.close();
        ArrayList feats = new ArrayList(newfeats.values());
        return DataUtilities.collection(feats);
    }

    private SimpleFeatureCollection aggregateUitgifteByArea(SimpleFeatureCollection sfc, SimpleFeatureType type, String sfTypeAreaName, Set<String> featNames, String gebiedFieldName) {
        TreeMap<String, SimpleFeature> newfeats = new TreeMap<String, SimpleFeature>();
        for (String fName : featNames) {
            SimpleFeature newfeat = DataUtilities.createFeature((SimpleFeatureType)type, (String)(fName + "|null|null|0d|" + fName));
            newfeats.put(fName, newfeat);
        }
        SimpleFeatureIterator items = sfc.features();
        while (items.hasNext()) {
            SimpleFeature f = (SimpleFeature)items.next();
            SimpleFeature newFeat = (SimpleFeature)newfeats.get((String)f.getAttribute(gebiedFieldName));
            newFeat.setAttribute(sfTypeAreaName, (Object)((Double)newFeat.getAttribute(sfTypeAreaName) + ((BigDecimal)f.getAttribute(OPPERVLAKTE_GEOM_RELATED_FIELDNAME)).doubleValue()));
        }
        items.close();
        ArrayList feats = new ArrayList(newfeats.values());
        Collections.reverse(feats);
        return DataUtilities.collection(feats);
    }

    private void featuresToJson(SimpleFeatureCollection sfc, JSONObject json, List<nl.b3p.viewer.config.services.AttributeDescriptor> featureTypeAttributes, List<String> outputPropNames) throws JSONException {
        JSONArray fields = new JSONArray();
        JSONArray columns = new JSONArray();
        JSONArray datas = new JSONArray();
        SimpleFeatureIterator sfIter = sfc.features();
        boolean getMetadataFromFirstFeature = true;
        while (sfIter.hasNext()) {
            SimpleFeature feature = (SimpleFeature)sfIter.next();
            JSONObject fData = new JSONObject();
            for (nl.b3p.viewer.config.services.AttributeDescriptor attr : featureTypeAttributes) {
                String name = attr.getName();
                if (getMetadataFromFirstFeature && outputPropNames.contains(name)) {
                    JSONObject field = new JSONObject().put("name", (Object)name).put("type", (Object)attr.getExtJSType());
                    if (this.reportType == ReportType.ISSUE && attr.getType().equals("date")) {
                        field.put("dateFormat", (Object)"Y-m");
                    }
                    fields.put((Object)field);
                    columns.put((Object)new JSONObject().put("text", (Object)(attr.getAlias() != null ? attr.getAlias() : name)).put("dataIndex", (Object)name));
                }
                fData.put(attr.getName(), feature.getAttribute(attr.getName()));
            }
            datas.put((Object)fData);
            getMetadataFromFirstFeature = false;
        }
        json.getJSONObject(JSON_METADATA).put("fields", (Object)fields);
        json.getJSONObject(JSON_METADATA).put("columns", (Object)columns);
        json.put("data", (Object)datas);
        json.put("total", datas.length());
        sfIter.close();
    }

    private nl.b3p.viewer.config.services.SimpleFeatureType getRelatedSFT(nl.b3p.viewer.config.services.SimpleFeatureType ft, String typeNameToGet) {
        FeatureTypeRelation rel;
        nl.b3p.viewer.config.services.SimpleFeatureType relFt = null;
        Iterator iterator = ft.getRelations().iterator();
        while (iterator.hasNext() && (!(rel = (FeatureTypeRelation)iterator.next()).getType().equals("relate") || !(relFt = rel.getForeignFeatureType()).getTypeName().equals(typeNameToGet) && typeNameToGet != null)) {
        }
        return relFt;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void reportIndividualData(JSONObject json) throws Exception {
        SimpleFeatureCollection mainFSinMem;
        ArrayList<String> tPropnames = new ArrayList<String>(this.attrNames);
        nl.b3p.viewer.config.services.SimpleFeatureType ft = this.layer.getFeatureType();
        List featureTypeAttributes = ft.getAttributes();
        SimpleFeatureSource fs = (SimpleFeatureSource)ft.openGeoToolsFeatureSource();
        ArrayList<String> foreignAttrNames = new ArrayList<String>();
        for (String a : this.attrNames) {
            if (((SimpleFeatureType)fs.getSchema()).getDescriptor(a) != null) continue;
            foreignAttrNames.add(a);
            tPropnames.remove(a);
        }
        foreignAttrNames.add(TERREINID_RELATED_FIELDNAME);
        tPropnames.add(TERREINID_FIELDNAME);
        Filter filter = ECQL.toFilter((String)this.gebiedsNaamQuery);
        Query q = new Query(fs.getName().toString());
        q.setPropertyNames(tPropnames);
        q.setFilter(filter);
        q.setHandle("individueel-rapport");
        q.setMaxFeatures(1000);
        try {
            mainFSinMem = DataUtilities.collection((SimpleFeatureIterator)fs.getFeatures(q).features());
        }
        finally {
            fs.getDataStore().dispose();
        }
        if (!foreignAttrNames.isEmpty()) {
            nl.b3p.viewer.config.services.SimpleFeatureType relFt = this.getRelatedSFT(ft, RELATED_FT_NAME);
            SimpleFeatureSource foreignFs = (SimpleFeatureSource)relFt.openGeoToolsFeatureSource();
            StringBuilder in = new StringBuilder();
            HashMap<Integer, SimpleFeature> parentFeatures = new HashMap<Integer, SimpleFeature>();
            SimpleFeatureIterator inMemFeats = mainFSinMem.features();
            while (inMemFeats.hasNext()) {
                SimpleFeature f = (SimpleFeature)inMemFeats.next();
                in.append(f.getAttribute(TERREINID_FIELDNAME)).append(",");
                parentFeatures.put((Integer)f.getAttribute(TERREINID_FIELDNAME), f);
            }
            inMemFeats.close();
            Query foreignQ = new Query(foreignFs.getName().toString());
            foreignQ.setHandle("individueel-rapport-related");
            foreignQ.setPropertyNames(foreignAttrNames);
            String query = "terreinid IN (" + in.substring(0, in.length() - 1) + ")";
            log.debug((Object)("individueel-rapport-related: " + query));
            foreignQ.setFilter(ECQL.toFilter((String)query));
            try {
                SimpleFeatureCollection relatedFC = foreignFs.getFeatures(foreignQ);
                SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
                tb.setName("COMPOSITE");
                for (String prop : this.attrNames) {
                    AttributeDescriptor attrDescName = ((SimpleFeatureType)fs.getSchema()).getDescriptor(prop);
                    if (attrDescName == null) {
                        attrDescName = ((SimpleFeatureType)foreignFs.getSchema()).getDescriptor(prop);
                    }
                    tb.add(attrDescName);
                }
                tb.add(TERREINID_RELATED_FIELDNAME, Integer.class);
                SimpleFeatureType type = tb.buildFeatureType();
                featureTypeAttributes.addAll(relFt.getAttributes());
                SimpleFeatureBuilder sfBuilder = new SimpleFeatureBuilder(type);
                SimpleFeatureIterator sfcIter = relatedFC.features();
                ArrayList<SimpleFeature> newfeats = new ArrayList<SimpleFeature>();
                while (sfcIter.hasNext()) {
                    SimpleFeature f = (SimpleFeature)sfcIter.next();
                    SimpleFeature n = SimpleFeatureBuilder.retype((SimpleFeature)f, (SimpleFeatureBuilder)sfBuilder);
                    SimpleFeature p = (SimpleFeature)parentFeatures.get((Integer)f.getAttribute(TERREINID_RELATED_FIELDNAME));
                    for (Property a : p.getProperties()) {
                        if (!this.attrNames.contains(a.getName().toString())) continue;
                        n.setAttribute(a.getName(), a.getValue());
                    }
                    newfeats.add(n);
                }
                sfcIter.close();
                mainFSinMem = DataUtilities.collection(newfeats);
            }
            finally {
                foreignFs.getDataStore().dispose();
            }
        }
        this.featuresToJson(mainFSinMem, json, featureTypeAttributes, this.attrNames);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    private void reportAggregateData(JSONObject json) throws Exception {
        ft = this.layer.getFeatureType();
        featureTypeAttributes = ft.getAttributes();
        fs = (SimpleFeatureSource)ft.openGeoToolsFeatureSource();
        tPropnames = new ArrayList<String>(this.attrNames);
        foreignAttrNames = new ArrayList<String>();
        for (String a : this.attrNames) {
            if (((SimpleFeatureType)fs.getSchema()).getDescriptor(a) != null) continue;
            foreignAttrNames.add(a);
            tPropnames.remove(a);
        }
        foreignAttrNames.add("terreinid");
        tPropnames.add("id");
        tPropnames.add("naam");
        tPropnames.add("vvr_naam");
        tPropnames.add("a_plannaam");
        filter = ECQL.toFilter((String)this.gebiedsNaamQuery);
        q = new Query(fs.getName().toString());
        q.setPropertyNames(tPropnames);
        q.setFilter(filter);
        q.setHandle("aggregatie-rapport");
        q.setMaxFeatures(1000);
        IbisAttributeListActionBean.log.debug((Object)("aggregatie query:" + q));
        try {
            tb = new SimpleFeatureTypeBuilder();
            tb.setName("AGGREGATE");
            for (String prop : tPropnames) {
                attrDescName = ((SimpleFeatureType)fs.getSchema()).getDescriptor(prop);
                if (attrDescName == null) continue;
                tb.add(attrDescName);
            }
            tb.add("gebied", String.class);
            g = new nl.b3p.viewer.config.services.AttributeDescriptor();
            g.setName("gebied");
            g.setAlias("gebiedsnaam");
            g.setType("string");
            featureTypeAttributes.add(0, g);
            sfc = DataUtilities.collection((SimpleFeatureIterator)fs.getFeatures(q).features());
            if (!foreignAttrNames.isEmpty()) {
                relFt = this.getRelatedSFT(ft, IbisAttributeListActionBean.RELATED_FT_NAME);
                foreignFs = (SimpleFeatureSource)relFt.openGeoToolsFeatureSource();
                for (String prop : foreignAttrNames) {
                    attrDescName = ((SimpleFeatureType)foreignFs.getSchema()).getDescriptor(prop);
                    if (attrDescName == null) continue;
                    tb.add(attrDescName);
                }
                tb.add("terreinid", Integer.class);
                type = tb.buildFeatureType();
                featureTypeAttributes.addAll(relFt.getAttributes());
                in = new StringBuilder();
                parentFeatures = new HashMap<Integer, SimpleFeature>();
                inMemFeats = sfc.features();
                while (inMemFeats.hasNext()) {
                    f = (SimpleFeature)inMemFeats.next();
                    in.append(f.getAttribute("id")).append(",");
                    parentFeatures.put((Integer)f.getAttribute("id"), f);
                }
                inMemFeats.close();
                foreignQ = new Query(foreignFs.getName().toString());
                foreignQ.setHandle("aggregatie-rapport-related");
                foreignQ.setPropertyNames(foreignAttrNames);
                query = "terreinid IN (" + in.substring(0, in.length() - 1) + ")";
                IbisAttributeListActionBean.log.debug((Object)("aggregatie-rapport-related: " + query));
                foreignQ.setFilter(ECQL.toFilter((String)query));
                try {
                    relatedFC = foreignFs.getFeatures(foreignQ);
                    sfBuilder = new SimpleFeatureBuilder(type);
                    sfcIter = relatedFC.features();
                    newfeats = new ArrayList<SimpleFeature>();
                    firsttimeForP = true;
                    firsttimeForPSet = new HashSet<SimpleFeature>();
                    while (sfcIter.hasNext()) {
                        f = (SimpleFeature)sfcIter.next();
                        n = SimpleFeatureBuilder.retype((SimpleFeature)f, (SimpleFeatureBuilder)sfBuilder);
                        p = (SimpleFeature)parentFeatures.get((Integer)f.getAttribute("terreinid"));
                        for (Property a : p.getProperties()) {
                            if (firsttimeForPSet.contains(p)) {
                                if (this.attrNames.contains(a.getName().toString())) continue;
                                n.setAttribute(a.getName(), a.getValue());
                                continue;
                            }
                            if (!tPropnames.contains(a.getName().toString())) continue;
                            n.setAttribute(a.getName(), a.getValue());
                        }
                        newfeats.add(n);
                        firsttimeForPSet.add(p);
                    }
                    sfcIter.close();
                    sfc = DataUtilities.collection(newfeats);
                }
                finally {
                    foreignFs.getDataStore().dispose();
                }
            } else {
                type = tb.buildFeatureType();
            }
            regions = new HashSet<String>();
            switch (4.$SwitchMap$nl$b3p$viewer$stripes$IbisAttributeListActionBean$QueryArea[this.aggregationLevel.ordinal()]) {
                case 1: {
                    regions.add(this.regio);
                    sfc = this.aggregateFields(sfc, type, regions, this.attrNames, "vvr_naam");
                    break;
                }
                case 2: {
                    if (this.areaType != QueryArea.TERREIN) ** GOTO lbl117
                    regions.add(this.gemeente);
                    ** GOTO lbl128
lbl117:
                    // 1 sources

                    iter = sfc.features();
                    try {
                        while (iter.hasNext()) {
                            f = (SimpleFeature)iter.next();
                            regions.add((String)f.getAttribute("naam"));
                        }
                    }
                    finally {
                        iter.close();
                    }
lbl128:
                    // 2 sources

                    sfc = this.aggregateFields(sfc, type, regions, this.attrNames, "naam");
                    break;
                }
                case 3: {
                    if (this.areaType != QueryArea.TERREIN) ** GOTO lbl135
                    regions.add(this.terrein);
                    ** GOTO lbl146
lbl135:
                    // 1 sources

                    iter = sfc.features();
                    try {
                        while (iter.hasNext()) {
                            f = (SimpleFeature)iter.next();
                            regions.add((String)f.getAttribute("a_plannaam"));
                        }
                    }
                    finally {
                        iter.close();
                    }
lbl146:
                    // 2 sources

                    sfc = this.aggregateFields(sfc, type, regions, this.attrNames, "a_plannaam");
                }
            }
            this.attrNames.add("gebied");
            this.featuresToJson(sfc, json, featureTypeAttributes, this.attrNames);
        }
        finally {
            fs.getDataStore().dispose();
        }
    }

    private SimpleFeatureCollection aggregateFields(SimpleFeatureCollection sfc, SimpleFeatureType type, Set<String> featNames, List<String> aggregateFieldNames, String gebiedFieldName) {
        TreeMap<String, SimpleFeature> newfeats = new TreeMap<String, SimpleFeature>();
        for (String fName : featNames) {
            SimpleFeature newfeat = DataUtilities.template((SimpleFeatureType)type);
            for (String aggrName : aggregateFieldNames) {
                newfeat.setAttribute(aggrName, (Object)0);
            }
            newfeat.setAttribute(GEBIED_FIELDNAME, (Object)fName);
            newfeats.put(fName, newfeat);
        }
        SimpleFeatureIterator items = sfc.features();
        while (items.hasNext()) {
            SimpleFeature f = (SimpleFeature)items.next();
            SimpleFeature newFeat = (SimpleFeature)newfeats.get((String)f.getAttribute(gebiedFieldName));
            for (String aggrFieldName : aggregateFieldNames) {
                if (f.getAttribute(aggrFieldName) == null) continue;
                newFeat.setAttribute(aggrFieldName, (Object)(((Number)newFeat.getAttribute(aggrFieldName)).doubleValue() + ((Number)f.getAttribute(aggrFieldName)).doubleValue()));
            }
        }
        items.close();
        ArrayList feats = new ArrayList(newfeats.values());
        return DataUtilities.collection(feats);
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public String getFilename() {
        return this.filename;
    }

    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getMimetype() {
        return this.mimetype;
    }

    public void setMimetype(String mimetype) {
        this.mimetype = mimetype;
    }

    public void setContext(ActionBeanContext context) {
        this.context = context;
    }

    public ActionBeanContext getContext() {
        return this.context;
    }

    public Application getApplication() {
        return this.application;
    }

    public void setApplication(Application application) {
        this.application = application;
    }

    public ApplicationLayer getAppLayer() {
        return this.appLayer;
    }

    public void setAppLayer(ApplicationLayer appLayer) {
        this.appLayer = appLayer;
    }

    public String getRegio() {
        return this.regio;
    }

    public void setRegio(String regio) {
        this.regio = regio;
    }

    public String getGemeente() {
        return this.gemeente;
    }

    public void setGemeente(String gemeente) {
        this.gemeente = gemeente;
    }

    public String getTerrein() {
        return this.terrein;
    }

    public void setTerrein(String terrein) {
        this.terrein = terrein;
    }

    public ReportType getReportType() {
        return this.reportType;
    }

    public void setReportType(ReportType reportType) {
        this.reportType = reportType;
    }

    public QueryArea getAggregationLevel() {
        return this.aggregationLevel;
    }

    public void setAggregationLevel(QueryArea aggregationLevel) {
        this.aggregationLevel = aggregationLevel;
    }

    public AggregationLevelDate getAggregationLevelDate() {
        return this.aggregationLevelDate;
    }

    public void setAggregationLevelDate(AggregationLevelDate aggregationLevelDate) {
        this.aggregationLevelDate = aggregationLevelDate;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public List<String> getAttrNames() {
        return this.attrNames;
    }

    public void setAttrNames(List<String> attrNames) {
        this.attrNames = attrNames;
    }
}

