/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.image;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javax.servlet.http.HttpServletRequest;
import nl.b3p.viewer.image.ArcImsImageCollector;
import nl.b3p.viewer.image.ArcServerImageCollector;
import nl.b3p.viewer.image.CombineArcIMSUrl;
import nl.b3p.viewer.image.CombineArcServerUrl;
import nl.b3p.viewer.image.CombineImageUrl;
import nl.b3p.viewer.image.CombineStaticImageUrl;
import nl.b3p.viewer.image.CombineWmsUrl;
import nl.b3p.viewer.image.ImageCollector;
import nl.b3p.viewer.image.ReferencedImage;
import org.apache.commons.httpclient.Credentials;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpConnectionManager;
import org.apache.commons.httpclient.MultiThreadedHttpConnectionManager;
import org.apache.commons.httpclient.UsernamePasswordCredentials;
import org.apache.commons.httpclient.auth.AuthScope;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ImageManager {
    private final Log log = LogFactory.getLog(this.getClass());
    private List<ImageCollector> ics = new ArrayList();
    private int maxResponseTime = 10000;
    private int MAX_TREADS = 8;
    private ExecutorService threadPool = Executors.newFixedThreadPool(this.MAX_TREADS);
    private CompletionService<ImageCollector> pool = new ExecutorCompletionService(this.threadPool);
    protected static final String host = AuthScope.ANY_HOST;
    protected static final int port = -1;

    public ImageManager(List urls, int maxResponseTime, HttpServletRequest req) {
        this(urls, maxResponseTime, null, null, req);
    }

    public ImageManager(List<CombineImageUrl> urls, int maxResponseTime, String uname, String pw, HttpServletRequest req) {
        this.maxResponseTime = maxResponseTime;
        if (urls == null || urls.size() <= 0) {
            return;
        }
        MultiThreadedHttpConnectionManager connectionManager = new MultiThreadedHttpConnectionManager();
        HttpClient client = new HttpClient((HttpConnectionManager)connectionManager);
        client.getHttpConnectionManager().getParams().setConnectionTimeout(this.maxResponseTime);
        if (uname != null && pw != null) {
            client.getParams().setAuthenticationPreemptive(true);
            UsernamePasswordCredentials defaultcreds = new UsernamePasswordCredentials(uname, pw);
            AuthScope authScope = new AuthScope(host, -1);
            client.getState().setCredentials(authScope, (Credentials)defaultcreds);
        }
        for (CombineImageUrl ciu : urls) {
            Object ic = null;
            ic = ciu instanceof CombineWmsUrl ? new ImageCollector(ciu, maxResponseTime, client, uname, pw, req) : (ciu instanceof CombineArcIMSUrl ? new ArcImsImageCollector(ciu, maxResponseTime, client, req) : (ciu instanceof CombineArcServerUrl ? new ArcServerImageCollector(ciu, maxResponseTime, client, req) : new ImageCollector(ciu, maxResponseTime, client, uname, pw, req)));
            this.ics.add(ic);
        }
    }

    public void process() throws Exception {
        for (ImageCollector ic : this.ics) {
            if (ic.getStatus() != 0) continue;
            this.pool.submit(ic);
        }
        for (int i = 0; i < this.ics.size(); ++i) {
            this.pool.poll(5L, TimeUnit.MINUTES).get();
        }
    }

    public void shutdown() {
        this.threadPool.shutdown();
    }

    public List<ReferencedImage> getCombinedImages() throws Exception {
        ImageCollector ic = null;
        Iterator it = this.ics.iterator();
        ArrayList<ReferencedImage> allImages = new ArrayList<ReferencedImage>();
        while (it.hasNext()) {
            ic = (ImageCollector)it.next();
            int status = ic.getStatus();
            if (status == 4 || ic.getBufferedImage() == null) {
                this.log.error((Object)(ic.getMessage() + " (Status: " + status + ")"));
                continue;
            }
            if (status != 2) {
                this.log.error((Object)(ic.getMessage() + " (Status: " + status + ")"));
                continue;
            }
            ReferencedImage image = new ReferencedImage(ic.getBufferedImage());
            CombineImageUrl ciu = ic.getCombinedImageUrl();
            image.setAlpha(ciu.getAlpha());
            if (ciu instanceof CombineStaticImageUrl) {
                CombineStaticImageUrl csiu = (CombineStaticImageUrl)ciu;
                image.setHeight(csiu.getHeight());
                image.setWidth(csiu.getWidth());
                image.setX(csiu.getX());
                image.setY(csiu.getY());
            }
            allImages.add(image);
        }
        if (allImages.size() > 0) {
            return allImages;
        }
        return null;
    }
}

