/*
 * Decompiled with CFR 0.152.
 */
package nl.b3p.viewer.stripes;

import com.vividsolutions.jts.geom.Geometry;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.persistence.EntityManager;
import net.sourceforge.stripes.action.StrictBinding;
import net.sourceforge.stripes.action.UrlBinding;
import nl.b3p.viewer.config.app.Application;
import nl.b3p.viewer.config.services.Layer;
import nl.b3p.viewer.ibis.util.IbisConstants;
import nl.b3p.viewer.ibis.util.WorkflowStatus;
import nl.b3p.viewer.ibis.util.WorkflowUtil;
import nl.b3p.viewer.stripes.SplitFeatureActionBean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.feature.FeatureCollection;
import org.geotools.util.Converter;
import org.geotools.util.GeometryTypeConverterFactory;
import org.json.JSONException;
import org.json.JSONObject;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryType;
import org.opengis.filter.Filter;
import org.opengis.filter.identity.FeatureId;
import org.stripesstuff.stripersist.Stripersist;

@UrlBinding(value="/action/feature/ibissplit")
@StrictBinding
public class IbisSplitFeatureActionBean
extends SplitFeatureActionBean
implements IbisConstants {
    private static final Log log = LogFactory.getLog(IbisSplitFeatureActionBean.class);
    private Object terreinID = null;
    private WorkflowStatus newWorkflowStatus = WorkflowStatus.definitief;
    private double sliverRatio;
    private double sliverMaxArea;

    protected List<SimpleFeature> handleExtraData(List<SimpleFeature> features) throws JSONException {
        JSONObject json = new JSONObject(this.getExtraData());
        this.sliverMaxArea = json.getDouble("sliverMaxArea");
        json.remove("sliverMaxArea");
        this.sliverRatio = json.getDouble("sliverRatio");
        json.remove("sliverRatio");
        Iterator items = json.keys();
        while (items.hasNext()) {
            String key = (String)items.next();
            for (SimpleFeature f : features) {
                log.debug((Object)String.format("Setting value: %s for attribute: %s on feature %s", json.get(key), key, f.getID()));
                f.setAttribute(key, json.get(key));
                if (!key.equalsIgnoreCase("workflow_status")) continue;
                this.newWorkflowStatus = WorkflowStatus.valueOf((String)json.getString(key));
            }
        }
        if ((features = this.resolveSlivers(features)).size() < 2) {
            throw new IllegalArgumentException("Splits mislukt, de oppervlakte van afgesplitste deel is kleiner dan de drempel (" + this.sliverMaxArea + ") of de omtrek/oppervlakte ratio is te klein.");
        }
        return features;
    }

    protected List<FeatureId> handleStrategy(SimpleFeature feature, List<? extends Geometry> geoms, Filter filter, SimpleFeatureStore localStore, String localStrategy) throws Exception {
        if (!this.getLayer().getName().equalsIgnoreCase("bedrijvenkavels")) {
            throw new IllegalArgumentException("Aborting as split layer is not bedrijvenkavels");
        }
        List<SimpleFeature> newFeats = new ArrayList();
        GeometryTypeConverterFactory cf = new GeometryTypeConverterFactory();
        Converter c = cf.createConverter(Geometry.class, ((SimpleFeatureType)localStore.getSchema()).getGeometryDescriptor().getType().getBinding(), null);
        GeometryType type = ((SimpleFeatureType)localStore.getSchema()).getGeometryDescriptor().getType();
        String geomAttribute = ((SimpleFeatureType)localStore.getSchema()).getGeometryDescriptor().getLocalName();
        boolean firstFeature = true;
        int newID = (int)(new Date().getTime() / 1000L);
        for (Geometry geometry : geoms) {
            log.debug((Object)("Creating feature with geom length: " + geometry.getLength()));
            if (firstFeature) {
                if (localStrategy.equalsIgnoreCase("add")) {
                    feature.setAttribute("workflow_status", (Object)WorkflowStatus.archief);
                    Object[] attributevalues = feature.getAttributes().toArray(new Object[feature.getAttributeCount()]);
                    AttributeDescriptor[] attributes = feature.getFeatureType().getAttributeDescriptors().toArray(new AttributeDescriptor[feature.getAttributeCount()]);
                    localStore.modifyFeatures(attributes, attributevalues, filter);
                    this.terreinID = feature.getAttribute("terreinid");
                    SimpleFeature newFeat = DataUtilities.createFeature((SimpleFeatureType)feature.getType(), (String)DataUtilities.encodeFeature((SimpleFeature)feature, (boolean)false));
                    newFeat.setAttribute(geomAttribute, c.convert((Object)geometry, type.getBinding()));
                    log.debug((Object)("First split feature has ibis id: " + newFeat.getAttribute("ibis_id")));
                    newFeats.add(newFeat);
                    firstFeature = false;
                    continue;
                }
                throw new IllegalArgumentException("Unknown or unsupported strategy '" + localStrategy + "', cannot split.");
            }
            SimpleFeature newFeat = DataUtilities.createFeature((SimpleFeatureType)feature.getType(), (String)DataUtilities.encodeFeature((SimpleFeature)feature, (boolean)false));
            newFeat.setAttribute(geomAttribute, c.convert((Object)geometry, type.getBinding()));
            newFeat.setAttribute("ibis_id", (Object)newID++);
            log.debug((Object)("Created new feature with ibis id: " + newID));
            newFeats.add(newFeat);
        }
        newFeats = this.handleExtraData(newFeats);
        return localStore.addFeatures((FeatureCollection)DataUtilities.collection(newFeats));
    }

    protected void afterSplit(List<FeatureId> ids) {
        if (this.terreinID != null) {
            WorkflowUtil.updateTerreinGeometry((Integer)Integer.parseInt(this.terreinID.toString()), (Layer)this.getLayer(), (WorkflowStatus)this.newWorkflowStatus, (Application)this.getApplication(), (EntityManager)Stripersist.getEntityManager());
        }
    }

    private List<SimpleFeature> resolveSlivers(List<SimpleFeature> features) {
        List<SimpleFeature> nonSlivers = features;
        if (this.sliverRatio > 0.0) {
            Geometry g;
            ArrayList<SimpleFeature> slivers = new ArrayList<SimpleFeature>();
            nonSlivers = new ArrayList<SimpleFeature>();
            for (SimpleFeature f : features) {
                g = (Geometry)f.getDefaultGeometry();
                if (g.getArea() <= this.sliverMaxArea && Math.PI * 4 * (g.getArea() / (g.getLength() * g.getLength())) < this.sliverRatio) {
                    log.debug((Object)("Sliver gevonden: " + f));
                    slivers.add(f);
                    continue;
                }
                nonSlivers.add(f);
            }
            for (SimpleFeature f : nonSlivers) {
                g = (Geometry)f.getDefaultGeometry();
                ArrayList<SimpleFeature> sliversToRemove = new ArrayList<SimpleFeature>();
                for (SimpleFeature s : slivers) {
                    Geometry sg = (Geometry)s.getDefaultGeometry();
                    if (!sg.touches(g)) continue;
                    log.debug((Object)("Samenvoegen van sliver: " + s + " met: " + g));
                    g = sg.union(g);
                    sliversToRemove.add(s);
                }
                f.setDefaultGeometry((Object)g);
                slivers.removeAll(sliversToRemove);
            }
            if (!slivers.isEmpty()) {
                log.warn((Object)"Niet alle slivers zijn opgelost. Overblijvers:");
                for (SimpleFeature s : slivers) {
                    log.warn((Object)("  overblijvende sliver: " + s));
                }
            }
        }
        return nonSlivers;
    }

    public double getSliverRatio() {
        return this.sliverRatio;
    }

    public void setSliverRatio(double sliverRatio) {
        this.sliverRatio = sliverRatio;
    }

    public double getSliverMaxArea() {
        return this.sliverMaxArea;
    }

    public void setSliverMaxArea(double sliverMaxArea) {
        this.sliverMaxArea = sliverMaxArea;
    }
}

